/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel;

import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jbi.component.ComponentContext;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.servicemix.camel.JbiBinding;
import org.apache.servicemix.camel.JbiEndpoint;
import org.apache.servicemix.camel.JbiException;
import org.apache.servicemix.common.endpoints.ConsumerEndpoint;
import org.apache.servicemix.id.IdGenerator;
import org.apache.servicemix.jbi.FaultException;
import org.apache.servicemix.jbi.resolver.URIResolver;

public class CamelConsumerEndpoint
extends ConsumerEndpoint
implements AsyncProcessor {
    public static final QName SERVICE_NAME = new QName("http://activemq.apache.org/camel/schema/jbi", "consumer");
    private JbiBinding binding;
    private JbiEndpoint jbiEndpoint;
    private Map<String, AsyncCallback> callbacks = new ConcurrentHashMap<String, AsyncCallback>();
    private Map<String, Exchange> exchanges = new ConcurrentHashMap<String, Exchange>();

    public CamelConsumerEndpoint(JbiBinding binding, JbiEndpoint jbiEndpoint) {
        this.setService(SERVICE_NAME);
        this.setEndpoint(new IdGenerator().generateId());
        this.binding = binding;
        this.jbiEndpoint = jbiEndpoint;
    }

    public void process(MessageExchange messageExchange) throws Exception {
        Exchange exchange = this.exchanges.remove(messageExchange.getExchangeId());
        if (exchange == null) {
            String message = String.format("Unable to find Camel Exchange for JBI MessageExchange %s", messageExchange.getExchangeId());
            this.logger.warn((Object)message);
            if (messageExchange.getStatus() == ExchangeStatus.ACTIVE) {
                this.fail(messageExchange, (Exception)((Object)new JbiException(message)));
            }
        } else {
            this.processReponse(messageExchange, exchange);
        }
        AsyncCallback asyncCallback = this.callbacks.remove(messageExchange.getExchangeId());
        if (asyncCallback == null) {
            this.logger.warn((Object)String.format("Unable to find Camel AsyncCallback for JBI MessageExchange %s", messageExchange.getExchangeId()));
        } else {
            asyncCallback.done(false);
        }
    }

    public boolean process(Exchange exchange, AsyncCallback asyncCallback) {
        try {
            MessageExchange messageExchange = this.binding.makeJbiMessageExchange(exchange, this.getExchangeFactory(), this.jbiEndpoint.getMep());
            if (this.jbiEndpoint.getOperation() != null) {
                messageExchange.setOperation(QName.valueOf(this.jbiEndpoint.getOperation()));
            }
            URIResolver.configureExchange((MessageExchange)messageExchange, (ComponentContext)this.getContext(), (String)this.jbiEndpoint.getDestinationUri());
            this.exchanges.put(messageExchange.getExchangeId(), exchange);
            this.callbacks.put(messageExchange.getExchangeId(), asyncCallback);
            this.send(messageExchange);
            return false;
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            asyncCallback.done(true);
            return true;
        }
    }

    public void process(Exchange exchange) throws Exception {
        try {
            MessageExchange messageExchange = this.binding.makeJbiMessageExchange(exchange, this.getExchangeFactory(), this.jbiEndpoint.getMep());
            if (this.jbiEndpoint.getOperation() != null) {
                messageExchange.setOperation(QName.valueOf(this.jbiEndpoint.getOperation()));
            }
            URIResolver.configureExchange((MessageExchange)messageExchange, (ComponentContext)this.getContext(), (String)this.jbiEndpoint.getDestinationUri());
            this.sendSync(messageExchange);
            this.processReponse(messageExchange, exchange);
        }
        catch (MessagingException e) {
            exchange.setException((Throwable)e);
            throw new JbiException(e);
        }
        catch (URISyntaxException e) {
            exchange.setException((Throwable)e);
            throw new JbiException(e);
        }
    }

    public String getLocationURI() {
        return null;
    }

    private void processReponse(MessageExchange messageExchange, Exchange exchange) throws MessagingException {
        if (messageExchange.getStatus() == ExchangeStatus.ERROR) {
            exchange.setException((Throwable)messageExchange.getError());
        } else if (messageExchange.getStatus() == ExchangeStatus.ACTIVE) {
            this.addHeaders(messageExchange, exchange);
            if (messageExchange.getFault() != null) {
                exchange.getFault().setBody((Object)new FaultException("Fault occured for " + exchange.getPattern() + " exchange", messageExchange, messageExchange.getFault()));
                this.addHeaders((NormalizedMessage)messageExchange.getFault(), exchange.getFault());
                this.addAttachments((NormalizedMessage)messageExchange.getFault(), exchange.getFault());
            } else if (messageExchange.getMessage("out") != null) {
                exchange.getOut().setBody((Object)messageExchange.getMessage("out").getContent());
                this.addHeaders(messageExchange.getMessage("out"), exchange.getOut());
                this.addAttachments(messageExchange.getMessage("out"), exchange.getOut());
            }
            this.done(messageExchange);
        }
    }

    public void validate() throws DeploymentException {
    }

    private void addHeaders(MessageExchange messageExchange, Exchange camelExchange) {
        Set entries = messageExchange.getPropertyNames();
        for (Object o : entries) {
            String key = o.toString();
            camelExchange.setProperty(key, messageExchange.getProperty(key));
        }
    }

    private void addHeaders(NormalizedMessage normalizedMessage, Message camelMessage) {
        Set entries = normalizedMessage.getPropertyNames();
        for (Object o : entries) {
            String key = o.toString();
            camelMessage.setHeader(key, normalizedMessage.getProperty(key));
        }
    }

    private void addAttachments(NormalizedMessage normalizedMessage, Message camelMessage) {
        Set entries = normalizedMessage.getAttachmentNames();
        for (Object o : entries) {
            String id = o.toString();
            camelMessage.addAttachment(id, normalizedMessage.getAttachment(id));
        }
    }
}

