/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jbi.management.DeploymentException;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.EndpointSupport;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.common.ServiceUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultServiceUnit
implements ServiceUnit {
    protected ServiceMixComponent component;
    protected String name;
    protected String rootPath;
    protected String status = "Shutdown";
    protected Map<String, Endpoint> endpoints = new LinkedHashMap<String, Endpoint>();

    public DefaultServiceUnit() {
    }

    public DefaultServiceUnit(ServiceMixComponent component) {
        this.component = component;
    }

    @Override
    public synchronized void init() throws Exception {
        if (this.status == "Shutdown") {
            ArrayList<Endpoint> activated = new ArrayList<Endpoint>();
            try {
                for (Endpoint endpoint : this.getEndpoints()) {
                    endpoint.activate();
                    activated.add(endpoint);
                }
                this.status = "Stopped";
            }
            catch (Exception e) {
                for (Endpoint endpoint : activated) {
                    try {
                        endpoint.deactivate();
                    }
                    catch (Exception e2) {}
                }
                throw e;
            }
        }
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.status == "Stopped") {
            ArrayList activated = new ArrayList();
            try {
                for (Endpoint endpoint : this.getEndpoints()) {
                    endpoint.start();
                }
                this.status = "Started";
            }
            catch (Exception e) {
                for (Endpoint endpoint : activated) {
                    try {
                        endpoint.stop();
                    }
                    catch (Exception e2) {}
                }
                throw e;
            }
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        if (this.status == "Started") {
            this.status = "Stopped";
            Exception exception = null;
            for (Endpoint endpoint : this.getEndpoints()) {
                try {
                    endpoint.stop();
                }
                catch (Exception e) {
                    exception = e;
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
    }

    @Override
    public synchronized void shutDown() throws Exception {
        if (this.status == "Started") {
            this.stop();
        }
        if (this.status == "Stopped") {
            this.status = "Shutdown";
            Exception exception = null;
            for (Endpoint endpoint : this.getEndpoints()) {
                try {
                    endpoint.deactivate();
                }
                catch (Exception e) {
                    exception = e;
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
    }

    @Override
    public String getCurrentState() {
        return this.status;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    @Override
    public ServiceMixComponent getComponent() {
        return this.component;
    }

    public void setComponent(ServiceMixComponent component) {
        this.component = component;
    }

    @Override
    public Collection<Endpoint> getEndpoints() {
        return this.endpoints.values();
    }

    @Override
    public synchronized void addEndpoint(Endpoint endpoint) throws DeploymentException {
        String key = endpoint.getKey();
        if (this.endpoints.put(key, endpoint) != null) {
            throw new DeploymentException("More than one endpoint found in the SU for key: " + key);
        }
        if (this.status == "Stopped") {
            try {
                endpoint.activate();
            }
            catch (Exception e) {
                throw new DeploymentException((Throwable)e);
            }
        }
        if (this.status == "Started") {
            try {
                endpoint.activate();
                endpoint.start();
            }
            catch (Exception e) {
                throw new DeploymentException((Throwable)e);
            }
        }
    }

    @Override
    public synchronized void removeEndpoint(Endpoint endpoint) throws DeploymentException {
        String key = endpoint.getKey();
        if (this.endpoints.remove(key) == null) {
            throw new DeploymentException("Endpoint not found in the SU for key: " + EndpointSupport.getKey(endpoint));
        }
        if (this.status == "Stopped") {
            try {
                this.component.prepareShutdown(endpoint);
                endpoint.deactivate();
            }
            catch (Exception e) {
                throw new DeploymentException((Throwable)e);
            }
        }
        if (this.status == "Started") {
            try {
                endpoint.stop();
                this.component.prepareShutdown(endpoint);
                endpoint.deactivate();
            }
            catch (Exception e) {
                throw new DeploymentException((Throwable)e);
            }
        }
    }

    public Endpoint getEndpoint(String key) {
        return this.endpoints.get(key);
    }

    @Override
    public ClassLoader getConfigurationClassLoader() {
        return this.component.getClass().getClassLoader();
    }
}

