/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common.xbean;

import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleBeanFactory
implements BeanFactory {
    private final Map beans;

    public SimpleBeanFactory(Map beans) {
        this.beans = beans;
    }

    public boolean containsBean(String name) {
        return this.beans.containsKey(name);
    }

    public String[] getAliases(String name) throws NoSuchBeanDefinitionException {
        Object bean = this.beans.get(name);
        if (bean == null) {
            throw new NoSuchBeanDefinitionException(name);
        }
        return new String[0];
    }

    public Object getBean(String name) throws BeansException {
        return this.getBean(name, (Class)null);
    }

    public <T> T getBean(Class<T> type) throws BeansException {
        T result = null;
        for (Object bean : this.beans.values()) {
            if (!type.isAssignableFrom(bean.getClass())) continue;
            if (result != null) {
                throw new NoSuchBeanDefinitionException(type, "Found multiple beans matching type " + type);
            }
            result = (T)bean;
        }
        if (result == null) {
            throw new NoSuchBeanDefinitionException(type, "No bean found matching type " + type);
        }
        return result;
    }

    public Object getBean(String name, Class requiredType) throws BeansException {
        Object bean = this.beans.get(name);
        if (bean == null) {
            throw new NoSuchBeanDefinitionException(name);
        }
        if (requiredType != null && !requiredType.isInstance(bean)) {
            throw new BeanNotOfRequiredTypeException(name, requiredType, bean.getClass());
        }
        return bean;
    }

    public Object getBean(String name, Object[] args) throws BeansException {
        if (args != null) {
            throw new BeanDefinitionStoreException("Bean is not a prototype");
        }
        return this.getBean(name, (Class)null);
    }

    public Class getType(String name) throws NoSuchBeanDefinitionException {
        Object bean = this.beans.get(name);
        if (bean == null) {
            throw new NoSuchBeanDefinitionException(name);
        }
        return bean.getClass();
    }

    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        Object bean = this.beans.get(name);
        if (bean == null) {
            throw new NoSuchBeanDefinitionException(name);
        }
        return true;
    }

    public boolean isTypeMatch(String name, Class targetType) throws NoSuchBeanDefinitionException {
        if (!this.beans.containsKey(name)) {
            throw new NoSuchBeanDefinitionException(name);
        }
        if (targetType == null || Object.class.equals((Object)targetType)) {
            return true;
        }
        return targetType.isAssignableFrom(this.beans.get(name).getClass());
    }

    public boolean isPrototype(String name) {
        return false;
    }
}

