/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common;

import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.xml.namespace.QName;
import org.apache.servicemix.common.Endpoint;

public class EndpointDeliveryChannel
implements DeliveryChannel {
    private static final ThreadLocal<Endpoint> ENDPOINT_TLS = new ThreadLocal();
    private final DeliveryChannel channel;
    private final Endpoint endpoint;

    public EndpointDeliveryChannel(Endpoint endpoint) throws MessagingException {
        this.endpoint = endpoint;
        this.channel = endpoint.getServiceUnit().getComponent().getComponentContext().getDeliveryChannel();
    }

    public EndpointDeliveryChannel(ComponentContext context) throws MessagingException {
        this.endpoint = null;
        this.channel = context.getDeliveryChannel();
    }

    public MessageExchange accept() throws MessagingException {
        throw new UnsupportedOperationException();
    }

    public MessageExchange accept(long timeout) throws MessagingException {
        throw new UnsupportedOperationException();
    }

    public void close() throws MessagingException {
        throw new UnsupportedOperationException();
    }

    public MessageExchangeFactory createExchangeFactory() {
        return this.channel.createExchangeFactory();
    }

    public MessageExchangeFactory createExchangeFactory(QName interfaceName) {
        return this.channel.createExchangeFactory(interfaceName);
    }

    public MessageExchangeFactory createExchangeFactory(ServiceEndpoint endpoint) {
        return this.channel.createExchangeFactory(endpoint);
    }

    public MessageExchangeFactory createExchangeFactoryForService(QName serviceName) {
        return this.channel.createExchangeFactoryForService(serviceName);
    }

    public void send(MessageExchange exchange) throws MessagingException {
        this.prepareExchange(exchange);
        this.handleExchange(exchange, exchange.getStatus() == ExchangeStatus.ACTIVE);
        try {
            this.channel.send(exchange);
        }
        catch (MessagingException e) {
            this.handleExchange(exchange, false);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendSync(MessageExchange exchange, long timeout) throws MessagingException {
        boolean processed = false;
        try {
            this.prepareExchange(exchange);
            this.handleExchange(exchange, exchange.getStatus() == ExchangeStatus.ACTIVE);
            boolean ret = this.channel.sendSync(exchange, timeout);
            this.handleExchange(exchange, exchange.getStatus() == ExchangeStatus.ACTIVE);
            if (ret) {
                this.resumeTx(exchange);
                processed = true;
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            if (!processed) {
                this.handleExchange(exchange, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendSync(MessageExchange exchange) throws MessagingException {
        boolean processed = false;
        try {
            this.prepareExchange(exchange);
            this.handleExchange(exchange, exchange.getStatus() == ExchangeStatus.ACTIVE);
            boolean ret = this.channel.sendSync(exchange);
            this.handleExchange(exchange, exchange.getStatus() == ExchangeStatus.ACTIVE);
            if (ret) {
                this.resumeTx(exchange);
                processed = true;
            }
            boolean bl = ret;
            return bl;
        }
        finally {
            if (!processed) {
                this.handleExchange(exchange, false);
            }
        }
    }

    private void resumeTx(MessageExchange exchange) throws MessagingException {
        Transaction tx;
        if (!this.getEndpoint().getServiceUnit().getComponent().getContainer().handleTransactions() && (tx = (Transaction)exchange.getProperty("javax.jbi.transaction.jta")) != null) {
            TransactionManager txmgr = (TransactionManager)this.endpoint.getServiceUnit().getComponent().getComponentContext().getTransactionManager();
            try {
                txmgr.resume(tx);
            }
            catch (InvalidTransactionException e) {
                throw new MessagingException((Throwable)e);
            }
            catch (SystemException e) {
                throw new MessagingException((Throwable)e);
            }
        }
    }

    protected void prepareExchange(MessageExchange exchange) throws MessagingException {
        Endpoint ep = this.getEndpoint();
        ep.getServiceUnit().getComponent().prepareExchange(exchange, ep);
    }

    protected void handleExchange(MessageExchange exchange, boolean add) throws MessagingException {
        Endpoint ep = this.getEndpoint();
        ep.getServiceUnit().getComponent().handleExchange(ep, exchange, add);
    }

    protected Endpoint getEndpoint() {
        if (this.endpoint != null) {
            return this.endpoint;
        }
        return ENDPOINT_TLS.get();
    }

    public static void setEndpoint(Endpoint endpoint) {
        ENDPOINT_TLS.set(endpoint);
    }
}

