/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.exec.utils;

import org.apache.servicemix.exec.marshaler.ExecRequest;
import org.apache.servicemix.exec.marshaler.ExecResponse;
import org.apache.servicemix.exec.utils.ExecException;
import org.apache.servicemix.exec.utils.StreamGobbler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecUtils {
    private static final Logger logger = LoggerFactory.getLogger(ExecUtils.class);

    public static ExecResponse execute(ExecRequest execRequest) throws ExecException {
        ExecResponse execResponse = new ExecResponse();
        String exec = execRequest.getCommand();
        for (String argument : execRequest.getArguments()) {
            exec = exec + " " + argument;
        }
        logger.info("Execute command {}", (Object)exec);
        String[] shellCommand = null;
        logger.debug("Define the shell.");
        logger.debug("Get the OS name property.");
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            logger.debug("Microsoft Windows platform detected.");
            String comSpec = System.getProperty("ComSpec");
            if (comSpec != null) {
                logger.debug("The ComSpec MS Windows environment variable is defined, using it: {} /C {}", (Object)comSpec, (Object)exec);
                shellCommand = new String[]{comSpec, "/C", exec};
            } else {
                logger.debug("The ComSpec MS Windows environment variable is not defined, found the shell command depending of the MS Windows version.");
                if (osName.startsWith("Windows 3") || osName.startsWith("Windows 95") || osName.startsWith("Windows 98") || osName.startsWith("Windows ME")) {
                    logger.debug("MS Windows 3.1/95/98/Me detected, using: command.com /C {}", (Object)exec);
                    shellCommand = new String[]{"command.com", "/C", exec};
                } else {
                    logger.debug("MS Windows NT/XP/Vista detected, using: cmd.exe /C {}", (Object)exec);
                    shellCommand = new String[]{"cmd.exe", "/C", exec};
                }
            }
        } else {
            logger.debug("Unix platform detected.");
            String shell = System.getProperty("SHELL");
            if (shell != null) {
                logger.debug("The SHELL Unix environment variable is defined, using it: {} -c {}", (Object)shell, (Object)exec);
                shellCommand = new String[]{shell, "-c", exec};
            } else {
                logger.debug("The SHELL Unix environment variable is not defined, using the default Unix shell: /bin/sh -c {}", (Object)exec);
                shellCommand = new String[]{"/bin/sh", "-c", exec};
            }
        }
        try {
            execResponse.setStartTime(System.currentTimeMillis());
            Process process = Runtime.getRuntime().exec(shellCommand);
            StreamGobbler errorGobbler = new StreamGobbler(process.getErrorStream(), execResponse.getErrorData());
            errorGobbler.start();
            StreamGobbler outputGobbler = new StreamGobbler(process.getInputStream(), execResponse.getOutputData());
            outputGobbler.start();
            int exitValue = process.waitFor();
            execResponse.setEndTime(System.currentTimeMillis());
            execResponse.setExitCode(exitValue);
            if (exitValue != 0) {
                logger.error("Command {} execution failed with return code {}", (Object)exec, (Object)exitValue);
            } else {
                logger.debug("Command {} execution completed: {}", (Object)exec, (Object)execResponse.getOutputData().toString());
            }
        }
        catch (Exception exception) {
            logger.error("Command {} execution failed.", (Object)exec, (Object)exception);
            throw new ExecException("Command " + exec + " execution failed.", exception);
        }
        return execResponse;
    }
}

