/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.common;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.component.ComponentLifeCycle;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.xml.namespace.QName;
import org.apache.servicemix.common.Container;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.EndpointDeliveryChannel;
import org.apache.servicemix.common.EndpointSupport;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.common.management.MBeanServerHelper;
import org.apache.servicemix.executors.Executor;
import org.apache.servicemix.executors.ExecutorFactory;
import org.apache.servicemix.executors.impl.ExecutorFactoryImpl;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncBaseLifeCycle
implements ComponentLifeCycle {
    public static final String INITIALIZED = "Initialized";
    protected transient Logger logger;
    protected ServiceMixComponent component;
    protected ComponentContext context;
    protected ObjectName mbeanName;
    protected ExecutorFactory executorFactory;
    protected Executor consumerExecutor;
    protected Executor providerExecutor;
    protected AtomicBoolean running = new AtomicBoolean(false);
    protected DeliveryChannel channel;
    protected Thread poller;
    protected AtomicBoolean polling = new AtomicBoolean(false);
    protected TransactionManager transactionManager;
    protected boolean workManagerCreated;
    protected ThreadLocal<String> correlationId = new ThreadLocal();
    protected String currentState = "Unknown";
    protected Container container;
    protected Map<String, Set<String>> knownExchanges = new ConcurrentHashMap<String, Set<String>>();

    public AsyncBaseLifeCycle() {
    }

    public AsyncBaseLifeCycle(ServiceMixComponent component) {
        this();
        this.setComponent(component);
    }

    public Container getContainer() {
        return this.container;
    }

    protected void setComponent(ServiceMixComponent component) {
        this.component = component;
        this.logger = component.getLogger();
    }

    public ObjectName getExtensionMBeanName() {
        return this.mbeanName;
    }

    protected Object getExtensionMBean() throws Exception {
        return null;
    }

    protected ObjectName createExtensionMBeanName() throws Exception {
        return this.context.getMBeanNames().createCustomComponentMBeanName("Configuration");
    }

    public QName getEPRServiceName() {
        return null;
    }

    public String getCurrentState() {
        return this.currentState;
    }

    protected void setCurrentState(String currentState) {
        this.currentState = currentState;
    }

    public boolean isStarted() {
        return this.currentState != null && this.currentState.equals("Started");
    }

    public boolean isStopped() {
        return this.currentState != null && this.currentState.equals("Stopped");
    }

    public boolean isShutDown() {
        return this.currentState != null && this.currentState.equals("Shutdown");
    }

    public boolean isInitialized() {
        return this.currentState != null && this.currentState.equals(INITIALIZED);
    }

    public boolean isUnknown() {
        return this.currentState == null || this.currentState.equals("Unknown");
    }

    public void init(ComponentContext context) throws JBIException {
        try {
            this.logger.debug("Initializing component");
            Thread.currentThread().setContextClassLoader(this.component.getClass().getClassLoader());
            this.context = context;
            this.channel = context.getDeliveryChannel();
            try {
                this.transactionManager = (TransactionManager)context.getTransactionManager();
            }
            catch (Throwable e) {
                // empty catch block
            }
            this.container = Container.detect(context);
            this.doInit();
            this.setCurrentState(INITIALIZED);
            this.logger.debug("Component initialized");
        }
        catch (JBIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JBIException("Error calling init", (Throwable)e);
        }
    }

    protected void doInit() throws Exception {
        MBeanServer server = this.context.getMBeanServer();
        Object mbean = this.getExtensionMBean();
        if (server != null && mbean != null) {
            MBeanServerHelper.register(server, this.createExtensionMBeanName(), mbean);
        }
        if (this.executorFactory == null) {
            this.executorFactory = this.findExecutorFactory();
        }
        if (this.executorFactory == null) {
            this.executorFactory = this.createExecutorFactory();
        }
        this.consumerExecutor = this.executorFactory.createExecutor("component." + this.getContext().getComponentName() + ".consumer");
        this.providerExecutor = this.executorFactory.createExecutor("component." + this.getContext().getComponentName() + ".provider");
    }

    public void shutDown() throws JBIException {
        try {
            this.logger.debug("Shutting down component");
            Thread.currentThread().setContextClassLoader(this.component.getClass().getClassLoader());
            this.doShutDown();
            this.setCurrentState("Shutdown");
            this.context = null;
            this.logger.debug("Component shut down");
        }
        catch (JBIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JBIException("Error calling shutdown", (Throwable)e);
        }
    }

    protected void doShutDown() throws Exception {
        if (this.mbeanName != null) {
            MBeanServer server = this.context.getMBeanServer();
            if (server == null) {
                throw new JBIException("null mBeanServer");
            }
            if (server.isRegistered(this.mbeanName)) {
                server.unregisterMBean(this.mbeanName);
            }
        }
        this.consumerExecutor.shutdown();
        this.providerExecutor.shutdown();
        this.consumerExecutor = null;
        this.providerExecutor = null;
    }

    public void start() throws JBIException {
        try {
            this.logger.debug("Starting component");
            Thread.currentThread().setContextClassLoader(this.component.getClass().getClassLoader());
            if (this.running.compareAndSet(false, true)) {
                this.doStart();
                this.setCurrentState("Started");
            }
            this.logger.debug("Component started");
        }
        catch (JBIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JBIException("Error calling start", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        boolean doPoll = false;
        if (this.container.getType() != Container.Type.ServiceMix3) {
            doPoll = true;
        } else {
            Object smx3container = ((Container.Smx3Container)this.container).getSmx3Container();
            try {
                Method m = smx3container.getClass().getMethod("isOptimizedDelivery", new Class[0]);
                doPoll = false == (Boolean)m.invoke(smx3container, null);
            }
            catch (NoSuchMethodException nsmex) {
                doPoll = false;
            }
        }
        if (doPoll) {
            AtomicBoolean atomicBoolean = this.polling;
            synchronized (atomicBoolean) {
                this.consumerExecutor.execute(new Runnable(){

                    public void run() {
                        AsyncBaseLifeCycle.this.poller = Thread.currentThread();
                        AsyncBaseLifeCycle.this.pollDeliveryChannel();
                    }
                });
                this.polling.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pollDeliveryChannel() {
        AtomicBoolean atomicBoolean = this.polling;
        synchronized (atomicBoolean) {
            this.polling.set(true);
            this.polling.notify();
        }
        Executor executor = null;
        while (this.running.get()) {
            try {
                final MessageExchange exchange = this.channel.accept(1000L);
                if (exchange == null) continue;
                executor = exchange.getRole().equals(MessageExchange.Role.CONSUMER) ? this.consumerExecutor : this.providerExecutor;
                final Transaction tx = (Transaction)exchange.getProperty("javax.jbi.transaction.jta");
                if (tx != null && this.container.handleTransactions()) {
                    if (this.transactionManager == null) {
                        throw new IllegalStateException("Exchange is enlisted in a transaction, but no transaction manager is available");
                    }
                    this.transactionManager.suspend();
                }
                executor.execute(new Runnable(){

                    public void run() {
                        AsyncBaseLifeCycle.this.processExchangeInTx(exchange, tx);
                    }
                });
            }
            catch (Throwable t) {
                if (!this.running.get()) {
                    this.logger.debug("Polling thread will stop");
                    continue;
                }
                this.logger.error("Error polling delivery channel", t);
            }
        }
        AtomicBoolean atomicBoolean2 = this.polling;
        synchronized (atomicBoolean2) {
            this.polling.set(false);
            this.polling.notify();
        }
    }

    public void stop() throws JBIException {
        try {
            this.logger.debug("Stopping component");
            Thread.currentThread().setContextClassLoader(this.component.getClass().getClassLoader());
            if (this.running.compareAndSet(true, false)) {
                this.doStop();
                this.setCurrentState("Stopped");
            }
            this.logger.debug("Component stopped");
        }
        catch (JBIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JBIException("Error calling stop", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        try {
            AtomicBoolean atomicBoolean = this.polling;
            synchronized (atomicBoolean) {
                if (this.polling.get()) {
                    this.poller.interrupt();
                    this.polling.wait();
                }
            }
        }
        finally {
            this.poller = null;
        }
    }

    public ComponentContext getContext() {
        return this.context;
    }

    public Executor getExecutor(MessageExchange.Role role) {
        if (role != null && role.equals(MessageExchange.Role.CONSUMER)) {
            return this.consumerExecutor;
        }
        if (role != null && role.equals(MessageExchange.Role.PROVIDER)) {
            return this.providerExecutor;
        }
        return null;
    }

    public void setExecutor(MessageExchange.Role role, Executor executor) {
        if (role != null && role.equals(MessageExchange.Role.CONSUMER)) {
            this.consumerExecutor = executor;
        } else {
            this.providerExecutor = executor;
        }
    }

    public ExecutorFactory getExecutorFactory() {
        return this.executorFactory;
    }

    public void setExecutorFactory(ExecutorFactory executorFactory) {
        this.executorFactory = executorFactory;
    }

    protected ExecutorFactory createExecutorFactory() {
        return this.container != null ? this.container.getExecutorFactory() : new ExecutorFactoryImpl();
    }

    public Object getSmx3Container() {
        if (this.container instanceof Container.Smx3Container) {
            return ((Container.Smx3Container)this.container).getSmx3Container();
        }
        return null;
    }

    protected ExecutorFactory findExecutorFactory() {
        return this.container.getExecutorFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processExchangeInTx(MessageExchange exchange, Transaction tx) {
        ExchangeStatus oldStatus = exchange.getStatus();
        try {
            if (tx != null) {
                this.transactionManager.resume(tx);
            }
            this.processExchange(exchange);
        }
        catch (Throwable t) {
            this.logger.error("Error processing exchange {}", (Object)exchange, (Object)t);
            try {
                if (this.transactionManager != null && this.transactionManager.getStatus() == 0) {
                    if (this.exceptionShouldRollbackTx(t)) {
                        this.transactionManager.setRollbackOnly();
                    }
                    if (!this.container.handleTransactions()) {
                        this.transactionManager.suspend();
                    }
                }
                if (oldStatus == ExchangeStatus.ACTIVE) {
                    exchange.setStatus(ExchangeStatus.ERROR);
                    exchange.setError(t instanceof Exception ? (Exception)t : new Exception(t));
                    this.channel.send(exchange);
                }
            }
            catch (Exception inner) {
                this.logger.error("Error setting exchange status to ERROR", (Throwable)inner);
            }
        }
        finally {
            try {
                int status;
                if (tx != null && (status = this.transactionManager.getStatus()) != 6) {
                    this.logger.error("Transaction is still active after exchange processing. Trying to rollback transaction.");
                    try {
                        this.transactionManager.rollback();
                    }
                    catch (Throwable t) {
                        this.logger.error("Error trying to rollback transaction.", t);
                    }
                }
            }
            catch (Throwable t) {
                this.logger.error("Error checking transaction status.", t);
            }
        }
    }

    protected boolean exceptionShouldRollbackTx(Throwable t) {
        return false;
    }

    public void onMessageExchange(MessageExchange exchange) {
        if (!this.container.handleTransactions()) {
            Transaction tx = (Transaction)exchange.getProperty("javax.jbi.transaction.jta");
            this.processExchangeInTx(exchange, tx);
            return;
        }
        ExchangeStatus oldStatus = exchange.getStatus();
        try {
            this.processExchange(exchange);
        }
        catch (Throwable t) {
            this.logger.error("Error processing exchange {}", (Object)exchange, (Object)t);
            try {
                if (this.transactionManager != null && this.transactionManager.getStatus() == 0 && this.exceptionShouldRollbackTx(t)) {
                    this.transactionManager.setRollbackOnly();
                    if (!this.container.handleTransactions()) {
                        this.transactionManager.suspend();
                    }
                }
                if (oldStatus == ExchangeStatus.ACTIVE) {
                    exchange.setError(t instanceof Exception ? (Exception)t : new Exception(t));
                    this.channel.send(exchange);
                }
            }
            catch (Exception inner) {
                this.logger.error("Error setting exchange status to ERROR", (Throwable)inner);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processExchange(MessageExchange exchange) throws Exception {
        this.logger.debug("Received exchange: status: {}, role: {}", (Object)exchange.getStatus(), (Object)(exchange.getRole() == MessageExchange.Role.CONSUMER ? "consumer" : "provider"));
        if (exchange.getRole() == MessageExchange.Role.PROVIDER) {
            boolean dynamic = false;
            ServiceEndpoint endpoint = exchange.getEndpoint();
            String key = EndpointSupport.getKey(exchange.getEndpoint());
            Endpoint ep = this.component.getRegistry().getEndpoint(key);
            if (ep == null) {
                if (endpoint.getServiceName().equals(this.getEPRServiceName())) {
                    ep = this.getResolvedEPR(exchange.getEndpoint());
                    ep.activate();
                    ep.start();
                    dynamic = true;
                }
                if (ep == null) {
                    throw new IllegalStateException("Endpoint not found: " + key);
                }
            }
            try {
                this.doProcess(ep, exchange);
            }
            finally {
                if (dynamic) {
                    ep.stop();
                    ep.deactivate();
                }
            }
        } else {
            Endpoint ep = null;
            if (exchange.getProperty("org.apache.servicemix.senderEndpoint") != null) {
                String key = exchange.getProperty("org.apache.servicemix.senderEndpoint").toString();
                ep = this.component.getRegistry().getEndpoint(key);
            }
            if (ep == null) {
                throw new IllegalStateException("Endpoint not found for: " + exchange.getExchangeId());
            }
            this.doProcess(ep, exchange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProcess(Endpoint ep, MessageExchange exchange) throws Exception {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        boolean processed = false;
        try {
            String correlationID;
            ClassLoader cl;
            ClassLoader classLoader = cl = ep != null ? ep.getServiceUnit().getConfigurationClassLoader() : null;
            if (cl != null) {
                Thread.currentThread().setContextClassLoader(cl);
            }
            if ((correlationID = (String)exchange.getProperty("org.apache.servicemix.correlationId")) != null) {
                this.correlationId.set(correlationID);
            }
            this.logger.debug("Retrieved correlation id: {}", (Object)correlationID);
            EndpointDeliveryChannel.setEndpoint(ep);
            this.handleExchange(ep, exchange, exchange.getStatus() == ExchangeStatus.ACTIVE);
            ep.process(exchange);
            processed = true;
        }
        finally {
            if (!processed) {
                this.handleExchange(ep, exchange, false);
            }
            EndpointDeliveryChannel.setEndpoint(null);
            Thread.currentThread().setContextClassLoader(oldCl);
            this.correlationId.set(null);
        }
    }

    public void prepareExchange(MessageExchange exchange, Endpoint endpoint) throws MessagingException {
        if (exchange.getRole() == MessageExchange.Role.CONSUMER) {
            String correlationIDValue = (String)exchange.getProperty("org.apache.servicemix.correlationId");
            if (correlationIDValue == null) {
                correlationIDValue = this.correlationId.get();
                if (correlationIDValue == null) {
                    correlationIDValue = exchange.getExchangeId();
                    exchange.setProperty("org.apache.servicemix.correlationId", (Object)exchange.getExchangeId());
                    this.logger.debug("Created correlation id: {}", (Object)correlationIDValue);
                } else {
                    exchange.setProperty("org.apache.servicemix.correlationId", (Object)correlationIDValue);
                    this.logger.debug("Correlation id retrieved from ThreadLocal: {}", (Object)correlationIDValue);
                }
            }
            exchange.setProperty("org.apache.servicemix.senderEndpoint", (Object)endpoint.getKey());
        }
        if (!this.container.handleTransactions()) {
            try {
                if ((exchange.getRole() == MessageExchange.Role.CONSUMER && exchange.getStatus() == ExchangeStatus.ACTIVE || exchange.getRole() == MessageExchange.Role.PROVIDER) && this.transactionManager != null) {
                    exchange.setProperty("javax.jbi.transaction.jta", (Object)this.transactionManager.suspend());
                }
            }
            catch (SystemException e) {
                throw new MessagingException("Error handling transaction", (Throwable)e);
            }
        }
    }

    public void prepareShutdown(Endpoint endpoint) throws InterruptedException {
        this.prepareShutdown(endpoint, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareShutdown(Endpoint endpoint, long timeout) throws InterruptedException {
        Set<String> exchanges = this.getKnownExchanges(endpoint);
        long start = System.currentTimeMillis();
        long interval = timeout / 3L;
        Set<String> set = exchanges;
        synchronized (set) {
            while (!exchanges.isEmpty()) {
                for (String id : exchanges) {
                    this.logger.debug("Waiting for exchange {} in {}", (Object)id, (Object)endpoint);
                }
                exchanges.wait(interval);
                long delta = System.currentTimeMillis() - start;
                if (timeout == 0L || delta < timeout) continue;
                this.logger.debug(String.format("Gave up waiting for %s exchanges in %s after %s ms", exchanges.size(), endpoint, delta));
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getKnownExchanges(Endpoint endpoint) {
        Set<String> exchanges = this.knownExchanges.get(endpoint.getKey());
        if (exchanges == null) {
            Map<String, Set<String>> map = this.knownExchanges;
            synchronized (map) {
                exchanges = this.knownExchanges.get(endpoint.getKey());
                if (exchanges == null) {
                    exchanges = new HashSet<String>();
                    this.knownExchanges.put(endpoint.getKey(), exchanges);
                }
            }
        }
        return exchanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleExchange(Endpoint endpoint, MessageExchange exchange, boolean add) {
        Set<String> exchanges;
        Set<String> set = exchanges = this.getKnownExchanges(endpoint);
        synchronized (set) {
            if (add) {
                exchanges.add(exchange.getExchangeId());
            } else {
                exchanges.remove(exchange.getExchangeId());
            }
            exchanges.notifyAll();
        }
    }

    protected Endpoint getResolvedEPR(ServiceEndpoint ep) throws Exception {
        throw new UnsupportedOperationException("Component does not handle EPR exchanges");
    }
}

