/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.ftp;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.locks.Lock;
import javax.jbi.JBIException;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.commons.net.SocketClient;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.endpoints.PollingEndpoint;
import org.apache.servicemix.components.util.DefaultFileMarshaler;
import org.apache.servicemix.components.util.FileMarshaler;
import org.apache.servicemix.ftp.FTPClientPool;
import org.apache.servicemix.ftp.FtpEndpointType;
import org.apache.servicemix.locks.LockManager;
import org.apache.servicemix.locks.impl.SimpleLockManager;

public class FtpPollerEndpoint
extends PollingEndpoint
implements FtpEndpointType {
    private FTPClientPool clientPool;
    private FileFilter filter;
    private boolean deleteFile = true;
    private boolean recursive = true;
    private boolean changeWorkingDirectory;
    private FileMarshaler marshaler = new DefaultFileMarshaler();
    private LockManager lockManager;
    private QName targetOperation;
    private URI uri;

    public FtpPollerEndpoint() {
    }

    public FtpPollerEndpoint(ServiceUnit serviceUnit, QName service, String endpoint) {
        super(serviceUnit, service, endpoint);
    }

    public FtpPollerEndpoint(DefaultComponent component, ServiceEndpoint endpoint) {
        super(component, endpoint);
    }

    public void poll() throws Exception {
        this.pollFileOrDirectory(this.getWorkingPath());
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.uri == null && (this.getClientPool() == null || this.getClientPool().getHost() == null)) {
            throw new DeploymentException("Property uri or clientPool.host must be configured");
        }
        if (this.uri != null && this.getClientPool() != null && this.getClientPool().getHost() != null) {
            throw new DeploymentException("Properties uri and clientPool.host can not be configured at the same time");
        }
        if (this.changeWorkingDirectory && this.recursive) {
            throw new DeploymentException("changeWorkingDirectory='true' can not be set when recursive='true'");
        }
    }

    public void start() throws Exception {
        if (this.lockManager == null) {
            this.lockManager = this.createLockManager();
        }
        if (this.clientPool == null) {
            this.clientPool = this.createClientPool();
        }
        if (this.uri != null) {
            this.clientPool.setHost(this.uri.getHost());
            this.clientPool.setPort(this.uri.getPort());
            if (this.uri.getUserInfo() != null) {
                String[] infos = this.uri.getUserInfo().split(":");
                this.clientPool.setUsername(infos[0]);
                if (infos.length > 1) {
                    this.clientPool.setPassword(infos[1]);
                }
            }
        } else {
            String str = "ftp://" + this.clientPool.getHost();
            if (this.clientPool.getPort() >= 0) {
                str = str + ":" + this.clientPool.getPort();
            }
            str = str + "/";
            this.uri = new URI(str);
        }
        super.start();
    }

    protected LockManager createLockManager() {
        return new SimpleLockManager();
    }

    private String getWorkingPath() {
        return this.uri != null && this.uri.getPath() != null ? this.uri.getPath() : ".";
    }

    public FTPClientPool getClientPool() {
        return this.clientPool;
    }

    public void setClientPool(FTPClientPool clientPool) {
        this.clientPool = clientPool;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public FileFilter getFilter() {
        return this.filter;
    }

    public void setFilter(FileFilter filter) {
        this.filter = filter;
    }

    public boolean isDeleteFile() {
        return this.deleteFile;
    }

    public void setDeleteFile(boolean deleteFile) {
        this.deleteFile = deleteFile;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public FileMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(FileMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public QName getTargetOperation() {
        return this.targetOperation;
    }

    public void setTargetOperation(QName targetOperation) {
        this.targetOperation = targetOperation;
    }

    public void setChangeWorkingDirectory(boolean changeWorkingDirectory) {
        this.changeWorkingDirectory = changeWorkingDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pollFileOrDirectory(String fileOrDirectory) throws Exception {
        FTPClient ftp = this.borrowClient();
        try {
            this.logger.debug((Object)("Polling directory " + fileOrDirectory));
            this.pollFileOrDirectory(ftp, fileOrDirectory, this.isRecursive());
            Object var4_3 = null;
            this.returnClient(ftp);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.returnClient(ftp);
            throw throwable;
        }
    }

    protected void pollFileOrDirectory(FTPClient ftp, String fileOrDirectory, boolean processDir) throws Exception {
        FTPFile[] files = this.listFiles(ftp, fileOrDirectory);
        for (int i = 0; i < files.length; ++i) {
            String name = files[i].getName();
            if (".".equals(name) || "..".equals(name)) continue;
            String file = fileOrDirectory + "/" + name;
            if (!files[i].isDirectory()) {
                if (this.getFilter() != null && !this.getFilter().accept(new File(file))) continue;
                this.pollFile(file);
                continue;
            }
            if (processDir) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Polling directory " + file));
                }
                this.pollFileOrDirectory(ftp, file, this.isRecursive());
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)("Skipping directory " + file));
        }
    }

    private FTPFile[] listFiles(FTPClient ftp, String directory) throws IOException {
        if (this.changeWorkingDirectory) {
            ftp.changeWorkingDirectory(directory);
            return ftp.listFiles("");
        }
        return ftp.listFiles(directory);
    }

    protected void pollFile(final String file) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Scheduling file " + file + " for processing"));
        }
        this.getExecutor().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block7: {
                    Lock lock = FtpPollerEndpoint.this.lockManager.getLock(file);
                    if (lock.tryLock()) {
                        boolean unlock = true;
                        try {
                            unlock = FtpPollerEndpoint.this.processFileAndDelete(file);
                            Object var4_3 = null;
                            if (!unlock) break block7;
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            if (unlock) {
                                try {
                                    lock.unlock();
                                }
                                catch (Exception ex) {
                                    FtpPollerEndpoint.this.logger.error((Object)ex);
                                }
                                FtpPollerEndpoint.this.lockManager.removeLock(file);
                            }
                            throw throwable;
                        }
                        try {
                            lock.unlock();
                        }
                        catch (Exception ex) {
                            FtpPollerEndpoint.this.logger.error((Object)ex);
                        }
                        FtpPollerEndpoint.this.lockManager.removeLock(file);
                        {
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processFileAndDelete(String file) {
        FTPClient ftp = null;
        boolean unlock = true;
        try {
            block8: {
                try {
                    ftp = this.borrowClient();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Processing file " + file));
                    }
                    if (this.isFileExistingOnServer(ftp, file)) {
                        this.processFile(ftp, file);
                        unlock = false;
                        if (this.isDeleteFile()) {
                            if (!ftp.deleteFile(file)) {
                                throw new IOException("Could not delete file " + file);
                            }
                            unlock = true;
                        }
                        break block8;
                    }
                    this.logger.debug((Object)("Skipping " + file + ": the file no longer exists on the server"));
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to process file: " + file + ". Reason: " + e), (Throwable)e);
                    Object var6_5 = null;
                    this.returnClient(ftp);
                }
            }
            Object var6_4 = null;
            this.returnClient(ftp);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.returnClient(ftp);
            throw throwable;
        }
        return unlock;
    }

    private boolean isFileExistingOnServer(FTPClient ftp, String file) throws IOException {
        FTPFile[] files;
        boolean foundFile = false;
        int lastIndex = file.lastIndexOf("/");
        String directory = ".";
        String rawName = file;
        if (lastIndex > 0) {
            directory = file.substring(0, lastIndex);
            rawName = file.substring(lastIndex + 1);
        }
        if ((files = this.listFiles(ftp, directory)).length > 0) {
            for (FTPFile f : files) {
                if (!f.getName().equals(rawName)) continue;
                foundFile = true;
                break;
            }
        }
        return foundFile;
    }

    protected void processFile(FTPClient ftp, String file) throws Exception {
        InputStream in = ftp.retrieveFileStream(file);
        InOnly exchange = this.getExchangeFactory().createInOnlyExchange();
        this.configureExchangeTarget((MessageExchange)exchange);
        NormalizedMessage message = exchange.createMessage();
        exchange.setInMessage(message);
        if (this.getTargetOperation() != null) {
            exchange.setOperation(this.getTargetOperation());
        }
        this.marshaler.readMessage((MessageExchange)exchange, message, in, file);
        this.sendSync((MessageExchange)exchange);
        in.close();
        ftp.completePendingCommand();
        if (exchange.getStatus() == ExchangeStatus.ERROR) {
            Throwable e = exchange.getError();
            if (e == null) {
                e = new JBIException("Unkown error");
            }
            throw e;
        }
    }

    public String getLocationURI() {
        return this.uri.toString();
    }

    public void process(MessageExchange exchange) throws Exception {
    }

    protected FTPClientPool createClientPool() throws Exception {
        FTPClientPool pool = new FTPClientPool();
        pool.afterPropertiesSet();
        return pool;
    }

    protected FTPClient borrowClient() throws JBIException {
        try {
            return (FTPClient)this.getClientPool().borrowClient();
        }
        catch (Exception e) {
            throw new JBIException((Throwable)e);
        }
    }

    protected void returnClient(FTPClient client) {
        if (client != null) {
            try {
                this.getClientPool().returnClient((SocketClient)client);
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to return client to pool: " + e), (Throwable)e);
            }
        }
    }
}

