/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http;

import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.servicedesc.ServiceEndpoint;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.servicemix.common.BaseServiceUnitManager;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.DefaultServiceUnit;
import org.apache.servicemix.common.Deployer;
import org.apache.servicemix.common.Endpoint;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.util.IntrospectionSupport;
import org.apache.servicemix.common.util.URISupport;
import org.apache.servicemix.common.xbean.BaseXBeanDeployer;
import org.apache.servicemix.http.ContextManager;
import org.apache.servicemix.http.HttpConfiguration;
import org.apache.servicemix.http.HttpEndpoint;
import org.apache.servicemix.http.HttpEndpointType;
import org.apache.servicemix.http.HttpProcessor;
import org.apache.servicemix.http.HttpWsdl1Deployer;
import org.apache.servicemix.http.ManagedContextManager;
import org.apache.servicemix.http.endpoints.HttpConsumerEndpoint;
import org.apache.servicemix.http.endpoints.HttpProviderEndpoint;
import org.apache.servicemix.http.jetty.JCLLogger;
import org.apache.servicemix.http.jetty.JettyContextManager;
import org.mortbay.thread.QueuedThreadPool;
import org.mortbay.thread.ThreadPool;

public class HttpComponent
extends DefaultComponent {
    public static final String[] EPR_PROTOCOLS = new String[]{"http:", "https"};
    protected ContextManager server;
    protected HttpClient client;
    protected MultiThreadedHttpConnectionManager connectionManager;
    protected org.mortbay.jetty.client.HttpClient connectionPool;
    protected HttpConfiguration configuration = new HttpConfiguration();
    protected HttpEndpointType[] endpoints;
    protected String protocol;
    protected String host;
    protected int port = 80;
    protected String path;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public HttpEndpointType[] getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(HttpEndpointType[] endpoints) {
        this.endpoints = endpoints;
    }

    public ContextManager getServer() {
        return this.server;
    }

    public void setServer(ContextManager server) {
        this.server = server;
    }

    public HttpClient getClient() {
        return this.client;
    }

    public void setClient(HttpClient client) {
        this.client = client;
    }

    public org.mortbay.jetty.client.HttpClient getConnectionPool() {
        return this.connectionPool;
    }

    public org.mortbay.jetty.client.HttpClient createNewJettyClient() throws Exception {
        org.mortbay.jetty.client.HttpClient tempClient = new org.mortbay.jetty.client.HttpClient();
        QueuedThreadPool btp = new QueuedThreadPool();
        btp.setMaxThreads(this.getConfiguration().getJettyClientThreadPoolSize());
        tempClient.setThreadPool((ThreadPool)btp);
        tempClient.setConnectorType(2);
        tempClient.setTimeout((long)this.getConfiguration().getProviderExpirationTime());
        tempClient.start();
        return tempClient;
    }

    public void setConnectionPool(org.mortbay.jetty.client.HttpClient connectionPool) {
        this.connectionPool = connectionPool;
    }

    public HttpConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(HttpConfiguration configuration) {
        this.configuration = configuration;
    }

    protected Object getExtensionMBean() throws Exception {
        return this.configuration;
    }

    protected void doInit() throws Exception {
        String name;
        this.configuration.setRootDir(this.context.getWorkspaceRoot());
        this.configuration.setComponentName(this.context.getComponentName());
        this.configuration.load();
        if (this.configuration.getKeystoreManager() == null) {
            try {
                name = this.configuration.getKeystoreManagerName();
                Object km = this.context.getNamingContext().lookup(name);
                this.configuration.setKeystoreManager(km);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (this.configuration.getAuthenticationService() == null) {
            try {
                name = this.configuration.getAuthenticationServiceName();
                Object as = this.context.getNamingContext().lookup(name);
                this.configuration.setAuthenticationService(as);
            }
            catch (Throwable e) {
                try {
                    Class<?> cl = Class.forName("org.apache.servicemix.jbi.security.auth.impl.JAASAuthenticationService");
                    this.configuration.setAuthenticationService(cl.newInstance());
                }
                catch (Throwable t) {
                    this.logger.warn((Object)"Unable to retrieve or create the authentication service");
                }
            }
        }
        if (this.client == null) {
            this.connectionManager = new MultiThreadedHttpConnectionManager();
            HttpConnectionManagerParams params = new HttpConnectionManagerParams();
            params.setDefaultMaxConnectionsPerHost(this.configuration.getMaxConnectionsPerHost());
            params.setMaxTotalConnections(this.configuration.getMaxTotalConnections());
            this.connectionManager.setParams(params);
            this.client = new HttpClient((HttpConnectionManager)this.connectionManager);
            this.client.getParams().setAuthenticationPreemptive(this.configuration.isPreemptiveAuthentication());
        }
        if (this.connectionPool == null) {
            this.connectionPool = this.createNewJettyClient();
        }
        if (this.configuration.isManaged()) {
            this.server = new ManagedContextManager();
        } else {
            JettyContextManager jcm = new JettyContextManager();
            jcm.setMBeanServer(this.context.getMBeanServer());
            this.server = jcm;
        }
        this.server.setConfiguration(this.configuration);
        this.server.init();
        this.server.start();
        super.doInit();
    }

    protected void doShutDown() throws Exception {
        super.doShutDown();
        if (this.server != null) {
            ContextManager s = this.server;
            this.server = null;
            s.stop();
            s.shutDown();
        }
        if (this.connectionPool != null) {
            this.connectionPool.stop();
            this.connectionPool = null;
        }
        if (this.connectionManager != null) {
            this.connectionManager.shutdown();
            this.connectionManager = null;
            this.client = null;
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    protected String[] getEPRProtocols() {
        return EPR_PROTOCOLS;
    }

    protected Endpoint getResolvedEPR(ServiceEndpoint ep) throws Exception {
        HttpEndpoint httpEp = new HttpEndpoint(true);
        httpEp.setServiceUnit((ServiceUnit)new DefaultServiceUnit(this.component));
        httpEp.setService(ep.getServiceName());
        httpEp.setEndpoint(ep.getEndpointName());
        httpEp.setRole(MessageExchange.Role.PROVIDER);
        URI uri = new URI(ep.getEndpointName());
        Map map = URISupport.parseQuery((String)uri.getQuery());
        if (IntrospectionSupport.setProperties((Object)httpEp, (Map)map, (String)"http.")) {
            uri = URISupport.createRemainingURI((URI)uri, (Map)map);
        }
        if (httpEp.getLocationURI() == null) {
            httpEp.setLocationURI(uri.toString());
        }
        return httpEp;
    }

    public Object getKeystoreManager() {
        return this.configuration.getKeystoreManager();
    }

    public void setKeystoreManager(Object keystoreManager) {
        this.configuration.setKeystoreManager(keystoreManager);
    }

    public Object getAuthenticationService() {
        return this.configuration.getAuthenticationService();
    }

    public void setAuthenticationService(Object authenticationService) {
        this.configuration.setAuthenticationService(authenticationService);
    }

    public HttpProcessor getMainProcessor() {
        return this.server.getMainProcessor();
    }

    public BaseServiceUnitManager createServiceUnitManager() {
        Deployer[] deployers = new Deployer[]{new BaseXBeanDeployer((ServiceMixComponent)this, this.getEndpointClasses()), new HttpWsdl1Deployer((ServiceMixComponent)this)};
        return new BaseServiceUnitManager((ServiceMixComponent)this, deployers);
    }

    protected List getConfiguredEndpoints() {
        return HttpComponent.asList((Object[])this.endpoints);
    }

    protected Class[] getEndpointClasses() {
        return new Class[]{HttpEndpoint.class, HttpConsumerEndpoint.class, HttpProviderEndpoint.class};
    }

    static {
        JCLLogger.init();
    }
}

