/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.servicemix.http.HttpConfigurationMBean;
import org.mortbay.jetty.nio.SelectChannelConnector;

public class HttpConfiguration
implements HttpConfigurationMBean {
    public static final String DEFAULT_JETTY_CONNECTOR_CLASS_NAME = SelectChannelConnector.class.getName();
    public static final String MAPPING_DEFAULT = "/jbi";
    public static final String CONFIG_FILE = "component.properties";
    private String rootDir;
    private String componentName = "servicemix-http";
    private Properties properties = new Properties();
    private boolean streamingEnabled;
    private String jettyConnectorClassName = DEFAULT_JETTY_CONNECTOR_CLASS_NAME;
    private transient Object keystoreManager;
    private transient Object authenticationService;
    private String authenticationServiceName = "java:comp/env/smx/AuthenticationService";
    private String keystoreManagerName = "java:comp/env/smx/KeystoreManager";
    private int jettyThreadPoolSize = 255;
    private int jettyClientThreadPoolSize = 16;
    private boolean jettyClientPerProvider;
    private int maxConnectionsPerHost = 65536;
    private int maxTotalConnections = 65536;
    private boolean jettyManagement;
    private boolean managed;
    private transient String mapping = "/jbi";
    private int connectorMaxIdleTime = 30000;
    private int soLingerTime = -1;
    private int consumerProcessorSuspendTime = 60000;
    private int providerExpirationTime = 300000;
    private int retryCount = 3;
    private String proxyHost;
    private int proxyPort;
    private boolean wantHeadersFromHttpIntoExchange;
    private boolean preemptiveAuthentication;
    private boolean useHostPortForAuthScope;

    public String getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(String rootDir) {
        this.rootDir = rootDir;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getMapping() {
        return this.mapping;
    }

    public void setMapping(String mapping) {
        if (!mapping.startsWith("/")) {
            mapping = "/" + mapping;
        }
        if (mapping.endsWith("/")) {
            mapping = mapping.substring(0, mapping.length() - 1);
        }
        this.mapping = mapping;
    }

    public boolean isManaged() {
        return this.managed;
    }

    public void setManaged(boolean managed) {
        this.managed = managed;
    }

    public boolean isJettyManagement() {
        return this.jettyManagement;
    }

    public void setJettyManagement(boolean jettyManagement) {
        this.jettyManagement = jettyManagement;
    }

    public Object getAuthenticationService() {
        return this.authenticationService;
    }

    public void setAuthenticationService(Object authenticationService) {
        this.authenticationService = authenticationService;
    }

    public String getAuthenticationServiceName() {
        return this.authenticationServiceName;
    }

    public void setAuthenticationServiceName(String authenticationServiceName) {
        this.authenticationServiceName = authenticationServiceName;
        this.save();
    }

    public Object getKeystoreManager() {
        return this.keystoreManager;
    }

    public void setKeystoreManager(Object keystoreManager) {
        this.keystoreManager = keystoreManager;
    }

    public String getKeystoreManagerName() {
        return this.keystoreManagerName;
    }

    public void setKeystoreManagerName(String keystoreManagerName) {
        this.keystoreManagerName = keystoreManagerName;
        this.save();
    }

    public boolean isStreamingEnabled() {
        return this.streamingEnabled;
    }

    public void setStreamingEnabled(boolean streamingEnabled) {
        this.streamingEnabled = streamingEnabled;
        this.save();
    }

    public String getJettyConnectorClassName() {
        return this.jettyConnectorClassName;
    }

    public void setJettyConnectorClassName(String jettyConnectorClassName) {
        this.jettyConnectorClassName = jettyConnectorClassName;
        this.save();
    }

    public int getJettyThreadPoolSize() {
        return this.jettyThreadPoolSize;
    }

    public void setJettyThreadPoolSize(int jettyThreadPoolSize) {
        this.jettyThreadPoolSize = jettyThreadPoolSize;
        this.save();
    }

    public int getJettyClientThreadPoolSize() {
        return this.jettyClientThreadPoolSize;
    }

    public void setJettyClientThreadPoolSize(int jettyClientThreadPoolSize) {
        this.jettyClientThreadPoolSize = jettyClientThreadPoolSize;
        this.save();
    }

    public boolean isJettyClientPerProvider() {
        return this.jettyClientPerProvider;
    }

    public void setJettyClientPerProvider(boolean jettyClientPerProvider) {
        this.jettyClientPerProvider = jettyClientPerProvider;
        this.save();
    }

    public int getMaxConnectionsPerHost() {
        return this.maxConnectionsPerHost;
    }

    public void setMaxConnectionsPerHost(int maxConnectionsPerHost) {
        this.maxConnectionsPerHost = maxConnectionsPerHost;
        this.save();
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public void setMaxTotalConnections(int maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
        this.save();
    }

    public int getConnectorMaxIdleTime() {
        return this.connectorMaxIdleTime;
    }

    public void setConnectorMaxIdleTime(int connectorMaxIdleTime) {
        this.connectorMaxIdleTime = connectorMaxIdleTime;
        this.save();
    }

    public int getSoLingerTime() {
        return this.soLingerTime;
    }

    public void setSoLingerTime(int soLingerTime) {
        this.soLingerTime = soLingerTime;
        this.save();
    }

    public int getConsumerProcessorSuspendTime() {
        return this.consumerProcessorSuspendTime;
    }

    public void setConsumerProcessorSuspendTime(int consumerProcessorSuspendTime) {
        this.consumerProcessorSuspendTime = consumerProcessorSuspendTime;
        this.save();
    }

    public int getProviderExpirationTime() {
        return this.providerExpirationTime;
    }

    public void setProviderExpirationTime(int providerExpirationTime) {
        this.providerExpirationTime = providerExpirationTime;
        this.save();
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
        this.save();
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        this.save();
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        this.save();
    }

    public boolean isWantHeadersFromHttpIntoExchange() {
        return this.wantHeadersFromHttpIntoExchange;
    }

    public void setWantHeadersFromHttpIntoExchange(boolean wantHeadersFromHttpIntoExchange) {
        this.wantHeadersFromHttpIntoExchange = wantHeadersFromHttpIntoExchange;
    }

    public boolean isPreemptiveAuthentication() {
        return this.preemptiveAuthentication;
    }

    public void setPreemptiveAuthentication(boolean preemptiveAuthentication) {
        this.preemptiveAuthentication = preemptiveAuthentication;
        this.save();
    }

    public boolean isUseHostPortForAuthScope() {
        return this.useHostPortForAuthScope;
    }

    public void setUseHostPortForAuthScope(boolean useHostPortForAuthScope) {
        this.useHostPortForAuthScope = useHostPortForAuthScope;
        this.save();
    }

    public void save() {
        this.setProperty(this.componentName + ".jettyThreadPoolSize", Integer.toString(this.jettyThreadPoolSize));
        this.setProperty(this.componentName + ".jettyClientThreadPoolSize", Integer.toString(this.jettyClientThreadPoolSize));
        this.setProperty(this.componentName + ".jettyClientPerProvider", Boolean.toString(this.jettyClientPerProvider));
        this.setProperty(this.componentName + ".jettyConnectorClassName", this.jettyConnectorClassName);
        this.setProperty(this.componentName + ".streamingEnabled", Boolean.toString(this.streamingEnabled));
        this.setProperty(this.componentName + ".maxConnectionsPerHost", Integer.toString(this.maxConnectionsPerHost));
        this.setProperty(this.componentName + ".maxTotalConnections", Integer.toString(this.maxTotalConnections));
        this.setProperty(this.componentName + ".keystoreManagerName", this.keystoreManagerName);
        this.setProperty(this.componentName + ".authenticationServiceName", this.authenticationServiceName);
        this.setProperty(this.componentName + ".jettyManagement", Boolean.toString(this.jettyManagement));
        this.setProperty(this.componentName + ".connectorMaxIdleTime", Integer.toString(this.connectorMaxIdleTime));
        this.setProperty(this.componentName + ".soLingerTime", Integer.toString(this.soLingerTime));
        this.setProperty(this.componentName + ".consumerProcessorSuspendTime", Integer.toString(this.consumerProcessorSuspendTime));
        this.setProperty(this.componentName + ".providerExpirationTime", Integer.toString(this.providerExpirationTime));
        this.setProperty(this.componentName + ".retryCount", Integer.toString(this.retryCount));
        this.setProperty(this.componentName + ".proxyHost", this.proxyHost);
        this.setProperty(this.componentName + ".proxyPort", Integer.toString(this.proxyPort));
        this.setProperty(this.componentName + ".wantHeadersFromHttpIntoExchange", Boolean.toString(this.wantHeadersFromHttpIntoExchange));
        this.setProperty(this.componentName + ".preemptiveAuthentication", Boolean.toString(this.preemptiveAuthentication));
        this.setProperty(this.componentName + ".useHostPortForAuthScope", Boolean.toString(this.useHostPortForAuthScope));
        if (this.rootDir != null) {
            File f = new File(this.rootDir, CONFIG_FILE);
            try {
                this.properties.store(new FileOutputStream(f), null);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not store component configuration", e);
            }
        }
    }

    protected void setProperty(String name, String value) {
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.setProperty(name, value);
        }
    }

    public boolean load() {
        File f = null;
        InputStream in = null;
        if (this.rootDir != null && !(f = new File(this.rootDir, CONFIG_FILE)).exists()) {
            f = null;
        }
        if (f == null && (in = this.getClass().getClassLoader().getResourceAsStream(CONFIG_FILE)) == null) {
            return false;
        }
        try {
            if (f != null) {
                this.properties.load(new FileInputStream(f));
            } else {
                this.properties.load(in);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load component configuration", e);
        }
        if (this.properties.getProperty(this.componentName + ".jettyThreadPoolSize") != null) {
            this.jettyThreadPoolSize = Integer.parseInt(this.properties.getProperty(this.componentName + ".jettyThreadPoolSize"));
        }
        if (this.properties.getProperty(this.componentName + ".jettyClientThreadPoolSize") != null) {
            this.jettyClientThreadPoolSize = Integer.parseInt(this.properties.getProperty(this.componentName + ".jettyClientThreadPoolSize"));
        }
        if (this.properties.getProperty(this.componentName + ".jettyClientPerProvider") != null) {
            this.jettyClientPerProvider = Boolean.valueOf(this.properties.getProperty(this.componentName + ".jettyClientPerProvider"));
        }
        if (this.properties.getProperty(this.componentName + ".jettyConnectorClassName") != null) {
            this.jettyConnectorClassName = this.properties.getProperty(this.componentName + ".jettyConnectorClassName");
        }
        if (this.properties.getProperty(this.componentName + ".streamingEnabled") != null) {
            this.streamingEnabled = Boolean.valueOf(this.properties.getProperty(this.componentName + ".streamingEnabled"));
        }
        if (this.properties.getProperty(this.componentName + ".maxConnectionsPerHost") != null) {
            this.maxConnectionsPerHost = Integer.parseInt(this.properties.getProperty(this.componentName + ".maxConnectionsPerHost"));
        }
        if (this.properties.getProperty(this.componentName + ".maxTotalConnections") != null) {
            this.maxTotalConnections = Integer.parseInt(this.properties.getProperty(this.componentName + ".maxTotalConnections"));
        }
        if (this.properties.getProperty(this.componentName + ".keystoreManagerName") != null) {
            this.keystoreManagerName = this.properties.getProperty(this.componentName + ".keystoreManagerName");
        }
        if (this.properties.getProperty(this.componentName + ".authenticationServiceName") != null) {
            this.authenticationServiceName = this.properties.getProperty(this.componentName + ".authenticationServiceName");
        }
        if (this.properties.getProperty(this.componentName + ".jettyManagement") != null) {
            this.jettyManagement = Boolean.valueOf(this.properties.getProperty(this.componentName + ".jettyManagement"));
        }
        if (this.properties.getProperty(this.componentName + ".connectorMaxIdleTime") != null) {
            this.connectorMaxIdleTime = Integer.parseInt(this.properties.getProperty(this.componentName + ".connectorMaxIdleTime"));
        }
        if (this.properties.getProperty(this.componentName + ".soLingerTime") != null) {
            this.soLingerTime = Integer.parseInt(this.properties.getProperty(this.componentName + ".soLingerTime"));
        }
        if (this.properties.getProperty(this.componentName + ".consumerProcessorSuspendTime") != null) {
            this.consumerProcessorSuspendTime = Integer.parseInt(this.properties.getProperty(this.componentName + ".consumerProcessorSuspendTime"));
        }
        if (this.properties.getProperty(this.componentName + ".providerExpirationTime") != null) {
            this.providerExpirationTime = Integer.parseInt(this.properties.getProperty(this.componentName + ".providerExpirationTime"));
        }
        if (this.properties.getProperty(this.componentName + ".retryCount") != null) {
            this.retryCount = Integer.parseInt(this.properties.getProperty(this.componentName + ".retryCount"));
        }
        if (this.properties.getProperty(this.componentName + ".proxyHost") != null) {
            this.proxyHost = this.properties.getProperty(this.componentName + ".proxyHost");
        }
        if (this.properties.getProperty(this.componentName + ".proxyPort") != null) {
            this.proxyPort = Integer.parseInt(this.properties.getProperty(this.componentName + ".proxyPort"));
        }
        if (this.properties.getProperty(this.componentName + ".wantHeadersFromHttpIntoExchange") != null) {
            this.wantHeadersFromHttpIntoExchange = Boolean.valueOf(this.properties.getProperty(this.componentName + ".wantHeadersFromHttpIntoExchange"));
        }
        if (this.properties.getProperty(this.componentName + ".preemptiveAuthentication") != null) {
            this.preemptiveAuthentication = Boolean.valueOf(this.properties.getProperty(this.componentName + ".preemptiveAuthentication"));
        }
        if (this.properties.getProperty(this.componentName + ".useHostPortForAuthScope") != null) {
            this.useHostPortForAuthScope = Boolean.valueOf(this.properties.getProperty(this.componentName + ".useHostPortForAuthScope"));
        }
        return true;
    }
}

