/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http.endpoints;

import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.management.DeploymentException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ElementExtensible;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.extensions.schema.SchemaReference;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.tools.wsdl.PortTypeDecorator;
import org.apache.servicemix.http.HttpComponent;
import org.apache.servicemix.http.endpoints.HttpConsumerEndpoint;
import org.apache.servicemix.http.endpoints.HttpSoapConsumerMarshaler;
import org.apache.servicemix.soap.api.Policy;
import org.apache.servicemix.soap.util.DomUtil;
import org.apache.servicemix.soap.wsdl.BindingFactory;
import org.apache.servicemix.soap.wsdl.WSDLUtils;
import org.apache.servicemix.soap.wsdl.validator.WSIBPValidator;
import org.apache.woden.WSDLReader;
import org.apache.woden.types.NCName;
import org.apache.woden.wsdl20.Description;
import org.apache.woden.wsdl20.Endpoint;
import org.apache.woden.wsdl20.Service;
import org.apache.woden.wsdl20.xml.DescriptionElement;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HttpSoapConsumerEndpoint
extends HttpConsumerEndpoint {
    private Resource wsdl;
    private boolean useJbiWrapper = true;
    private boolean validateWsdl = true;
    private String soapVersion = "1.1";
    private Policy[] policies;

    public HttpSoapConsumerEndpoint() {
    }

    public HttpSoapConsumerEndpoint(DefaultComponent component, ServiceEndpoint endpoint) {
        super(component, endpoint);
    }

    public HttpSoapConsumerEndpoint(ServiceUnit serviceUnit, QName service, String endpoint) {
        super(serviceUnit, service, endpoint);
    }

    public Resource getWsdl() {
        return this.wsdl;
    }

    public void setWsdl(Resource wsdl) {
        this.wsdl = wsdl;
    }

    public boolean isValidateWsdl() {
        return this.validateWsdl;
    }

    public void setValidateWsdl(boolean validateWsdl) {
        this.validateWsdl = validateWsdl;
    }

    public boolean isUseJbiWrapper() {
        return this.useJbiWrapper;
    }

    public void setUseJbiWrapper(boolean useJbiWrapper) {
        this.useJbiWrapper = useJbiWrapper;
    }

    public void setSoapVersion(String soapVersion) {
        this.soapVersion = soapVersion;
    }

    public String getSoapVersion() {
        return this.soapVersion;
    }

    public Policy[] getPolicies() {
        return this.policies;
    }

    public void setPolicies(Policy[] policies) {
        this.policies = policies;
    }

    protected void useProvidedWsdl() throws Exception {
        this.description = DomUtil.parse((InputStream)this.wsdl.getInputStream());
        javax.wsdl.xml.WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        this.definition = reader.readWSDL(null, this.description);
    }

    protected void useProxiedWsdl() throws Exception {
        QName[] portTypes;
        PortType targetEndpointPortType;
        ServiceEndpoint[] endPoints;
        ComponentContext componentContext = this.serviceUnit.getComponent().getComponentContext();
        ServiceEndpoint targetEndpoint = null;
        if (this.getTargetService() != null && this.getTargetEndpoint() != null) {
            targetEndpoint = componentContext.getEndpoint(this.getTargetService(), this.getTargetEndpoint());
        }
        if (targetEndpoint == null && this.getTargetService() != null && (endPoints = componentContext.getEndpointsForService(this.getTargetService())) != null && endPoints.length > 0) {
            targetEndpoint = endPoints[0];
        }
        if (targetEndpoint == null && this.getTargetInterface() != null && (endPoints = componentContext.getEndpoints(this.getTargetInterface())) != null && endPoints.length > 0) {
            targetEndpoint = endPoints[0];
        }
        if (targetEndpoint == null) {
            throw new JBIException("The target endpoint is not found.");
        }
        Document targetEndpointDescriptor = componentContext.getEndpointDescriptor(targetEndpoint);
        if (targetEndpointDescriptor == null) {
            throw new JBIException("The target endpoint descriptor is null.");
        }
        Definition targetEndpointDefinition = WSDLFactory.newInstance().newWSDLReader().readWSDL(null, targetEndpointDescriptor);
        if (targetEndpointDefinition == null) {
            throw new JBIException("The target endpoint has no WSDL definition.");
        }
        javax.wsdl.Service targetServiceInDefinition = targetEndpointDefinition.getService(this.getTargetService());
        Port targetEndpointPort = targetServiceInDefinition != null ? targetServiceInDefinition.getPort(this.getTargetEndpoint()) : null;
        PortType portType = targetEndpointPortType = targetEndpointPort != null ? targetEndpointPort.getBinding().getPortType() : null;
        if (targetEndpointPortType == null && (portTypes = targetEndpointDefinition.getPortTypes().keySet().toArray(new QName[0])) != null && portTypes.length > 0) {
            targetEndpointPortType = targetEndpointDefinition.getPortType(portTypes[0]);
        }
        if (targetEndpointPortType == null) {
            throw new JBIException("The target port type is not defined.");
        }
        if (targetEndpointPortType != null) {
            HttpComponent httpComponent;
            int i;
            QName[] qnames = targetEndpointDefinition.getPortTypes().keySet().toArray(new QName[0]);
            for (i = 0; i < qnames.length; ++i) {
                if (qnames[i].equals(targetEndpointPortType.getQName())) continue;
                targetEndpointDefinition.removePortType(qnames[i]);
            }
            qnames = targetEndpointDefinition.getServices().keySet().toArray(new QName[0]);
            for (i = 0; i < qnames.length; ++i) {
                targetEndpointDefinition.removeService(qnames[i]);
            }
            qnames = targetEndpointDefinition.getBindings().keySet().toArray(new QName[0]);
            for (i = 0; i < qnames.length; ++i) {
                targetEndpointDefinition.removeBinding(qnames[i]);
            }
            String location = this.getLocationURI();
            if (!location.endsWith("/")) {
                location = location + "/";
            }
            if ((httpComponent = (HttpComponent)this.serviceUnit.getComponent()).getConfiguration().isManaged()) {
                String path = new URI(location).getPath();
                location = "http://localhost";
                if (httpComponent.getHost() != null) {
                    location = httpComponent.getProtocol() != null ? httpComponent.getProtocol() + "://" : "http://";
                    location = location + httpComponent.getHost();
                    if (httpComponent.getPort() != 80) {
                        location = location + ":" + httpComponent.getPort();
                    }
                    if (httpComponent.getPath() != null) {
                        location = location + httpComponent.getPath();
                    }
                }
                location = location + httpComponent.getConfiguration().getMapping() + path;
            }
            if (targetEndpointPortType.getQName().getNamespaceURI().equals(this.getService().getNamespaceURI())) {
                PortTypeDecorator.decorate((Definition)targetEndpointDefinition, (PortType)targetEndpointPortType, (String)location, (String)(this.endpoint + "Binding"), (String)this.service.getLocalPart(), (String)this.endpoint, (String)this.soapVersion);
                this.definition = targetEndpointDefinition;
            } else {
                this.definition = PortTypeDecorator.createImportDef((Definition)targetEndpointDefinition, (String)this.service.getNamespaceURI(), (String)"porttypedef.wsdl");
                PortTypeDecorator.decorate((Definition)this.definition, (PortType)targetEndpointPortType, (String)location, (String)(this.endpoint + "Binding"), (String)this.service.getLocalPart(), (String)this.endpoint, (String)this.soapVersion);
            }
            this.description = WSDLFactory.newInstance().newWSDLWriter().getDocument(this.definition);
        }
    }

    public void activate() throws Exception {
        if (this.wsdl != null) {
            this.useProvidedWsdl();
        } else {
            this.useProxiedWsdl();
        }
        Element element = this.description.getDocumentElement();
        if ("http://schemas.xmlsoap.org/wsdl/".equals(element.getNamespaceURI())) {
            this.validateWsdl1();
        } else if ("http://www.w3.org/2006/01/wsdl".equals(element.getNamespaceURI())) {
            this.validateWsdl2();
        } else {
            throw new DeploymentException("The WSDL namespace " + element.getNamespaceURI() + " is not supported");
        }
        super.activate();
    }

    public void validate() throws DeploymentException {
        HttpSoapConsumerMarshaler marshaler;
        if (this.getTargetService() == null && this.getTargetInterface() == null && this.getTargetUri() == null) {
            this.setTargetService(this.getService());
            this.setTargetEndpoint(this.getEndpoint());
        }
        if (this.getMarshaler() instanceof HttpSoapConsumerMarshaler) {
            marshaler = (HttpSoapConsumerMarshaler)this.getMarshaler();
        } else if (this.getMarshaler() == null) {
            marshaler = new HttpSoapConsumerMarshaler();
            this.setMarshaler(marshaler);
        } else {
            throw new DeploymentException("The configured marshaler must inherit HttpSoapConsumerMarshaler");
        }
        marshaler.setUseJbiWrapper(this.useJbiWrapper);
        marshaler.setPolicies(this.policies);
        marshaler.setSoapVersion(this.soapVersion);
        super.validate();
    }

    protected void loadStaticResources() throws Exception {
        this.mapDefinition(this.definition);
    }

    protected void validateWsdl1() throws Exception {
        SOAPAddress soapAddress;
        Port port;
        javax.wsdl.Service svc;
        WSIBPValidator validator;
        if (this.definition == null) {
            throw new DeploymentException("The WSDL definition is not found in the description");
        }
        if (this.validateWsdl && !(validator = new WSIBPValidator(this.definition)).isValid()) {
            throw new DeploymentException("WSDL is not WS-I BP compliant: " + validator.getErrors());
        }
        if (this.getService() != null) {
            svc = this.definition.getService(this.getService());
            if (svc == null) {
                throw new DeploymentException("Could not find service '" + this.getService() + "' in wsdl");
            }
        } else if (this.definition.getServices().size() == 1) {
            svc = (javax.wsdl.Service)this.definition.getServices().values().iterator().next();
            this.setService(svc.getQName());
        } else {
            throw new DeploymentException("If service is not set, the WSDL must contain a single service definition");
        }
        if (this.getEndpoint() != null) {
            port = svc.getPort(this.getEndpoint());
            if (port == null) {
                throw new DeploymentException("Cound not find port '" + this.getEndpoint() + "' in wsdl for service '" + this.getService() + "'");
            }
        } else if (svc.getPorts().size() == 1) {
            port = (Port)svc.getPorts().values().iterator().next();
            this.setEndpoint(port.getName());
        } else {
            throw new DeploymentException("If endpoint is not set, the WSDL service '" + this.getService() + "' must contain a single port definition");
        }
        if ((soapAddress = (SOAPAddress)WSDLUtils.getExtension((ElementExtensible)port, SOAPAddress.class)) != null) {
            soapAddress.setLocationURI(this.getLocationURI());
        } else {
            SOAP12Address soap12Address = (SOAP12Address)WSDLUtils.getExtension((ElementExtensible)port, SOAP12Address.class);
            if (soap12Address != null) {
                soap12Address.setLocationURI(this.getLocationURI());
            }
        }
        this.description = WSDLUtils.getWSDL11Factory().newWSDLWriter().getDocument(this.definition);
        ((HttpSoapConsumerMarshaler)this.getMarshaler()).setBinding(BindingFactory.createBinding((Port)port));
    }

    protected void validateWsdl2() throws Exception {
        new Wsdl2Validator().validate();
    }

    protected void mapDefinition(Definition def) throws WSDLException {
        this.addResource("main.wsdl", WSDLFactory.newInstance().newWSDLWriter().getDocument(def));
        this.mapImports(def, "");
    }

    protected void mapImports(Definition def, String contextPath) throws WSDLException {
        Map imports = def.getImports();
        for (List imps : imports.values()) {
            for (Import imp : imps) {
                Definition impDef = imp.getDefinition();
                String impLoc = imp.getLocationURI();
                if (impDef == null || impLoc == null || URI.create(impLoc).isAbsolute()) continue;
                impLoc = HttpSoapConsumerEndpoint.resolveRelativeURI(contextPath, impLoc);
                this.addResource(impLoc, WSDLFactory.newInstance().newWSDLWriter().getDocument(impDef));
                this.mapImports(impDef, HttpSoapConsumerEndpoint.getURIParent(impLoc));
            }
        }
        Types types = def.getTypes();
        if (types != null) {
            for (ExtensibilityElement ee : types.getExtensibilityElements()) {
                if (!(ee instanceof Schema)) continue;
                Schema schema = (Schema)ee;
                this.mapSchema(schema, "");
            }
        }
    }

    private void mapSchema(Schema schema, String contextPath) {
        Map schemaImports = schema.getImports();
        for (List imps : schemaImports.values()) {
            for (SchemaImport schemaImport : imps) {
                Schema schemaImp = schemaImport.getReferencedSchema();
                String schemaLoc = schemaImport.getSchemaLocationURI();
                if (schemaLoc == null || schemaImp == null || schemaImp.getElement() == null || URI.create(schemaLoc).isAbsolute()) continue;
                schemaLoc = HttpSoapConsumerEndpoint.resolveRelativeURI(contextPath, schemaLoc);
                this.addResource(schemaLoc, schemaImp.getElement());
                this.mapSchema(schemaImp, HttpSoapConsumerEndpoint.getURIParent(schemaLoc));
            }
        }
        List schemaIncludes = schema.getIncludes();
        for (SchemaReference schemaInclude : schemaIncludes) {
            Schema schemaImp = schemaInclude.getReferencedSchema();
            String schemaLoc = schemaInclude.getSchemaLocationURI();
            if (schemaLoc == null || schemaImp == null || schemaImp.getElement() == null || URI.create(schemaLoc).isAbsolute()) continue;
            schemaLoc = HttpSoapConsumerEndpoint.resolveRelativeURI(contextPath, schemaLoc);
            this.addResource(schemaLoc, schemaImp.getElement());
            this.mapSchema(schemaImp, HttpSoapConsumerEndpoint.getURIParent(schemaLoc));
        }
    }

    private static String resolveRelativeURI(String context, String path) {
        if (context.length() > 0) {
            return URI.create(context + "/" + path).normalize().getPath();
        }
        return path;
    }

    private static String getURIParent(String path) {
        return URI.create(path + "/..").normalize().getPath();
    }

    protected class Wsdl2Validator {
        protected Wsdl2Validator() {
        }

        public void validate() throws Exception {
            Endpoint endpoint;
            Service svc;
            WSDLReader reader = org.apache.woden.WSDLFactory.newInstance().newWSDLReader();
            reader.setFeature("http://ws.apache.org/woden/features/verbose", false);
            DescriptionElement descElement = reader.readWSDL(HttpSoapConsumerEndpoint.this.wsdl.getURL().toString());
            Description desc = descElement.toComponent();
            if (HttpSoapConsumerEndpoint.this.getService() != null) {
                svc = desc.getService(HttpSoapConsumerEndpoint.this.getService());
                if (svc == null) {
                    throw new DeploymentException("Could not find service '" + HttpSoapConsumerEndpoint.this.getService() + "' in wsdl");
                }
            } else if (desc.getServices().length == 1) {
                svc = desc.getServices()[0];
                HttpSoapConsumerEndpoint.this.setService(svc.getName());
            } else {
                throw new DeploymentException("If service is not set, the WSDL must contain a single service definition");
            }
            if (HttpSoapConsumerEndpoint.this.getEndpoint() != null) {
                endpoint = svc.getEndpoint(new NCName(HttpSoapConsumerEndpoint.this.getEndpoint()));
                if (endpoint == null) {
                    throw new DeploymentException("Cound not find endpoint '" + HttpSoapConsumerEndpoint.this.getEndpoint() + "' in wsdl for service '" + HttpSoapConsumerEndpoint.this.getService() + "'");
                }
            } else if (svc.getEndpoints().length == 1) {
                endpoint = svc.getEndpoints()[0];
                HttpSoapConsumerEndpoint.this.setEndpoint(endpoint.getName().toString());
            } else {
                throw new DeploymentException("If endpoint is not set, the WSDL service '" + HttpSoapConsumerEndpoint.this.getService() + "' must contain a single port definition");
            }
            ((HttpSoapConsumerMarshaler)HttpSoapConsumerEndpoint.this.getMarshaler()).setBinding(BindingFactory.createBinding((Endpoint)endpoint));
        }
    }
}

