/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http.jetty;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.log.Logger;

public class JCLLogger
implements Logger {
    static final char DELIM_START = '{';
    static final char DELIM_STOP = '}';
    private final String name;
    private final Log log;

    public JCLLogger() {
        this("org.mortbay.jetty");
    }

    public JCLLogger(String name) {
        this.name = name;
        this.log = LogFactory.getLog((String)name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        String old = System.getProperty("org.mortbay.log.class");
        try {
            System.setProperty("org.mortbay.log.class", JCLLogger.class.getName());
            Class<?> cl = Logger.class.getClassLoader().loadClass("org.mortbay.log.Log");
            cl.getMethod("isDebugEnabled", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (old != null) {
                System.setProperty("org.mortbay.log.class", old);
            } else {
                System.getProperties().remove("org.mortbay.log.class");
            }
        }
    }

    public void debug(String msg, Throwable th) {
        this.log.debug((Object)msg, th);
    }

    public void debug(String msg, Object arg0, Object arg1) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)JCLLogger.arrayFormat(msg, new Object[]{arg0, arg1}));
        }
    }

    public Logger getLogger(String loggerName) {
        if (loggerName == null) {
            return null;
        }
        return new JCLLogger(this.name + "." + loggerName);
    }

    public void info(String msg, Object arg0, Object arg1) {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)JCLLogger.arrayFormat(msg, new Object[]{arg0, arg1}));
        }
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public void setDebugEnabled(boolean enabled) {
        this.log.warn((Object)"setDebugEnabled not supported");
    }

    public void warn(String msg, Throwable th) {
        this.log.warn((Object)msg, th);
    }

    public void warn(String msg, Object arg0, Object arg1) {
        if (this.log.isWarnEnabled()) {
            this.log.warn((Object)JCLLogger.arrayFormat(msg, new Object[]{arg0, arg1}));
        }
    }

    public static String arrayFormat(String messagePattern, Object[] argArray) {
        if (messagePattern == null) {
            return null;
        }
        int i = 0;
        int len = messagePattern.length();
        int j = messagePattern.indexOf(123);
        StringBuffer sbuf = new StringBuffer(messagePattern.length() + 50);
        for (int index = 0; index < argArray.length; ++index) {
            int escape = 120;
            j = messagePattern.indexOf(123, i);
            if (j == -1 || j + 1 == len) {
                if (i == 0) {
                    return messagePattern;
                }
                sbuf.append(messagePattern.substring(i, messagePattern.length()));
                return sbuf.toString();
            }
            char delimStop = messagePattern.charAt(j + 1);
            if (j > 0) {
                escape = messagePattern.charAt(j - 1);
            }
            if (escape == 92) {
                --index;
                sbuf.append(messagePattern.substring(i, j - 1));
                sbuf.append('{');
                i = j + 1;
                continue;
            }
            if (delimStop != '}') {
                sbuf.append(messagePattern.substring(i, messagePattern.length()));
                return sbuf.toString();
            }
            sbuf.append(messagePattern.substring(i, j));
            sbuf.append(argArray[index]);
            i = j + 2;
        }
        sbuf.append(messagePattern.substring(i, messagePattern.length()));
        return sbuf.toString();
    }
}

