/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util.ajax;

import java.util.Map;
import org.mortbay.util.Loader;
import org.mortbay.util.ajax.JSON;
import org.mortbay.util.ajax.JSONPojoConvertor;

public class JSONPojoConvertorFactory
implements JSON.Convertor {
    private JSON _json = null;

    public JSONPojoConvertorFactory(JSON json) {
        if (json == null) {
            throw new IllegalArgumentException();
        }
        this._json = json;
    }

    public void toJSON(Object obj, JSON.Output out) {
        String clsName = obj.getClass().getName();
        JSON.Convertor convertor = this._json.getConvertorFor(clsName);
        if (convertor == null) {
            try {
                Class cls = Loader.loadClass(JSON.class, clsName);
                convertor = new JSONPojoConvertor(cls);
                this._json.addConvertorFor(clsName, convertor);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (convertor != null && obj.getClass() != Object.class) {
            convertor.toJSON(obj, out);
        } else {
            out.add(obj.toString());
        }
    }

    public Object fromJSON(Map object) {
        Map map = object;
        String clsName = (String)map.get("class");
        if (clsName != null) {
            JSON.Convertor convertor = this._json.getConvertorFor(clsName);
            if (convertor == null) {
                try {
                    Class cls = Loader.loadClass(JSON.class, clsName);
                    convertor = new JSONPojoConvertor(cls);
                    this._json.addConvertorFor(clsName, convertor);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            if (convertor != null && !clsName.equals(Object.class.getName())) {
                return convertor.fromJSON(object);
            }
        }
        return map;
    }
}

