/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http.endpoints;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.servicemix.http.endpoints.HttpProviderMarshaler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHttpProviderMarshaler
implements HttpProviderMarshaler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Set<String> DEFAULT_HEADER_BLACKLIST = new HashSet<String>(Arrays.asList("Authorization", "Expect", "Forwarded", "From", "Host", "Content-Encoding", "Content-Type"));
    private String contentEncoding;
    private String acceptEncoding;
    private Set<String> headerBlackList = DEFAULT_HEADER_BLACKLIST;

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public String getAcceptEncoding() {
        return this.acceptEncoding;
    }

    public void setAcceptEncoding(String acceptEncoding) {
        this.acceptEncoding = acceptEncoding;
    }

    protected OutputStream getRequestEncodingStream(String encoding, OutputStream dataStream) throws IOException {
        if (encoding != null && encoding.toLowerCase().indexOf("gzip") >= 0) {
            this.logger.debug("Using gzip request encoding in provider marshaller.");
            return new GZIPOutputStream(new BufferedOutputStream(dataStream));
        }
        this.logger.debug("Using default request encoding in provider marshaller.");
        return new BufferedOutputStream(dataStream);
    }

    protected InputStream getResponseEncodingStream(String encoding, InputStream dataStream) throws IOException {
        if (encoding != null && encoding.toLowerCase().indexOf("gzip") >= 0) {
            this.logger.debug("Using gzip response encoding in provider marshaller.");
            return new GZIPInputStream(new BufferedInputStream(dataStream));
        }
        this.logger.debug("Using default response encoding in provider marshaller.");
        return new BufferedInputStream(dataStream);
    }

    protected boolean isBlackListed(String name) {
        return this.headerBlackList != null && this.headerBlackList.contains(name);
    }

    public Set<String> getHeaderBlackList() {
        return this.headerBlackList;
    }

    public void setHeaderBlackList(Set<String> headerBlackList) {
        this.headerBlackList = headerBlackList;
    }
}

