/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http.endpoints;

import java.io.InputStream;
import javax.jbi.management.DeploymentException;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.extensions.ElementExtensible;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.xml.namespace.QName;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.http.endpoints.HttpProviderEndpoint;
import org.apache.servicemix.http.endpoints.HttpSoapProviderMarshaler;
import org.apache.servicemix.soap.api.Policy;
import org.apache.servicemix.soap.util.DomUtil;
import org.apache.servicemix.soap.wsdl.BindingFactory;
import org.apache.servicemix.soap.wsdl.WSDLUtils;
import org.apache.servicemix.soap.wsdl.validator.WSIBPValidator;
import org.apache.woden.WSDLFactory;
import org.apache.woden.WSDLReader;
import org.apache.woden.types.NCName;
import org.apache.woden.wsdl20.Description;
import org.apache.woden.wsdl20.Endpoint;
import org.apache.woden.wsdl20.Service;
import org.apache.woden.wsdl20.xml.DescriptionElement;
import org.springframework.core.io.Resource;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class HttpSoapProviderEndpoint
extends HttpProviderEndpoint {
    private Resource wsdl;
    private boolean useJbiWrapper = true;
    private boolean validateWsdl = true;
    private Policy[] policies;

    public HttpSoapProviderEndpoint() {
    }

    public HttpSoapProviderEndpoint(DefaultComponent component, ServiceEndpoint endpoint) {
        super(component, endpoint);
    }

    public HttpSoapProviderEndpoint(ServiceUnit serviceUnit, QName service, String endpoint) {
        super(serviceUnit, service, endpoint);
    }

    public Resource getWsdl() {
        return this.wsdl;
    }

    public void setWsdl(Resource wsdl) {
        this.wsdl = wsdl;
    }

    public boolean isValidateWsdl() {
        return this.validateWsdl;
    }

    public void setValidateWsdl(boolean validateWsdl) {
        this.validateWsdl = validateWsdl;
    }

    public boolean isUseJbiWrapper() {
        return this.useJbiWrapper;
    }

    public void setUseJbiWrapper(boolean useJbiWrapper) {
        this.useJbiWrapper = useJbiWrapper;
    }

    public Policy[] getPolicies() {
        return this.policies;
    }

    public void setPolicies(Policy[] policies) {
        this.policies = policies;
    }

    public void validate() throws DeploymentException {
        HttpSoapProviderMarshaler marshaler;
        if (this.wsdl == null) {
            throw new DeploymentException("wsdl property must be set");
        }
        if (this.getMarshaler() instanceof HttpSoapProviderMarshaler) {
            marshaler = (HttpSoapProviderMarshaler)this.getMarshaler();
        } else if (this.getMarshaler() == null) {
            marshaler = new HttpSoapProviderMarshaler();
        } else {
            throw new DeploymentException("The configured marshaler must inherit HttpSoapProviderMarshaler");
        }
        try {
            this.description = DomUtil.parse((InputStream)this.wsdl.getInputStream());
            Element elem = this.description.getDocumentElement();
            if ("http://schemas.xmlsoap.org/wsdl/".equals(elem.getNamespaceURI())) {
                this.validateWsdl1(marshaler);
            } else if ("http://www.w3.org/2006/01/wsdl".equals(elem.getNamespaceURI())) {
                this.validateWsdl2(marshaler);
            } else {
                throw new DeploymentException("Unrecognized wsdl namespace: " + elem.getNamespaceURI());
            }
            marshaler.setUseJbiWrapper(this.useJbiWrapper);
            marshaler.setPolicies(this.policies);
            this.setMarshaler(marshaler);
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException("Unable to read WSDL from: " + this.wsdl, (Throwable)e);
        }
        super.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateWsdl1(HttpSoapProviderMarshaler marshaler) throws Exception {
        InputStream is = this.wsdl.getInputStream();
        try {
            Port port;
            javax.wsdl.Service svc;
            WSIBPValidator validator;
            InputSource inputSource = new InputSource(is);
            inputSource.setSystemId(this.wsdl.getURL().toString());
            Definition def = WSDLUtils.createWSDL11Reader().readWSDL(this.wsdl.getURL().toString(), inputSource);
            if (this.validateWsdl && !(validator = new WSIBPValidator(def)).isValid()) {
                throw new DeploymentException("WSDL is not WS-I BP compliant: " + validator.getErrors());
            }
            if (this.getService() != null) {
                svc = def.getService(this.getService());
                if (svc == null) {
                    throw new DeploymentException("Could not find service '" + this.getService() + "' in wsdl");
                }
            } else if (def.getServices().size() == 1) {
                svc = (javax.wsdl.Service)def.getServices().values().iterator().next();
                this.setService(svc.getQName());
            } else {
                throw new DeploymentException("If service is not set, the WSDL must contain a single service definition");
            }
            if (this.getEndpoint() != null) {
                port = svc.getPort(this.getEndpoint());
                if (port == null) {
                    throw new DeploymentException("Cound not find port '" + this.getEndpoint() + "' " + "in wsdl for service '" + this.getService() + "'");
                }
            } else if (svc.getPorts().size() == 1) {
                port = (Port)svc.getPorts().values().iterator().next();
                this.setEndpoint(port.getName());
            } else {
                throw new DeploymentException("If endpoint is not set, the WSDL service '" + this.getService() + "' " + "must contain a single port definition");
            }
            SOAPAddress sa11 = (SOAPAddress)WSDLUtils.getExtension((ElementExtensible)port, SOAPAddress.class);
            SOAP12Address sa12 = (SOAP12Address)WSDLUtils.getExtension((ElementExtensible)port, SOAP12Address.class);
            if (this.getLocationURI() != null) {
                marshaler.setBaseUrl(this.getLocationURI());
            } else if (sa11 != null) {
                marshaler.setBaseUrl(sa11.getLocationURI());
            } else if (sa12 != null) {
                marshaler.setBaseUrl(sa12.getLocationURI());
            } else {
                throw new DeploymentException("No locationURI set and no SOAP address defined on port '" + port.getName() + "'");
            }
            this.description = WSDLUtils.getWSDL11Factory().newWSDLWriter().getDocument(def);
            marshaler.setBinding(BindingFactory.createBinding((Port)port));
        }
        finally {
            is.close();
        }
    }

    protected void validateWsdl2(HttpSoapProviderMarshaler marshaler) throws Exception {
        new Wsdl2Validator().validate(marshaler);
    }

    protected class Wsdl2Validator {
        protected Wsdl2Validator() {
        }

        public void validate(HttpSoapProviderMarshaler marshaler) throws Exception {
            Endpoint endpoint;
            Service svc;
            WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
            reader.setFeature("http://ws.apache.org/woden/features/verbose", false);
            DescriptionElement descElement = reader.readWSDL(HttpSoapProviderEndpoint.this.wsdl.getURL().toString());
            Description desc = descElement.toComponent();
            if (HttpSoapProviderEndpoint.this.getService() != null) {
                svc = desc.getService(HttpSoapProviderEndpoint.this.getService());
                if (svc == null) {
                    throw new DeploymentException("Could not find service '" + HttpSoapProviderEndpoint.this.getService() + "' in wsdl");
                }
            } else if (desc.getServices().length == 1) {
                svc = desc.getServices()[0];
                HttpSoapProviderEndpoint.this.setService(svc.getName());
            } else {
                throw new DeploymentException("If service is not set, the WSDL must contain a single service definition");
            }
            if (HttpSoapProviderEndpoint.this.getEndpoint() != null) {
                endpoint = svc.getEndpoint(new NCName(HttpSoapProviderEndpoint.this.getEndpoint()));
                if (endpoint == null) {
                    throw new DeploymentException("Cound not find endpoint '" + HttpSoapProviderEndpoint.this.getEndpoint() + "' in wsdl for service '" + HttpSoapProviderEndpoint.this.getService() + "'");
                }
            } else if (svc.getEndpoints().length == 1) {
                endpoint = svc.getEndpoints()[0];
                HttpSoapProviderEndpoint.this.setEndpoint(endpoint.getName().toString());
            } else {
                throw new DeploymentException("If endpoint is not set, the WSDL service '" + HttpSoapProviderEndpoint.this.getService() + "' " + "must contain a single port definition");
            }
            marshaler.setBinding(BindingFactory.createBinding((Endpoint)endpoint));
        }
    }
}

