/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http.endpoints;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.namespace.QName;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.common.security.KeystoreManager;
import org.apache.servicemix.http.HttpComponent;
import org.apache.servicemix.http.HttpConfiguration;
import org.apache.servicemix.http.HttpEndpointType;
import org.apache.servicemix.http.SslParameters;
import org.apache.servicemix.http.endpoints.AbstractHttpProviderMarshaler;
import org.apache.servicemix.http.endpoints.DefaultHttpProviderMarshaler;
import org.apache.servicemix.http.endpoints.HttpProviderMarshaler;
import org.apache.servicemix.http.jetty.SmxHttpExchange;
import org.mortbay.jetty.client.Address;
import org.mortbay.jetty.client.HttpClient;
import org.mortbay.jetty.client.HttpExchange;
import org.mortbay.jetty.client.security.Authorization;
import org.mortbay.jetty.client.security.ProxyAuthorization;
import org.mortbay.jetty.client.security.Realm;
import org.mortbay.jetty.client.security.RealmResolver;
import org.mortbay.jetty.client.security.SimpleRealmResolver;
import org.mortbay.resource.Resource;
import org.mortbay.thread.QueuedThreadPool;
import org.mortbay.thread.ThreadPool;

public class HttpProviderEndpoint
extends ProviderEndpoint
implements HttpEndpointType {
    private HttpProviderMarshaler marshaler;
    private String locationURI;
    private int clientSoTimeout = 60000;
    private int providerExpirationTime = 300000;
    private int maxConnectionsPerAddress = 32;
    private HttpClient jettyClient;
    private boolean ownClient = false;
    private String principal;
    private String credentials;
    private String proxyHost;
    private int proxyPort = 80;
    private String proxyUsername;
    private String proxyPassword;
    private SslParameters ssl;
    private boolean expectGzippedResponse;
    private boolean gzipRequest;

    public HttpProviderEndpoint() {
    }

    public HttpProviderEndpoint(DefaultComponent component, ServiceEndpoint endpoint) {
        super(component, endpoint);
    }

    public HttpProviderEndpoint(ServiceUnit serviceUnit, QName service, String endpoint) {
        super(serviceUnit, service, endpoint);
    }

    public String getLocationURI() {
        return this.locationURI;
    }

    public void setLocationURI(String locationURI) {
        this.locationURI = locationURI;
    }

    public HttpProviderMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(HttpProviderMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public SslParameters getSsl() {
        return this.ssl;
    }

    public void setSsl(SslParameters ssl) {
        this.ssl = ssl;
    }

    public boolean isExpectGzippedResponse() {
        return this.expectGzippedResponse;
    }

    public void setExpectGzippedResponse(boolean expectGzippedResponse) {
        this.expectGzippedResponse = expectGzippedResponse;
    }

    public boolean isGzipRequest() {
        return this.gzipRequest;
    }

    public void setGzipRequest(boolean gzipRequest) {
        this.gzipRequest = gzipRequest;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public void setCredentials(String credentials) {
        this.credentials = credentials;
    }

    public void process(MessageExchange exchange) throws Exception {
        if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
            NormalizedMessage nm = exchange.getMessage("in");
            if (nm == null) {
                throw new IllegalStateException("Exchange has no input message");
            }
            Exchange httpEx = new Exchange(exchange);
            this.marshaler.createRequest(exchange, nm, httpEx);
            this.jettyClient.send((HttpExchange)httpEx);
        }
    }

    public synchronized void start() throws Exception {
        this.getConnectionPool();
    }

    public synchronized void stop() throws Exception {
        if (this.ownClient && this.jettyClient != null) {
            this.jettyClient.stop();
            this.jettyClient = null;
        }
        super.stop();
    }

    protected void handle(SmxHttpExchange httpExchange, MessageExchange exchange) throws IOException {
        try {
            this.marshaler.handleResponse(exchange, httpExchange);
        }
        catch (Exception e) {
            exchange.setError(e);
        }
        try {
            boolean txSync;
            boolean bl = txSync = exchange.getStatus() == ExchangeStatus.ACTIVE && exchange.isTransacted() && Boolean.TRUE.equals(exchange.getProperty("javax.jbi.messaging.sendSync"));
            if (txSync) {
                this.sendSync(exchange);
            } else {
                this.send(exchange);
            }
        }
        catch (Exception e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    protected void handleException(SmxHttpExchange httpExchange, MessageExchange exchange, Throwable ex) {
        try {
            boolean txSync;
            this.marshaler.handleException(exchange, httpExchange, ex);
            boolean bl = txSync = exchange.getStatus() == ExchangeStatus.ACTIVE && exchange.isTransacted() && Boolean.TRUE.equals(exchange.getProperty("javax.jbi.messaging.sendSync"));
            if (txSync) {
                this.sendSync(exchange);
            } else {
                this.send(exchange);
            }
        }
        catch (Exception e) {
            logger.warn("Unable to send back exchange in error", (Throwable)e);
        }
    }

    protected HttpClient getConnectionPool() throws Exception {
        if (this.jettyClient == null) {
            HttpComponent comp = (HttpComponent)this.getServiceUnit().getComponent();
            if (comp.getConfiguration().isJettyClientPerProvider() || this.proxyHost != null || this.ssl != null) {
                this.ownClient = true;
                this.jettyClient = new SSLManagedHttpClient();
                this.jettyClient.setThreadPool((ThreadPool)new QueuedThreadPool(this.getConfiguration().getJettyClientThreadPoolSize()));
                this.jettyClient.setConnectorType(2);
                if (this.proxyHost != null) {
                    this.jettyClient.setProxy(new Address(this.proxyHost, this.proxyPort));
                    if (this.proxyUsername != null) {
                        this.jettyClient.setProxyAuthentication((Authorization)new ProxyAuthorization(this.proxyUsername, this.proxyPassword));
                    }
                }
                this.jettyClient.setSoTimeout(this.getClientSoTimeout());
                this.jettyClient.setTimeout((long)this.getProviderExpirationTime());
                this.jettyClient.setMaxConnectionsPerAddress(this.getMaxConnectionsPerAddress());
                if (this.principal != null && this.credentials != null) {
                    this.jettyClient.setRealmResolver((RealmResolver)new SimpleRealmResolver(new Realm(){

                        public String getPrincipal() {
                            return HttpProviderEndpoint.this.principal;
                        }

                        public String getCredentials() {
                            return HttpProviderEndpoint.this.credentials;
                        }

                        public String getId() {
                            return null;
                        }
                    }));
                }
                this.jettyClient.start();
            } else {
                this.ownClient = false;
                this.jettyClient = comp.getConnectionPool();
            }
        }
        return this.jettyClient;
    }

    public int getClientSoTimeout() {
        return this.clientSoTimeout;
    }

    public void setClientSoTimeout(int clientTimeout) {
        this.clientSoTimeout = clientTimeout;
    }

    public int getProviderExpirationTime() {
        return this.providerExpirationTime;
    }

    public void setProviderExpirationTime(int providerExpirationTime) {
        this.providerExpirationTime = providerExpirationTime;
    }

    public int getMaxConnectionsPerAddress() {
        return this.maxConnectionsPerAddress;
    }

    public void setMaxConnectionsPerAddress(int maxConnectionsPerAddress) {
        this.maxConnectionsPerAddress = maxConnectionsPerAddress;
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.marshaler == null) {
            this.marshaler = new DefaultHttpProviderMarshaler();
        }
        if (this.marshaler instanceof DefaultHttpProviderMarshaler && this.locationURI != null) {
            ((DefaultHttpProviderMarshaler)this.marshaler).setLocationURI(this.locationURI);
        }
        if (this.marshaler instanceof AbstractHttpProviderMarshaler) {
            if (this.isGzipRequest()) {
                ((AbstractHttpProviderMarshaler)this.marshaler).setContentEncoding("gzip");
            }
            if (this.isExpectGzippedResponse()) {
                ((AbstractHttpProviderMarshaler)this.marshaler).setAcceptEncoding("gzip");
            }
        }
    }

    private HttpConfiguration getConfiguration() {
        return ((HttpComponent)this.getServiceUnit().getComponent()).getConfiguration();
    }

    protected class SSLManagedHttpClient
    extends HttpClient {
        protected SSLManagedHttpClient() {
        }

        protected SSLContext getSSLContext() throws IOException {
            if (HttpProviderEndpoint.this.ssl.getKeyStore() != null) {
                return this.getStrictSSLContext();
            }
            return this.getLooseSSLContext();
        }

        protected SSLContext getStrictSSLContext() throws IOException {
            try {
                if (HttpProviderEndpoint.this.ssl.isManaged()) {
                    KeystoreManager keystoreMgr = KeystoreManager.Proxy.create((Object)HttpProviderEndpoint.this.getConfiguration().getKeystoreManager());
                    return keystoreMgr.createSSLContext(HttpProviderEndpoint.this.ssl.getProvider(), HttpProviderEndpoint.this.ssl.getProtocol(), HttpProviderEndpoint.this.ssl.getKeyManagerFactoryAlgorithm(), HttpProviderEndpoint.this.ssl.getKeyStore(), HttpProviderEndpoint.this.ssl.getKeyAlias(), HttpProviderEndpoint.this.ssl.getTrustStore());
                }
                if (HttpProviderEndpoint.this.ssl.getTrustStore() == null) {
                    HttpProviderEndpoint.this.ssl.setTrustStore(HttpProviderEndpoint.this.ssl.getKeyStore());
                    HttpProviderEndpoint.this.ssl.setTrustStoreType(HttpProviderEndpoint.this.ssl.getKeyStoreType());
                    HttpProviderEndpoint.this.ssl.setTrustManagerFactoryAlgorithm(HttpProviderEndpoint.this.ssl.getKeyManagerFactoryAlgorithm());
                }
                InputStream keystoreInputStream = Resource.newResource((String)HttpProviderEndpoint.this.ssl.getKeyStore()).getInputStream();
                KeyStore keyStore = KeyStore.getInstance(HttpProviderEndpoint.this.ssl.getKeyStoreType());
                keyStore.load(keystoreInputStream, HttpProviderEndpoint.this.ssl.getKeyStorePassword() == null ? null : HttpProviderEndpoint.this.ssl.getKeyStorePassword().toString().toCharArray());
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(HttpProviderEndpoint.this.ssl.getKeyManagerFactoryAlgorithm());
                keyManagerFactory.init(keyStore, HttpProviderEndpoint.this.ssl.getKeyPassword() == null ? null : HttpProviderEndpoint.this.ssl.getKeyPassword().toString().toCharArray());
                KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
                InputStream truststoreInputStream = Resource.newResource((String)HttpProviderEndpoint.this.ssl.getTrustStore()).getInputStream();
                KeyStore trustStore = KeyStore.getInstance(HttpProviderEndpoint.this.ssl.getTrustStoreType());
                trustStore.load(truststoreInputStream, HttpProviderEndpoint.this.ssl.getTrustStorePassword() == null ? null : HttpProviderEndpoint.this.ssl.getTrustStorePassword().toString().toCharArray());
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(HttpProviderEndpoint.this.ssl.getTrustManagerFactoryAlgorithm());
                trustManagerFactory.init(trustStore);
                TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
                SSLContext context = HttpProviderEndpoint.this.ssl.getProvider() == null ? SSLContext.getInstance(HttpProviderEndpoint.this.ssl.getProtocol()) : SSLContext.getInstance(HttpProviderEndpoint.this.ssl.getProtocol(), HttpProviderEndpoint.this.ssl.getProvider());
                context.init(keyManagers, trustManagers, new SecureRandom());
                return context;
            }
            catch (GeneralSecurityException e) {
                throw (IOException)new IOException("Unable to create SSL context").initCause(e);
            }
        }
    }

    protected class Exchange
    extends SmxHttpExchange {
        MessageExchange jbiExchange;

        public Exchange(MessageExchange jbiExchange) {
            this.jbiExchange = jbiExchange;
        }

        protected void onResponseComplete() throws IOException {
            HttpProviderEndpoint.this.handle(this, this.jbiExchange);
        }

        protected void onConnectionFailed(Throwable throwable) {
            HttpProviderEndpoint.this.handleException(this, this.jbiExchange, throwable);
        }

        protected void onException(Throwable throwable) {
            HttpProviderEndpoint.this.handleException(this, this.jbiExchange, throwable);
        }

        protected void onExpire() {
            HttpProviderEndpoint.this.handleException(this, this.jbiExchange, new Exception("Http request expired."));
        }
    }
}

