/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http.endpoints;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.security.auth.Subject;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.servicemix.common.DefaultComponent;
import org.apache.servicemix.common.JbiConstants;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.endpoints.ConsumerEndpoint;
import org.apache.servicemix.http.ContextManager;
import org.apache.servicemix.http.HttpComponent;
import org.apache.servicemix.http.HttpEndpointType;
import org.apache.servicemix.http.HttpProcessor;
import org.apache.servicemix.http.LateResponseStrategy;
import org.apache.servicemix.http.SslParameters;
import org.apache.servicemix.http.endpoints.DefaultHttpConsumerMarshaler;
import org.apache.servicemix.http.endpoints.HttpConsumerMarshaler;
import org.apache.servicemix.http.exception.HttpTimeoutException;
import org.apache.servicemix.http.exception.LateResponseException;
import org.apache.servicemix.http.jetty.JaasJettyPrincipal;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationSupport;
import org.eclipse.jetty.server.Server;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HttpConsumerEndpoint
extends ConsumerEndpoint
implements HttpProcessor,
HttpEndpointType {
    public static final String MAIN_WSDL = "main.wsdl";
    private static final String EXCHANGE = MessageExchange.class.getName();
    private static final String MUTEX = MessageExchange.class.getName() + "Mutex";
    private static final String EXCHANGEID = MessageExchange.class.getName() + "Mutex";
    private String authMethod;
    private SslParameters ssl;
    private String locationURI;
    private HttpConsumerMarshaler marshaler;
    private long timeout;
    private URI defaultMep = JbiConstants.IN_OUT;
    private Map<String, Object> resources = new HashMap<String, Object>();
    private Map<String, Continuation> continuations = new ConcurrentHashMap<String, Continuation>();
    private Map<String, Object> mutexes = new ConcurrentHashMap<String, Object>();
    private Map<String, MessageExchange> sentExchanges = new ConcurrentHashMap<String, MessageExchange>();
    private Object httpContext;
    private boolean started = false;
    private LateResponseStrategy lateResponseStrategy = LateResponseStrategy.error;
    private boolean rewriteSoapAddress = false;

    public HttpConsumerEndpoint() {
    }

    public HttpConsumerEndpoint(DefaultComponent component, ServiceEndpoint endpoint) {
        super(component, endpoint);
    }

    public HttpConsumerEndpoint(ServiceUnit serviceUnit, QName service, String endpoint) {
        super(serviceUnit, service, endpoint);
    }

    public String getLocationURI() {
        return this.locationURI;
    }

    public void setLocationURI(String locationURI) {
        this.locationURI = locationURI;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public HttpConsumerMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(HttpConsumerMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String authMethod) {
        this.authMethod = authMethod;
    }

    public SslParameters getSsl() {
        return this.ssl;
    }

    public void setSsl(SslParameters ssl) {
        this.ssl = ssl;
    }

    public URI getDefaultMep() {
        return this.defaultMep;
    }

    public void setDefaultMep(URI defaultMep) {
        this.defaultMep = defaultMep;
    }

    public String getLateResponseStrategy() {
        return this.lateResponseStrategy.name();
    }

    public void setLateResponseStrategy(String value) {
        this.lateResponseStrategy = LateResponseStrategy.valueOf(value);
    }

    public boolean isRewriteSoapAddress() {
        return this.rewriteSoapAddress;
    }

    public void setRewriteSoapAddress(boolean value) {
        this.rewriteSoapAddress = value;
    }

    public void activate() throws Exception {
        super.activate();
        this.loadStaticResources();
        this.httpContext = this.getServerManager().createContext(this.locationURI, this);
    }

    public void deactivate() throws Exception {
        this.getServerManager().remove(this.httpContext);
        this.httpContext = null;
        super.deactivate();
    }

    public void start() throws Exception {
        super.start();
        this.started = true;
        if (this.httpContext instanceof Server.Graceful) {
            ((Server.Graceful)this.httpContext).setShutdown(false);
        }
    }

    public void stop() throws Exception {
        if (this.httpContext instanceof Server.Graceful) {
            ((Server.Graceful)this.httpContext).setShutdown(true);
        }
        this.started = false;
        super.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(MessageExchange exchange) throws Exception {
        String id = exchange.getExchangeId();
        Continuation continuation = this.continuations.get(id);
        if (continuation != null) {
            Object mutex = continuation.getAttribute(MUTEX);
            if (mutex == null) {
                this.handleLateResponse(exchange);
                return;
            }
            Object object = mutex;
            synchronized (object) {
                if (!continuation.isExpired() && !continuation.isResumed()) {
                    logger.debug("Resuming continuation for exchange: {}", (Object)id);
                    continuation.setAttribute(EXCHANGE, (Object)exchange);
                    continuation.resume();
                    if (!continuation.isResumed()) {
                        this.handleLateResponse(exchange);
                    }
                } else {
                    this.handleLateResponse(exchange);
                }
            }
        } else {
            this.handleLateResponse(exchange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Continuation continuation = null;
        Object mutex = null;
        String id = null;
        try {
            MessageExchange exchange;
            if (this.handleStaticResource(request, response)) {
                return;
            }
            continuation = ContinuationSupport.getContinuation((ServletRequest)request);
            mutex = this.getOrCreateMutex(continuation);
            boolean sendExchange = false;
            Object object = mutex;
            synchronized (object) {
                exchange = (MessageExchange)continuation.getAttribute(EXCHANGE);
                id = (String)continuation.getAttribute(EXCHANGEID);
                if (exchange == null) {
                    long timeoutMs = this.obtainTimeout();
                    if (continuation.isExpired()) {
                        throw new HttpTimeoutException(id);
                    }
                    logger.debug("Receiving HTTP request: {}", (Object)request);
                    if (!this.started) {
                        response.sendError(503, "Endpoint is stopped");
                        return;
                    }
                    continuation.setTimeout(timeoutMs);
                    exchange = this.createExchange(request);
                    id = exchange.getExchangeId();
                    continuation.setAttribute(MUTEX, mutex);
                    continuation.setAttribute(EXCHANGEID, (Object)id);
                    this.mutexes.put(id, mutex);
                    this.continuations.put(id, continuation);
                    this.sentExchanges.put(id, exchange);
                    logger.debug("Suspending continuation for exchange: {}", (Object)id);
                    continuation.suspend((ServletResponse)response);
                    sendExchange = true;
                }
            }
            if (sendExchange) {
                this.send(exchange);
                return;
            }
            logger.debug("Resuming HTTP request: {}", (Object)request);
            this.doClean(mutex, continuation, id);
            this.handleResponse(exchange, request, response);
        }
        catch (Exception e) {
            this.sendError(this.doClean(mutex, continuation, id), e, request, response);
        }
    }

    private long obtainTimeout() {
        long to = this.timeout;
        if (to == 0L) {
            to = ((HttpComponent)this.getServiceUnit().getComponent()).getConfiguration().getConsumerProcessorSuspendTime();
        }
        return to;
    }

    private void handleResponse(MessageExchange exchange, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (exchange.getStatus() == ExchangeStatus.ERROR) {
            Exception e = exchange.getError();
            if (e == null) {
                e = new Exception("Unknown error (exchange aborted ?)");
            }
            throw e;
        }
        if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
            try {
                Fault fault = exchange.getFault();
                if (fault != null) {
                    this.sendFault(exchange, fault, request, response);
                } else {
                    NormalizedMessage outMsg = exchange.getMessage("out");
                    if (outMsg != null) {
                        this.sendOut(exchange, outMsg, request, response);
                    }
                }
                this.done(exchange);
            }
            catch (Exception e) {
                this.fail(exchange, e);
                throw e;
            }
        } else if (exchange.getStatus() == ExchangeStatus.DONE) {
            this.sendAccepted(exchange, request, response);
        }
    }

    private void handleLateResponse(MessageExchange exchange) throws Exception {
        logger.warn(LateResponseException.createMessage(exchange));
        if (exchange.getStatus() == ExchangeStatus.ACTIVE) {
            if (this.lateResponseStrategy == LateResponseStrategy.error) {
                this.fail(exchange, new LateResponseException(exchange));
            } else {
                this.done(exchange);
            }
        }
    }

    private Object getOrCreateMutex(Continuation continuation) {
        Object result = null;
        if (continuation != null) {
            result = continuation.getAttribute(MUTEX);
        }
        if (result == null) {
            result = new Object();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageExchange doClean(Object mutex, Continuation continuation, String exchangeId) {
        if (mutex != null) {
            Object object = mutex;
            synchronized (object) {
                if (exchangeId == null && continuation != null) {
                    exchangeId = (String)continuation.getAttribute(EXCHANGEID);
                }
                if (exchangeId != null && continuation == null) {
                    continuation = this.continuations.remove(exchangeId);
                }
                if (continuation != null) {
                    continuation.removeAttribute(EXCHANGEID);
                    continuation.removeAttribute(EXCHANGE);
                    continuation.removeAttribute(MUTEX);
                }
                if (exchangeId != null) {
                    this.mutexes.remove(exchangeId);
                    this.continuations.remove(exchangeId);
                    return this.sentExchanges.remove(exchangeId);
                }
            }
        }
        return null;
    }

    protected void loadStaticResources() throws Exception {
    }

    protected boolean handleStaticResource(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Object res;
        if (!"GET".equals(request.getMethod())) {
            return false;
        }
        String query = request.getQueryString();
        if (query != null && query.trim().equalsIgnoreCase("wsdl") && this.getResource(MAIN_WSDL) != null) {
            String uri = request.getRequestURI();
            if (!uri.endsWith("/")) {
                uri = uri + "/";
            }
            uri = uri + MAIN_WSDL;
            response.sendRedirect(uri);
            return true;
        }
        String path = request.getPathInfo();
        if (path.indexOf(47) >= 0) {
            path = path.substring(path.indexOf(47) + 1);
        }
        if (this.rewriteSoapAddress && path.equals(MAIN_WSDL) && this.getResource(path) instanceof Document) {
            String location = this.getLocationURI();
            try {
                URL listUrl = new URL(this.getLocationURI());
                URL requestUrl = new URL(request.getRequestURL().toString());
                URL acceptUri = new URL(requestUrl.getProtocol(), requestUrl.getHost(), requestUrl.getPort(), listUrl.getFile());
                location = acceptUri.toExternalForm();
                Document copy = (Document)((Document)this.getResource(path)).cloneNode(true);
                this.updateSoapLocations(location, copy.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/soap12/", "address"));
                this.updateSoapLocations(location, copy.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/soap/", "address"));
                res = copy;
            }
            catch (Exception e) {
                logger.warn("Could not update soap location, using default", (Throwable)e);
                res = this.getResource(path);
            }
        } else {
            res = this.getResource(path);
        }
        if (res == null) {
            return false;
        }
        if (res instanceof Node) {
            response.setStatus(200);
            response.setContentType("text/xml");
            try {
                new SourceTransformer().toResult((Source)new DOMSource((Node)res), (Result)new StreamResult((OutputStream)response.getOutputStream()));
            }
            catch (TransformerException e) {
                throw new ServletException("Error while sending xml resource", (Throwable)e);
            }
        } else {
            if (res != null) {
                throw new ServletException("Unable to serialize resource");
            }
            return false;
        }
        return true;
    }

    protected Object getResource(String path) {
        return this.resources.get(path);
    }

    protected void addResource(String path, Object resource) {
        this.resources.put(path, resource);
    }

    protected ContextManager getServerManager() {
        HttpComponent comp = (HttpComponent)this.getServiceUnit().getComponent();
        return comp.getServer();
    }

    public MessageExchange createExchange(HttpServletRequest request) throws Exception {
        MessageExchange me = this.marshaler.createExchange(request, this.getContext());
        if (me.getEndpoint() == null) {
            this.configureExchangeTarget(me);
        }
        if (request.getUserPrincipal() instanceof JaasJettyPrincipal) {
            Subject subject = ((JaasJettyPrincipal)request.getUserPrincipal()).getSubject();
            me.getMessage("in").setSecuritySubject(subject);
        }
        return me;
    }

    public void sendAccepted(MessageExchange exchange, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.marshaler.sendAccepted(exchange, request, response);
    }

    public void sendError(MessageExchange exchange, Exception error, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.marshaler.sendError(exchange, error, request, response);
    }

    public void sendFault(MessageExchange exchange, Fault fault, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.marshaler.sendFault(exchange, fault, request, response);
    }

    public void sendOut(MessageExchange exchange, NormalizedMessage outMsg, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.marshaler.sendOut(exchange, outMsg, request, response);
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.locationURI == null || this.locationURI.trim().length() < 1) {
            throw new DeploymentException("The location URI is mandatory.");
        }
        if (this.endpoint != null && this.endpoint.contains(":")) {
            throw new DeploymentException("Endpoint name contains ':'. This character is not allowed as it can provide invalid WSDL.");
        }
        if (this.marshaler == null) {
            this.marshaler = new DefaultHttpConsumerMarshaler();
        }
        if (this.marshaler instanceof DefaultHttpConsumerMarshaler) {
            ((DefaultHttpConsumerMarshaler)this.marshaler).setDefaultMep(this.getDefaultMep());
        }
    }

    protected void updateSoapLocations(String location, NodeList addresses) {
        for (int i = 0; i < addresses.getLength(); ++i) {
            Element address = (Element)addresses.item(i);
            if (!this.getLocationURI().equals(address.getAttribute("location"))) continue;
            address.setAttribute("location", location);
        }
    }
}

