/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.mail.marshaler;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.DataSource;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.servicemix.components.util.MarshalerSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMailMarshaler
extends MarshalerSupport {
    public static final String MAIL_TAG_TO = "To";
    public static final String MAIL_TAG_CC = "Cc";
    public static final String MAIL_TAG_BCC = "Bcc";
    public static final String MAIL_TAG_FROM = "From";
    public static final String MAIL_TAG_SUBJECT = "Subject";
    public static final String MAIL_TAG_REPLYTO = "Reply-To";
    public static final String MAIL_TAG_SENTDATE = "Date";
    public static final String MSG_TAG_TO = "org.apache.servicemix.mail.to";
    public static final String MSG_TAG_CC = "org.apache.servicemix.mail.cc";
    public static final String MSG_TAG_BCC = "org.apache.servicemix.mail.bcc";
    public static final String MSG_TAG_FROM = "org.apache.servicemix.mail.from";
    public static final String MSG_TAG_SUBJECT = "org.apache.servicemix.mail.subject";
    public static final String MSG_TAG_REPLYTO = "org.apache.servicemix.mail.replyto";
    public static final String MSG_TAG_SENTDATE = "org.apache.servicemix.mail.sentdate";
    public static final String MSG_TAG_MAIL_CONTENT_TYPE = "org.apache.servicemix.mail.type";
    public static final String MSG_TAG_MAIL_CHARSET = "org.apache.servicemix.mail.charset";
    public static final String MSG_TAG_MAIL_USE_INLINE_ATTACHMENTS = "org.apache.servicemix.mail.attachments.inline";
    public static final String MSG_TAG_TEXT = "org.apache.servicemix.mail.text";
    public static final String MSG_TAG_HTML = "org.apache.servicemix.mail.html";
    public static final String DEFAULT_SENDER = "no-reply@localhost";
    public static final String MSG_TAG_USER = "org.apache.servicemix.mail.username";
    public static final String MSG_TAG_PASSWORD = "org.apache.servicemix.mail.password";
    public static final String MSG_TAG_HOST = "org.apache.servicemix.mail.host";
    public static final String MSG_TAG_PROTOCOL = "org.apache.servicemix.mail.protocol";
    public static final String MSG_TAG_PORT = "org.apache.servicemix.mail.port";
    public static final String DUMMY_SUBJECT = "no subject";
    public static final String DUMMY_CONTENT = "<no-content />";
    private final Map<String, List<File>> temporaryFilesMap = Collections.synchronizedMap(new HashMap());

    public abstract void convertMailToJBI(MessageExchange var1, NormalizedMessage var2, MimeMessage var3) throws MessagingException;

    public abstract void convertJBIToMail(MimeMessage var1, MessageExchange var2, NormalizedMessage var3, String var4, String var5) throws MessagingException;

    public String getDefaultSenderForOutgoingMails() {
        return DEFAULT_SENDER;
    }

    protected final Map<String, DataSource> getAttachmentsMapFromNormalizedMessage(NormalizedMessage normalizedMessage) {
        HashMap<String, DataSource> attachments = new HashMap<String, DataSource>();
        Set attNames = normalizedMessage.getAttachmentNames();
        for (Object attName : attNames) {
            String oneAttachmentName = (String)attName;
            DataSource oneAttchmentInputString = normalizedMessage.getAttachment(oneAttachmentName).getDataSource();
            attachments.put(oneAttachmentName, oneAttchmentInputString);
        }
        return attachments;
    }

    protected final void addTemporaryResource(String id, File tmpFile) {
        if (!this.temporaryFilesMap.containsKey(id)) {
            this.temporaryFilesMap.put(id, new ArrayList());
        }
        this.temporaryFilesMap.get(id).add(tmpFile);
    }

    public final void cleanUpResources(String id) {
        List<File> list = this.temporaryFilesMap.get(id);
        if (list != null) {
            for (File f : list) {
                f.delete();
            }
            list.clear();
            this.temporaryFilesMap.remove(id);
        }
    }
}

