/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Vector;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.asn1.BERSerializable;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.VariableBinding;

public class PDU
implements BERSerializable,
Serializable {
    private static final long serialVersionUID = 7607672475629607472L;
    public static final int GET = -96;
    public static final int GETNEXT = -95;
    public static final int RESPONSE = -94;
    public static final int SET = -93;
    public static final int V1TRAP = -92;
    public static final int GETBULK = -91;
    public static final int INFORM = -90;
    public static final int TRAP = -89;
    public static final int NOTIFICATION = -89;
    public static final int REPORT = -88;
    public static final int noError = 0;
    public static final int tooBig = 1;
    public static final int noSuchName = 2;
    public static final int badValue = 3;
    public static final int readOnly = 4;
    public static final int genErr = 5;
    public static final int noAccess = 6;
    public static final int wrongType = 7;
    public static final int wrongLength = 8;
    public static final int wrongValue = 10;
    public static final int wrongEncoding = 9;
    public static final int noCreation = 11;
    public static final int inconsistentValue = 12;
    public static final int resourceUnavailable = 13;
    public static final int commitFailed = 14;
    public static final int undoFailed = 15;
    public static final int authorizationError = 16;
    public static final int notWritable = 17;
    public static final int inconsistentName = 18;
    protected Vector variableBindings = new Vector();
    protected Integer32 errorStatus = new Integer32();
    protected Integer32 errorIndex = new Integer32();
    protected Integer32 requestID = new Integer32();
    protected int type = -96;

    public PDU() {
    }

    public PDU(PDU pDU) {
        this.variableBindings = (Vector)pDU.variableBindings.clone();
        this.errorIndex = (Integer32)pDU.errorIndex.clone();
        this.errorStatus = (Integer32)pDU.errorStatus.clone();
        this.type = pDU.type;
        this.requestID = (Integer32)pDU.requestID.clone();
    }

    public void add(VariableBinding variableBinding) {
        if (variableBinding.getVariable().isDynamic()) {
            VariableBinding variableBinding2 = (VariableBinding)variableBinding.clone();
            this.variableBindings.add(variableBinding2);
        } else {
            this.variableBindings.add(variableBinding);
        }
    }

    public void addOID(VariableBinding variableBinding) {
        VariableBinding variableBinding2 = new VariableBinding(variableBinding.getOid());
        this.variableBindings.add(variableBinding2);
    }

    public void addAll(VariableBinding[] variableBindingArray) {
        this.variableBindings.ensureCapacity(this.variableBindings.size() + variableBindingArray.length);
        for (int i = 0; i < variableBindingArray.length; ++i) {
            this.add(variableBindingArray[i]);
        }
    }

    public void addAllOIDs(VariableBinding[] variableBindingArray) {
        this.variableBindings.ensureCapacity(this.variableBindings.size() + variableBindingArray.length);
        for (int i = 0; i < variableBindingArray.length; ++i) {
            this.addOID(variableBindingArray[i]);
        }
    }

    public VariableBinding get(int n) {
        return (VariableBinding)this.variableBindings.get(n);
    }

    public VariableBinding set(int n, VariableBinding variableBinding) {
        if (variableBinding == null) {
            throw new NullPointerException("Variable binding must not be null");
        }
        return this.variableBindings.set(n, variableBinding);
    }

    public void remove(int n) {
        this.variableBindings.remove(n);
    }

    public int size() {
        return this.variableBindings.size();
    }

    public Vector getVariableBindings() {
        return this.variableBindings;
    }

    public void trim() {
        if (this.variableBindings.size() > 0) {
            this.variableBindings.remove(this.variableBindings.size() - 1);
        }
    }

    public void setErrorStatus(int n) {
        this.errorStatus.setValue(n);
    }

    public int getErrorStatus() {
        return this.errorStatus.getValue();
    }

    public String getErrorStatusText() {
        return PDU.toErrorStatusText(this.errorStatus.getValue());
    }

    public static final String toErrorStatusText(int n) {
        try {
            return SnmpConstants.SNMP_ERROR_MESSAGES[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "Unknown error: " + n;
        }
    }

    public void setErrorIndex(int n) {
        this.errorIndex.setValue(n);
    }

    public int getErrorIndex() {
        return this.errorIndex.getValue();
    }

    public boolean isConfirmedPdu() {
        return this.type != -88 && this.type != -94 && this.type != -89 && this.type != -92;
    }

    public int getBERLength() {
        int n = this.getBERPayloadLengthPDU();
        n += BER.getBERLengthOfLength(n) + 1;
        return n;
    }

    public int getBERPayloadLength() {
        return this.getBERPayloadLengthPDU();
    }

    public void decodeBER(BERInputStream bERInputStream) throws IOException {
        BER.MutableByte mutableByte = new BER.MutableByte();
        int n = BER.decodeHeader(bERInputStream, mutableByte);
        int n2 = (int)bERInputStream.getPosition();
        switch (mutableByte.getValue()) {
            case -96: 
            case -95: 
            case -94: 
            case -93: 
            case -91: 
            case -90: 
            case -89: 
            case -88: {
                break;
            }
            default: {
                throw new IOException("Unsupported PDU type: " + mutableByte.getValue());
            }
        }
        this.type = mutableByte.getValue();
        this.requestID.decodeBER(bERInputStream);
        this.errorStatus.decodeBER(bERInputStream);
        this.errorIndex.decodeBER(bERInputStream);
        mutableByte = new BER.MutableByte();
        int n3 = BER.decodeHeader(bERInputStream, mutableByte);
        if (mutableByte.getValue() != 48) {
            throw new IOException("Encountered invalid tag, SEQUENCE expected: " + mutableByte.getValue());
        }
        int n4 = (int)bERInputStream.getPosition();
        this.variableBindings = new Vector();
        while (bERInputStream.getPosition() - (long)n4 < (long)n3) {
            VariableBinding variableBinding = new VariableBinding();
            variableBinding.decodeBER(bERInputStream);
            this.variableBindings.add(variableBinding);
        }
        if (bERInputStream.getPosition() - (long)n4 != (long)n3) {
            throw new IOException("Length of VB sequence (" + n3 + ") does not match real length: " + ((int)bERInputStream.getPosition() - n4));
        }
        if (BER.isCheckSequenceLength()) {
            BER.checkSequenceLength(n, (int)bERInputStream.getPosition() - n2, this);
        }
    }

    protected int getBERPayloadLengthPDU() {
        int n = 0;
        for (int i = 0; i < this.variableBindings.size(); ++i) {
            n += ((VariableBinding)this.variableBindings.get(i)).getBERLength();
        }
        n += BER.getBERLengthOfLength(n) + 1;
        Integer32 integer32 = new Integer32(this.requestID.getValue());
        n += integer32.getBERLength();
        integer32 = this.errorStatus;
        n += integer32.getBERLength();
        integer32 = this.errorIndex;
        n += integer32.getBERLength();
        integer32 = null;
        return n;
    }

    public void encodeBER(OutputStream outputStream) throws IOException {
        int n;
        BER.encodeHeader(outputStream, this.type, this.getBERPayloadLengthPDU());
        this.requestID.encodeBER(outputStream);
        this.errorStatus.encodeBER(outputStream);
        this.errorIndex.encodeBER(outputStream);
        int n2 = 0;
        for (n = 0; n < this.variableBindings.size(); ++n) {
            n2 += ((VariableBinding)this.variableBindings.get(n)).getBERLength();
        }
        BER.encodeHeader(outputStream, 48, n2);
        for (n = 0; n < this.variableBindings.size(); ++n) {
            ((VariableBinding)this.variableBindings.get(n)).encodeBER(outputStream);
        }
    }

    public void clear() {
        this.variableBindings.clear();
        this.setRequestID(new Integer32(0));
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public Object clone() {
        return new PDU(this);
    }

    public Integer32 getRequestID() {
        return this.requestID;
    }

    public void setRequestID(Integer32 integer32) {
        this.requestID = integer32;
    }

    public static String getTypeString(int n) {
        switch (n) {
            case -96: {
                return "GET";
            }
            case -93: {
                return "SET";
            }
            case -95: {
                return "GETNEXT";
            }
            case -91: {
                return "GETBULK";
            }
            case -90: {
                return "INFORM";
            }
            case -94: {
                return "RESPONSE";
            }
            case -88: {
                return "REPORT";
            }
            case -89: {
                return "TRAP";
            }
            case -92: {
                return "V1TRAP";
            }
        }
        return "unknown";
    }

    public static int getTypeFromString(String string) {
        if (string.equals("GET")) {
            return -96;
        }
        if (string.equals("SET")) {
            return -93;
        }
        if (string.equals("GETNEXT")) {
            return -95;
        }
        if (string.equals("GETBULK")) {
            return -91;
        }
        if (string.equals("INFORM")) {
            return -90;
        }
        if (string.equals("RESPONSE")) {
            return -94;
        }
        if (string.equals("TRAP")) {
            return -89;
        }
        if (string.equals("V1TRAP")) {
            return -92;
        }
        if (string.equals("REPORT")) {
            return -88;
        }
        return Integer.MIN_VALUE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(PDU.getTypeString(this.type));
        stringBuffer.append("[requestID=");
        stringBuffer.append(this.requestID);
        stringBuffer.append(", errorStatus=");
        stringBuffer.append(this.getErrorStatusText() + "(" + this.errorStatus + ")");
        stringBuffer.append(", errorIndex=");
        stringBuffer.append(this.errorIndex);
        stringBuffer.append(", VBS[");
        for (int i = 0; i < this.variableBindings.size(); ++i) {
            stringBuffer.append(this.variableBindings.get(i));
            if (i + 1 >= this.variableBindings.size()) continue;
            stringBuffer.append("; ");
        }
        stringBuffer.append("]]");
        return stringBuffer.toString();
    }

    public int getMaxRepetitions() {
        return this.errorIndex.getValue();
    }

    public void setMaxRepetitions(int n) {
        this.errorIndex.setValue(n);
    }

    public int getNonRepeaters() {
        return this.errorStatus.getValue();
    }

    public void setNonRepeaters(int n) {
        this.errorStatus.setValue(n);
    }

    public VariableBinding[] toArray() {
        VariableBinding[] variableBindingArray = new VariableBinding[this.variableBindings.size()];
        this.variableBindings.toArray(variableBindingArray);
        return variableBindingArray;
    }
}

