/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.log;

import java.util.Collections;
import java.util.Iterator;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.NoLogger;

public class LogFactory {
    public static final String SNMP4J_LOG_FACTORY_SYSTEM_PROPERTY = "snmp4j.LogFactory";
    private static LogFactory snmp4jLogFactory = null;
    private static boolean configChecked = false;

    public static LogAdapter getLogger(Class clazz) {
        LogFactory.checkConfig();
        if (snmp4jLogFactory == null) {
            return NoLogger.instance;
        }
        return snmp4jLogFactory.createLogger(clazz.getName());
    }

    private static void checkConfig() {
        if (!configChecked) {
            configChecked = true;
            LogFactory.getFactoryFromSystemProperty();
        }
    }

    private static synchronized void getFactoryFromSystemProperty() {
        try {
            String string = System.getProperty(SNMP4J_LOG_FACTORY_SYSTEM_PROPERTY, null);
            if (string != null) {
                try {
                    Class<?> clazz = Class.forName(string);
                    snmp4jLogFactory = (LogFactory)clazz.newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InstantiationException instantiationException) {}
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public LogAdapter getRootLogger() {
        return NoLogger.instance;
    }

    public static LogAdapter getLogger(String string) {
        LogFactory.checkConfig();
        if (snmp4jLogFactory == null) {
            return NoLogger.instance;
        }
        return snmp4jLogFactory.createLogger(string);
    }

    protected LogAdapter createLogger(Class clazz) {
        return NoLogger.instance;
    }

    protected LogAdapter createLogger(String string) {
        return NoLogger.instance;
    }

    public static void setLogFactory(LogFactory logFactory) {
        configChecked = true;
        snmp4jLogFactory = logFactory;
    }

    public static LogFactory getLogFactory() {
        return snmp4jLogFactory;
    }

    public Iterator loggers() {
        return Collections.singletonList(NoLogger.instance).iterator();
    }
}

