/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.SMIAddress;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.Variable;

public class GenericAddress
extends SMIAddress {
    static final long serialVersionUID = -6102594326202231511L;
    public static final String TYPE_UDP = "udp";
    public static final String TYPE_TCP = "tcp";
    public static final String TYPE_IP = "ip";
    public static final String ADDRESS_TYPES_PROPERTIES = "org.snmp4j.addresses";
    private static final String ADDRESS_TYPES_PROPERTIES_DEFAULT = "address.properties";
    private static final LogAdapter logger = LogFactory.getLogger(GenericAddress.class);
    private SMIAddress address;
    private static Map knownAddressTypes = null;

    public GenericAddress() {
    }

    public GenericAddress(SMIAddress sMIAddress) {
        this.address = sMIAddress;
    }

    public int getSyntax() {
        return this.address.getSyntax();
    }

    public boolean isValid() {
        if (this.address == null) {
            return false;
        }
        return this.address.isValid();
    }

    public String toString() {
        return this.address.toString();
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public int compareTo(Object object) {
        return this.address.compareTo(object);
    }

    public boolean equals(Object object) {
        return this.address.equals(object);
    }

    public void decodeBER(BERInputStream bERInputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void encodeBER(OutputStream outputStream) throws IOException {
        this.address.encodeBER(outputStream);
    }

    public int getBERLength() {
        return this.address.getBERLength();
    }

    public void setAddress(SMIAddress sMIAddress) {
        this.address = sMIAddress;
    }

    public Address getAddress() {
        return this.address;
    }

    private static synchronized void registerAddressTypes() {
        if (SNMP4JSettings.isExtensibilityEnabled()) {
            String string;
            InputStream inputStream = Variable.class.getResourceAsStream(string = System.getProperty(ADDRESS_TYPES_PROPERTIES, ADDRESS_TYPES_PROPERTIES_DEFAULT));
            if (inputStream == null) {
                throw new InternalError("Could not read '" + string + "' from classpath!");
            }
            Properties properties = new Properties();
            try {
                properties.load(inputStream);
                TreeMap treeMap = new TreeMap();
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    String string3 = properties.getProperty(string2);
                    try {
                        Class<?> clazz = Class.forName(string3);
                        treeMap.put(string2, clazz);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        logger.error(classNotFoundException);
                    }
                }
                knownAddressTypes = treeMap;
            }
            catch (IOException iOException) {
                String string4 = "Could not read '" + string + "': " + iOException.getMessage();
                logger.error(string4);
                throw new InternalError(string4);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    logger.warn(iOException);
                }
            }
        }
        TreeMap<String, Class> treeMap = new TreeMap<String, Class>();
        treeMap.put(TYPE_UDP, UdpAddress.class);
        treeMap.put(TYPE_TCP, TcpAddress.class);
        treeMap.put(TYPE_IP, IpAddress.class);
        knownAddressTypes = treeMap;
    }

    public static Address parse(String string) {
        Class clazz;
        if (knownAddressTypes == null) {
            GenericAddress.registerAddressTypes();
        }
        String string2 = TYPE_UDP;
        int n = string.indexOf(58);
        if (n > 0) {
            string2 = string.substring(0, n);
            string = string.substring(n + 1);
        }
        if ((clazz = (Class)knownAddressTypes.get(string2 = string2.toLowerCase())) == null) {
            throw new IllegalArgumentException("Address type " + string2 + " unknown");
        }
        try {
            Address address = (Address)clazz.newInstance();
            if (address.parseAddress(string)) {
                return address;
            }
            return null;
        }
        catch (Exception exception) {
            logger.warn(exception);
            return null;
        }
    }

    public boolean parseAddress(String string) {
        Address address = GenericAddress.parse(string);
        if (address instanceof SMIAddress) {
            this.setAddress((SMIAddress)address);
            return true;
        }
        return false;
    }

    public Object clone() {
        return new GenericAddress(this.address);
    }

    public int toInt() {
        throw new UnsupportedOperationException();
    }

    public long toLong() {
        throw new UnsupportedOperationException();
    }

    public OID toSubIndex(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public void fromSubIndex(OID oID, boolean bl) {
        throw new UnsupportedOperationException();
    }

    public void setValue(String string) {
        if (!this.parseAddress(string)) {
            throw new IllegalArgumentException(string + " cannot be parsed by " + this.getClass().getName());
        }
    }
}

