/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.snmp;

import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.servicemix.common.endpoints.PollingEndpoint;
import org.apache.servicemix.snmp.SnmpEndpointType;
import org.apache.servicemix.snmp.marshaler.DefaultSnmpMarshaler;
import org.apache.servicemix.snmp.marshaler.SnmpMarshalerSupport;
import org.apache.servicemix.snmp.util.OIDList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class SnmpPollingEndpoint
extends PollingEndpoint
implements SnmpEndpointType,
ResponseListener {
    private final Logger logger = LoggerFactory.getLogger(SnmpPollingEndpoint.class);
    public static final String DEFAULT_COMMUNITY = "public";
    public static final int DEFAULT_SNMP_VERSION = 0;
    public static final int DEFAULT_SNMP_RETRIES = 2;
    public static final int DEFAULT_SNMP_TIMEOUT = 1500;
    private Address targetAddress;
    private TransportMapping transport;
    private Snmp snmp;
    private USM usm;
    private CommunityTarget target;
    private PDU pdu;
    private OIDList oids = new OIDList();
    private String address;
    private int retries = 2;
    private int timeout = 1500;
    private int snmpVersion = 0;
    private String snmpCommunity = "public";
    private SnmpMarshalerSupport marshaler = new DefaultSnmpMarshaler();

    public synchronized void activate() throws Exception {
        super.activate();
        this.targetAddress = GenericAddress.parse((String)this.address);
        this.transport = new DefaultUdpTransportMapping();
        this.snmp = new Snmp(this.transport);
        this.usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
        SecurityModels.getInstance().addSecurityModel((SecurityModel)this.usm);
        this.target = new CommunityTarget();
        this.target.setCommunity(new OctetString(this.snmpCommunity));
        this.target.setAddress(this.targetAddress);
        this.target.setRetries(this.retries);
        this.target.setTimeout((long)this.timeout);
        this.target.setVersion(this.snmpVersion);
        this.pdu = new PDU();
    }

    public synchronized void start() throws Exception {
        super.start();
        this.transport.listen();
    }

    public synchronized void stop() throws Exception {
        if (this.transport.isListening()) {
            this.transport.close();
        }
        super.stop();
    }

    public void validate() throws DeploymentException {
        super.validate();
        if (this.address == null) {
            throw new DeploymentException("The address attribute has to be specified!");
        }
        try {
            if (GenericAddress.parse((String)this.address) == null) {
                throw new DeploymentException("The specified address " + this.address + " is not valid!");
            }
        }
        catch (IllegalArgumentException ex) {
            throw new DeploymentException("The specified address " + this.address + " is not valid!");
        }
        if (this.oids == null || this.oids.size() <= 0) {
            throw new DeploymentException("There are no OIDs defined to be polled. Check your oids attribute.");
        }
    }

    public void poll() throws Exception {
        this.pdu.clear();
        this.pdu.setType(-96);
        for (OID oid : this.oids) {
            this.pdu.add(new VariableBinding(oid));
        }
        this.snmp.send(this.pdu, (Target)this.target, null, (ResponseListener)this);
    }

    public void process(MessageExchange exchange) throws Exception {
    }

    public void onResponse(ResponseEvent event) {
        ((Snmp)event.getSource()).cancel(event.getRequest(), (ResponseListener)this);
        if (event.getRequest() == null || event.getResponse() == null) {
            this.logger.debug("Received invalid snmp event. Request: {} / Response: {}", (Object)event.getRequest(), (Object)event.getResponse());
            return;
        }
        this.sendSnmpDataMessage(event.getRequest(), event.getResponse());
    }

    private void sendSnmpDataMessage(PDU request, PDU response) {
        try {
            InOnly io = this.getExchangeFactory().createInOnlyExchange();
            this.configureExchangeTarget((MessageExchange)io);
            NormalizedMessage inMsg = io.createMessage();
            this.marshaler.convertToJBI((MessageExchange)io, inMsg, request, response);
            io.setInMessage(inMsg);
            this.getChannel().send((MessageExchange)io);
        }
        catch (MessagingException ex) {
            this.logger.error("Error while trying to send the snmp event to the jbi bus", (Throwable)ex);
        }
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getSnmpVersion() {
        return this.snmpVersion;
    }

    public void setSnmpVersion(int snmpVersion) {
        this.snmpVersion = snmpVersion;
    }

    public String getSnmpCommunity() {
        return this.snmpCommunity;
    }

    public void setSnmpCommunity(String snmpCommunity) {
        this.snmpCommunity = snmpCommunity;
    }

    public SnmpMarshalerSupport getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(SnmpMarshalerSupport marshaler) {
        this.marshaler = marshaler;
    }

    public OIDList getOids() {
        return this.oids;
    }

    public void setOids(OIDList oids) {
        this.oids = oids;
    }
}

