/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.executors.impl;

import java.lang.reflect.Method;
import java.util.AbstractQueue;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.executors.Executor;
import org.apache.servicemix.executors.ExecutorFactory;
import org.apache.servicemix.executors.impl.ExecutorConfig;
import org.apache.servicemix.executors.impl.ExecutorImpl;
import org.apache.servicemix.executors.impl.FactoryFinder;
import org.apache.servicemix.executors.impl.ManagedExecutor;
import org.fusesource.commons.management.ManagementStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutorFactoryImpl
implements ExecutorFactory {
    private static final Log LOG = LogFactory.getLog(ExecutorFactoryImpl.class);
    private static final String OBJECT_NAME_PREFIX = "org.apache.servicemix:ContainerName=ServiceMix,Name=Executors,Type=";
    private static final String OBJECT_NAME_POSTFIX = ",SubType=";
    private ExecutorConfig defaultConfig = new ExecutorConfig(true, null);
    private MBeanServer mbeanServer;
    private ManagementStrategy managementStrategy;
    private Map<String, ExecutorConfig> configs = new HashMap<String, ExecutorConfig>();
    private Map<Executor, ObjectName> executorNames = new HashMap<Executor, ObjectName>();

    @Override
    public Executor createExecutor(String id) {
        ExecutorConfig config = this.getConfig(id);
        ExecutorImpl executor = new ExecutorImpl(this, this.createService(id, config), config.getShutdownDelay(), config.isBypassIfSynchronous());
        try {
            this.registerMBean(id, executor, config);
        }
        catch (Exception ex) {
            LOG.error((Object)("Unable to register MBean for the executor with id " + id), (Throwable)ex);
        }
        return executor;
    }

    @Override
    public Executor createDaemonExecutor(String id) {
        ExecutorConfig config = this.getConfig(id);
        config.setThreadDaemon(true);
        ExecutorImpl executor = new ExecutorImpl(this, this.createService(id, config), config.getShutdownDelay(), config.isBypassIfSynchronous());
        try {
            this.registerMBean(id, executor, config);
        }
        catch (Exception ex) {
            LOG.error((Object)("Unable to register MBean for the executor with id " + id), (Throwable)ex);
        }
        return executor;
    }

    protected ExecutorConfig getConfig(String id) {
        ExecutorConfig config = null;
        if (this.configs != null) {
            config = this.configs.get(id);
            while (config == null && id.indexOf(46) > 0) {
                id = id.substring(0, id.lastIndexOf(46));
                config = this.configs.get(id);
            }
        }
        if (config == null) {
            config = this.defaultConfig;
        }
        return config;
    }

    protected ThreadPoolExecutor createService(String id, ExecutorConfig config) {
        if (config.getQueueSize() != 0 && config.getCorePoolSize() == 0) {
            throw new IllegalArgumentException("CorePoolSize must be > 0 when using a capacity queue");
        }
        AbstractQueue queue = config.getQueueSize() == 0 ? new SynchronousQueue() : (config.getQueueSize() < 0 || config.getQueueSize() == Integer.MAX_VALUE ? new LinkedBlockingQueue() : new ArrayBlockingQueue(config.getQueueSize()));
        DefaultThreadFactory factory = new DefaultThreadFactory(id, config.isThreadDaemon(), config.getThreadPriority());
        RejectedExecutionHandler handler = (RejectedExecutionHandler)FactoryFinder.find(RejectedExecutionHandler.class.getName(), ThreadPoolExecutor.CallerRunsPolicy.class.getName());
        ThreadPoolExecutor service = new ThreadPoolExecutor(config.getCorePoolSize(), config.getMaximumPoolSize() < 0 ? Integer.MAX_VALUE : config.getMaximumPoolSize(), config.getKeepAliveTime(), TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)((Object)queue), factory, handler);
        if (config.isAllowCoreThreadsTimeout()) {
            try {
                Method mth = service.getClass().getMethod("allowCoreThreadTimeOut", Boolean.TYPE);
                mth.invoke((Object)service, Boolean.TRUE);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return service;
    }

    public Map<String, ExecutorConfig> getConfigs() {
        return this.configs;
    }

    public void setConfigs(Map<String, ExecutorConfig> configs) {
        this.configs = configs;
    }

    public ExecutorConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public void setDefaultConfig(ExecutorConfig defaultConfig) {
        this.defaultConfig = defaultConfig;
    }

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
        LOG.debug((Object)(">>>> SET MBEAN SERVER TO : " + mbeanServer));
    }

    public ManagementStrategy getManagementStrategy() {
        return this.managementStrategy;
    }

    public void setManagementStrategy(ManagementStrategy managementStrategy) {
        this.managementStrategy = managementStrategy;
        LOG.debug((Object)(">>>> SET MANAGEMENT STRATEGY TO : " + managementStrategy));
    }

    private void registerMBean(String id, ExecutorImpl executor, ExecutorConfig config) throws Exception {
        ManagedExecutor mbean = new ManagedExecutor(id, executor, config);
        ObjectName oName = null;
        if (this.managementStrategy != null) {
            if (this.hasSubType(id)) {
                oName = new ObjectName(String.format("%s%s%s%s", OBJECT_NAME_PREFIX, this.sanitize(this.getType(id)), OBJECT_NAME_POSTFIX, this.sanitize(this.getSubType(id))));
                this.managementStrategy.manageNamedObject((Object)mbean, (Object)oName);
            } else {
                oName = new ObjectName(String.format("%s%s", OBJECT_NAME_PREFIX, this.sanitize(id)));
                this.managementStrategy.manageNamedObject((Object)mbean, (Object)oName);
            }
        } else if (this.mbeanServer != null) {
            if (this.hasSubType(id)) {
                oName = new ObjectName(String.format("%s%s%s%s", OBJECT_NAME_PREFIX, this.sanitize(this.getType(id)), OBJECT_NAME_POSTFIX, this.sanitize(this.getSubType(id))));
                this.mbeanServer.registerMBean(mbean, oName);
            } else {
                oName = new ObjectName(String.format("%s%s", OBJECT_NAME_PREFIX, this.sanitize(id)));
                this.mbeanServer.registerMBean(mbean, oName);
            }
        }
        this.executorNames.put(mbean.getInternalExecutor(), oName);
    }

    void unregisterMBean(Executor executor) throws Exception {
        ObjectName oName = this.executorNames.remove(executor);
        if (this.managementStrategy != null) {
            this.managementStrategy.unmanageNamedObject((Object)oName);
        } else if (this.mbeanServer != null) {
            this.mbeanServer.unregisterMBean(oName);
        }
    }

    private String sanitize(String in) {
        String result = null;
        if (in != null) {
            result = in.replace(':', '_');
            result = result.replace('/', '_');
            result = result.replace('\\', '_');
            result = result.replace('?', '_');
            result = result.replace('=', '_');
            result = result.replace(',', '_');
        }
        return result;
    }

    private boolean hasSubType(String id) {
        return id.toLowerCase().trim().endsWith(".consumer") || id.toLowerCase().trim().endsWith(".provider");
    }

    private String getType(String id) {
        return id.substring(0, id.lastIndexOf("."));
    }

    private String getSubType(String id) {
        return id.substring(id.lastIndexOf(".") + 1);
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;
        final String id;
        final boolean daemon;
        final int priority;

        DefaultThreadFactory(String id, boolean daemon, int priority) {
            SecurityManager s = System.getSecurityManager();
            this.id = id;
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "pool-" + id + "-thread-";
            this.daemon = daemon;
            this.priority = priority;
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon() != this.daemon) {
                t.setDaemon(this.daemon);
            }
            if (t.getPriority() != this.priority) {
                t.setPriority(this.priority);
            }
            return t;
        }

        public String toString() {
            return "DefaultThreadFactory{  id=" + this.id + ", group=" + this.group + ", threadNumber=" + this.threadNumber + ", namePrefix='" + this.namePrefix + '\'' + ", daemon=" + this.daemon + ", priority=" + this.priority + '}';
        }
    }
}

