/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.converter;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Converters {
    private Map<Class<?>, Converter<?>> converters = new HashMap();

    public Converters() {
        this.converters.put(Boolean.class, new BooleanConverter());
        this.converters.put(Integer.class, new IntegerConverter());
        this.converters.put(Long.class, new LongConverter());
    }

    public <T> T as(Object value, Class<T> target) {
        if (value == null) {
            return null;
        }
        return this.getConverter(target).convert(value);
    }

    private <T> Converter<T> getConverter(Class<T> target) {
        return this.converters.get(target);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LongConverter
    implements Converter<Long> {
        private LongConverter() {
        }

        @Override
        public Long convert(Object value) {
            if (value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof Integer) {
                return ((Integer)value).longValue();
            }
            if (value instanceof String) {
                try {
                    return Long.parseLong((String)value);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IntegerConverter
    implements Converter<Integer> {
        private IntegerConverter() {
        }

        @Override
        public Integer convert(Object value) {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof String) {
                try {
                    return Integer.parseInt((String)value);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BooleanConverter
    implements Converter<Boolean> {
        private BooleanConverter() {
        }

        @Override
        public Boolean convert(Object value) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            String string = value.toString();
            if ("true".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string)) {
                return Boolean.parseBoolean(string);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Converter<T> {
        public T convert(Object var1);
    }
}

