/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.executors.impl;

import java.util.Map;
import org.apache.servicemix.converter.Converters;
import org.apache.servicemix.executors.ExecutorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutorConfig {
    public static final Integer DEFAULT_CORE_POOL_SIZE = 4;
    public static final Integer DEFAULT_MAXIMUM_POOL_SIZE = -1;
    public static final Long DEFAULT_KEEP_ALIVE_TIME = 60000L;
    public static final Boolean DEFAULT_THREAD_DAEMON = false;
    public static final Integer DEFAULT_THREAD_PRIORITY = 5;
    public static final Integer DEFAULT_QUEUE_SIZE = 1024;
    public static final Long DEFAULT_SHUTDOWN_DELAY = 1000L;
    public static final Boolean DEFAULT_ALLOW_CORE_THREAD_TIMEOUT = true;
    public static final Boolean DEFAULT_BYPASS_IF_SYNCHRONOUS = false;
    private ExecutorConfig parent;
    private Integer corePoolSize;
    private Integer maximumPoolSize;
    private Long keepAliveTime;
    private Boolean threadDaemon;
    private Integer threadPriority = 5;
    private Integer queueSize;
    private Long shutdownDelay;
    private Boolean allowCoreThreadTimeOut;
    private Boolean bypassIfSynchronous;

    public ExecutorConfig() {
        this(true, null);
    }

    public ExecutorConfig(boolean isDefaultConfig, ExecutorConfig parent) {
        this.parent = parent;
        if (isDefaultConfig) {
            this.setQueueSize(DEFAULT_QUEUE_SIZE);
            this.setShutdownDelay(DEFAULT_SHUTDOWN_DELAY);
            this.setThreadDaemon(DEFAULT_THREAD_DAEMON);
            this.setThreadPriority(DEFAULT_THREAD_PRIORITY);
            this.setAllowCoreThreadTimeOut(DEFAULT_ALLOW_CORE_THREAD_TIMEOUT);
            this.setBypassIfSynchronous(DEFAULT_BYPASS_IF_SYNCHRONOUS);
            this.setCorePoolSize(DEFAULT_CORE_POOL_SIZE);
            this.setKeepAliveTime(DEFAULT_KEEP_ALIVE_TIME);
            this.setMaximumPoolSize(DEFAULT_MAXIMUM_POOL_SIZE);
        }
    }

    public Integer getCorePoolSize() {
        return this.getParent() != null && this.corePoolSize == null ? this.getParent().getCorePoolSize() : this.corePoolSize;
    }

    public void setCorePoolSize(Integer corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public Long getKeepAliveTime() {
        return this.getParent() != null && this.keepAliveTime == null ? this.getParent().getKeepAliveTime() : this.keepAliveTime;
    }

    public void setKeepAliveTime(Long keepAlive) {
        this.keepAliveTime = keepAlive;
    }

    public Integer getMaximumPoolSize() {
        return this.getParent() != null && this.maximumPoolSize == null ? this.getParent().getMaximumPoolSize() : this.maximumPoolSize;
    }

    public void setMaximumPoolSize(Integer maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public Integer getQueueSize() {
        return this.getParent() != null && this.queueSize == null ? this.getParent().getQueueSize() : this.queueSize;
    }

    public void setQueueSize(Integer queueSize) {
        this.queueSize = queueSize;
    }

    public Boolean isThreadDaemon() {
        return this.getParent() != null && this.threadDaemon == null ? this.getParent().isThreadDaemon() : this.threadDaemon;
    }

    public void setThreadDaemon(Boolean threadDaemon) {
        this.threadDaemon = threadDaemon;
    }

    public Integer getThreadPriority() {
        return this.getParent() != null && this.threadPriority == null ? this.getParent().getThreadPriority() : this.threadPriority;
    }

    public void setThreadPriority(Integer threadPriority) {
        this.threadPriority = threadPriority;
    }

    public Long getShutdownDelay() {
        return this.getParent() != null && this.shutdownDelay == null ? this.getParent().getShutdownDelay() : this.shutdownDelay;
    }

    public void setShutdownDelay(Long shutdownDelay) {
        this.shutdownDelay = shutdownDelay;
    }

    public Boolean isAllowCoreThreadTimeOut() {
        return this.getParent() != null && this.allowCoreThreadTimeOut == null ? this.getParent().isAllowCoreThreadTimeOut() : this.allowCoreThreadTimeOut;
    }

    public void setAllowCoreThreadTimeOut(Boolean allowCoreThreadTimeOut) {
        this.allowCoreThreadTimeOut = allowCoreThreadTimeOut;
    }

    public Boolean isBypassIfSynchronous() {
        return this.getParent() != null && this.bypassIfSynchronous == null ? this.getParent().isBypassIfSynchronous() : this.bypassIfSynchronous;
    }

    public void setBypassIfSynchronous(Boolean bypassIfSynchronous) {
        this.bypassIfSynchronous = bypassIfSynchronous;
    }

    public ExecutorConfig getParent() {
        return this.parent;
    }

    public void setParent(ExecutorConfig parent) {
        this.parent = parent;
    }

    public static ExecutorConfig create(Map<String, Object> options, ExecutorConfig parent) {
        Converters converter = new Converters();
        ExecutorConfig result = new ExecutorConfig(false, parent);
        result.setCorePoolSize(converter.as(options.get(ExecutorFactory.CORE_POOL_SIZE), Integer.class));
        result.setMaximumPoolSize(converter.as(options.get(ExecutorFactory.MAXIMUM_POOL_SIZE), Integer.class));
        result.setQueueSize(converter.as(options.get(ExecutorFactory.QUEUE_SIZE), Integer.class));
        result.setThreadPriority(converter.as(options.get(ExecutorFactory.THREAD_PRIORITY), Integer.class));
        result.setKeepAliveTime(converter.as(options.get(ExecutorFactory.KEEP_ALIVE_TIME), Long.class));
        result.setShutdownDelay(converter.as(options.get(ExecutorFactory.SHUTDOWN_DELAY), Long.class));
        result.setAllowCoreThreadTimeOut(converter.as(options.get(ExecutorFactory.ALLOW_CORE_THREADS_TIMEOUT), Boolean.class));
        result.setBypassIfSynchronous(converter.as(options.get(ExecutorFactory.BYPASS_IF_SYNCHRONOUS), Boolean.class));
        result.setThreadDaemon(converter.as(options.get(ExecutorFactory.THREAD_DAEMON), Boolean.class));
        return result;
    }
}

