/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.store.krati;

import com.hazelcast.core.MapLoader;
import com.hazelcast.core.MapStore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import krati.core.StoreConfig;
import krati.core.StoreFactory;
import krati.core.segment.MemorySegmentFactory;
import krati.core.segment.SegmentFactory;
import krati.store.DataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KratiPersistenceProvider
implements MapLoader<String, Object>,
MapStore<String, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(KratiPersistenceProvider.class);
    private static final String DEFAULT_STORE_DIRECTORY = "/tmp/krati/";
    private static final Integer INIT_CAPACITY = 10000;
    private DataStore<byte[], byte[]> datas;
    private String storeDirectory = "/tmp/krati/";
    private int initCapacity = INIT_CAPACITY;
    private int segmentFileSizeMB = 8;

    public KratiPersistenceProvider() {
        try {
            this.init();
        }
        catch (Exception e) {
            LOG.error("Error during initialization", (Throwable)e);
        }
    }

    public KratiPersistenceProvider(String storeDirectory) {
        this.storeDirectory = storeDirectory;
        try {
            this.init();
        }
        catch (Exception e) {
            LOG.error("Error during initialization", (Throwable)e);
        }
    }

    public KratiPersistenceProvider(String storeDirectory, int initCapacity) {
        this.storeDirectory = storeDirectory;
        this.initCapacity = initCapacity;
        try {
            this.init();
        }
        catch (Exception e) {
            LOG.error("Error during initialization", (Throwable)e);
        }
    }

    public KratiPersistenceProvider(String storeDirectory, int initCapacity, int segmentFileSizeMB) {
        this.storeDirectory = storeDirectory;
        this.initCapacity = initCapacity;
        this.segmentFileSizeMB = segmentFileSizeMB;
        try {
            this.init();
        }
        catch (Exception e) {
            LOG.error("Error during initialization", (Throwable)e);
        }
    }

    public void init() throws Exception {
        if (this.datas == null) {
            StoreConfig config = new StoreConfig(new File(this.storeDirectory), this.initCapacity);
            config.setSegmentFactory((SegmentFactory)new MemorySegmentFactory());
            config.setSegmentFileSizeMB(this.segmentFileSizeMB);
            this.datas = StoreFactory.createDynamicDataStore((StoreConfig)config);
        }
    }

    public void destroy() throws Exception {
        if (this.datas != null && this.datas.isOpen()) {
            this.datas.close();
        }
    }

    public void delete(String key) {
        try {
            this.datas.delete((Object)key.getBytes());
        }
        catch (Exception e) {
            LOG.error("Error deleting object with id:{}", (Object)key, (Object)e);
        }
    }

    public void deleteAll(Collection<String> entries) {
        for (String key : entries) {
            try {
                this.datas.delete((Object)key.getBytes());
            }
            catch (Exception e) {
                LOG.error("Error deleting object with id:{}", (Object)key, (Object)e);
            }
        }
    }

    public void store(String key, Object value) {
        try {
            LOG.debug("Storing key: {}", (Object)key);
            this.datas.put((Object)key.getBytes(), (Object)this.writeObject(value));
        }
        catch (Exception e) {
            LOG.error("Error storing object with id:{}", (Object)key, (Object)e);
        }
    }

    public void storeAll(Map<String, Object> entries) {
        for (String key : entries.keySet()) {
            this.store(key, entries.get(key));
        }
    }

    public Object load(String key) {
        Object result = null;
        try {
            result = this.readObject((byte[])this.datas.get((Object)key.getBytes()));
        }
        catch (Exception e) {
            LOG.error("Error loading object with id: {}", (Object)key, (Object)e);
        }
        return result;
    }

    public Map<String, Object> loadAll(Collection<String> keys) {
        HashMap<String, Object> result = null;
        for (String key : keys) {
            if (result == null) {
                result = new HashMap<String, Object>();
            }
            result.put(key, this.load(key));
        }
        return result;
    }

    public Set<String> loadAllKeys() {
        HashSet<String> keys = null;
        while (this.datas.keyIterator().hasNext()) {
            String key = new String((byte[])this.datas.keyIterator().next());
            if (keys == null) {
                keys = new HashSet<String>();
            }
            keys.add(key);
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readObject(byte[] data) throws IOException, ClassNotFoundException {
        Object result = null;
        if (data != null) {
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
            try {
                result = ois.readObject();
            }
            finally {
                ois.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] writeObject(Object object) throws IOException {
        byte[] result = null;
        ByteArrayOutputStream buffer = null;
        ObjectOutputStream out = null;
        if (object != null) {
            try {
                buffer = new ByteArrayOutputStream();
                out = new ObjectOutputStream(buffer);
                out.writeObject(object);
            }
            finally {
                out.close();
            }
            result = buffer.toByteArray();
        }
        return result;
    }

    public int getSegmentFileSizeMB() {
        return this.segmentFileSizeMB;
    }

    public void setSegmentFileSizeMB(int segmentFileSizeMB) {
        this.segmentFileSizeMB = segmentFileSizeMB;
    }

    public String getStoreDirectory() {
        return this.storeDirectory;
    }

    public void setStoreDirectory(String storeDirectory) {
        this.storeDirectory = storeDirectory;
    }

    public int getInitCapacity() {
        return this.initCapacity;
    }

    public void setInitCapacity(int initCapacity) {
        this.initCapacity = initCapacity;
    }
}

