/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.specs.locator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiLocator {
    private static Map<String, List<Callable<Class>>> factories;
    private static ReadWriteLock lock;

    private OsgiLocator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(String id, Callable<Class> factory) {
        lock.writeLock().lock();
        try {
            List<Callable<Class>> l;
            if (factories != null && (l = factories.get(id)) != null) {
                l.remove(factory);
            }
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(String id, Callable<Class> factory) {
        lock.writeLock().lock();
        try {
            List<Callable<Class>> l;
            if (factories == null) {
                factories = new HashMap<String, List<Callable<Class>>>();
            }
            if ((l = factories.get(id)) == null) {
                l = new ArrayList<Callable<Class>>();
                factories.put(id, l);
            }
            l.add(factory);
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Class locate(String factoryId) {
        lock.readLock().lock();
        if (factories == null) return null;
        List<Callable<Class>> l = factories.get(factoryId);
        if (l == null) return null;
        if (l.isEmpty()) return null;
        String factoryClassName = System.getProperty(factoryId);
        try {
            if (factoryClassName != null) {
                Class c;
                Iterator<Callable<Class>> i$ = l.iterator();
                do {
                    if (!i$.hasNext()) return null;
                    Callable<Class> i = i$.next();
                    c = null;
                    try {
                        c = i.call();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                } while (c == null || !c.getName().equals(factoryClassName));
                Class clazz = c;
                lock.readLock().unlock();
                return clazz;
            }
        }
        catch (Exception exception) {
            // empty catch block
            return null;
        }
        {
            Callable<Class> callable = l.get(l.size() - 1);
            Class clazz = callable.call();
            lock.readLock().unlock();
            return clazz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Class> locateAll(String factoryId) {
        lock.readLock().lock();
        try {
            List<Callable<Class>> l;
            ArrayList<Class> classes = new ArrayList<Class>();
            if (factories != null && (l = factories.get(factoryId)) != null) {
                for (Callable<Class> c : l) {
                    try {
                        classes.add(c.call());
                    }
                    catch (Exception e) {}
                }
            }
            ArrayList<Class> arrayList = classes;
            return arrayList;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    static {
        lock = new ReentrantReadWriteLock();
    }
}

