/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.store.ehcache;

import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.DiskStoreConfiguration;

public class CacheManagerFactory {
    private Boolean diskPersistent = Boolean.TRUE;
    private Boolean eternal = Boolean.FALSE;
    private int maxElementsInMemory = 10000;
    private Boolean overflowToDisk = Boolean.TRUE;
    private long timeToIdleSeconds = 300L;
    private long timeToLiveSeconds = 300L;
    private String memoryStoreEvictionPolicy = "LRU";
    private String diskStorePath = ".";

    public CacheManager build() {
        Configuration configuration = new Configuration();
        CacheConfiguration defaultCacheConfiguration = new CacheConfiguration();
        defaultCacheConfiguration.setMaxElementsInMemory(this.maxElementsInMemory);
        defaultCacheConfiguration.setEternal(this.eternal.booleanValue());
        defaultCacheConfiguration.setTimeToIdleSeconds(this.timeToIdleSeconds);
        defaultCacheConfiguration.setTimeToLiveSeconds(this.timeToLiveSeconds);
        defaultCacheConfiguration.setOverflowToDisk(this.overflowToDisk.booleanValue());
        defaultCacheConfiguration.setDiskPersistent(this.diskPersistent.booleanValue());
        defaultCacheConfiguration.setMemoryStoreEvictionPolicy(this.memoryStoreEvictionPolicy);
        DiskStoreConfiguration diskStoreConfiguration = new DiskStoreConfiguration();
        diskStoreConfiguration.setPath(this.diskStorePath);
        configuration.addDiskStore(diskStoreConfiguration);
        configuration.addDefaultCache(defaultCacheConfiguration);
        CacheManager cacheManager = new CacheManager(configuration);
        return cacheManager;
    }

    public String getDiskStorePath() {
        return this.diskStorePath;
    }

    public void setDiskStorePath(String diskStorePath) {
        this.diskStorePath = diskStorePath;
    }

    public Boolean getDiskPersistent() {
        return this.diskPersistent;
    }

    public void setDiskPersistent(Boolean diskPersistent) {
        this.diskPersistent = diskPersistent;
    }

    public Boolean getEternal() {
        return this.eternal;
    }

    public void setEternal(Boolean eternal) {
        this.eternal = eternal;
    }

    public int getMaxElementsInMemory() {
        return this.maxElementsInMemory;
    }

    public void setMaxElementsInMemory(int maxElementsInMemory) {
        this.maxElementsInMemory = maxElementsInMemory;
    }

    public Boolean getOverflowToDisk() {
        return this.overflowToDisk;
    }

    public void setOverflowToDisk(Boolean overflowToDisk) {
        this.overflowToDisk = overflowToDisk;
    }

    public long getTimeToIdleSeconds() {
        return this.timeToIdleSeconds;
    }

    public void setTimeToIdleSeconds(long timeToIdleSeconds) {
        this.timeToIdleSeconds = timeToIdleSeconds;
    }

    public long getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public void setTimeToLiveSeconds(long timeToLiveSeconds) {
        this.timeToLiveSeconds = timeToLiveSeconds;
    }

    public String getMemoryStoreEvictionPolicy() {
        return this.memoryStoreEvictionPolicy;
    }

    public void setMemoryStoreEvictionPolicy(String memoryStoreEvictionPolicy) {
        this.memoryStoreEvictionPolicy = memoryStoreEvictionPolicy;
    }
}

