/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.store.krati;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import krati.store.DataStore;
import org.apache.servicemix.id.IdGenerator;
import org.apache.servicemix.store.Entry;
import org.apache.servicemix.store.base.BaseStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KratiStore
extends BaseStore {
    private static final Logger LOG = LoggerFactory.getLogger(KratiStore.class);
    private DataStore<byte[], byte[]> datas;
    private IdGenerator idGenerator = new IdGenerator();
    private final long timeout;

    public KratiStore(DataStore<byte[], byte[]> store) {
        this.datas = store;
        this.timeout = -1L;
    }

    public KratiStore(DataStore<byte[], byte[]> store, long timeout) {
        this.datas = store;
        this.timeout = timeout;
    }

    public KratiStore(DataStore<byte[], byte[]> store, long timeout, IdGenerator idGenerator) {
        this.datas = store;
        this.timeout = timeout;
        this.idGenerator = idGenerator;
    }

    @Override
    public boolean hasFeature(String feature) {
        return "Clustered".equals(feature);
    }

    @Override
    public void store(String key, Object value) {
        LOG.debug("Storing object with key:{}, value:{}", (Object)key, value);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            Entry entry = new Entry(value);
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(entry);
            out.close();
            this.datas.put((Object)key.getBytes(), (Object)buffer.toByteArray());
            this.fireAddedEvent(key, value);
        }
        catch (IOException e) {
            LOG.error("Error storing key:{}", (Object)key, (Object)e);
        }
        catch (Exception e) {
            LOG.error("Error storing key:{}", (Object)key, (Object)e);
        }
    }

    @Override
    public String store(Object data) throws IOException {
        String id = this.idGenerator.generateId();
        this.store(id, data);
        return id;
    }

    @Override
    public Object load(String id) throws IOException {
        LOG.debug("Loading/Removing object with id: {}", (Object)id);
        Object result = null;
        if (this.timeout > 0L) {
            this.evict();
        }
        result = this.peek(id);
        try {
            if (result != null && this.datas.delete((Object)id.getBytes())) {
                this.fireRemovedEvent(id, result);
            }
        }
        catch (Exception e) {
            LOG.error("Error deleting object with id: {}", (Object)id);
        }
        return result;
    }

    @Override
    public Object peek(String id) throws IOException {
        LOG.debug("Peeking object with id: {}", (Object)id);
        byte[] value = (byte[])this.datas.get((Object)id.getBytes());
        Entry result = null;
        try {
            result = (Entry)this.readObject(value);
        }
        catch (ClassNotFoundException e) {
            LOG.error("Error reading object with id: {}", (Object)id, (Object)e);
        }
        return result != null ? result.getData() : null;
    }

    public void delete(String id) throws Exception {
        LOG.debug("Deleting object with id: {}", (Object)id);
        this.datas.delete((Object)id.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readObject(byte[] data) throws IOException, ClassNotFoundException {
        Object result = null;
        if (data != null) {
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
            try {
                result = ois.readObject();
            }
            finally {
                ois.close();
            }
        }
        return result;
    }

    private void evict() {
        long now = System.currentTimeMillis();
        Iterator iter = this.datas.keyIterator();
        while (iter.hasNext()) {
            long age;
            byte[] key = (byte[])iter.next();
            String keyValue = null;
            Entry value = null;
            try {
                keyValue = new String(key);
                value = (Entry)this.readObject((byte[])this.datas.get((Object)key));
            }
            catch (Exception e) {
                LOG.error("Error reading object with id: {}", (Object)key, (Object)e);
            }
            if ((age = now - value.getTime()) <= this.timeout) continue;
            LOG.debug("Removing object with id {} from store after {} ms", (Object)keyValue, (Object)age);
            try {
                if (!this.datas.delete((Object)key)) continue;
                this.fireEvictedEvent(keyValue, value.getData());
            }
            catch (Exception e) {
                LOG.error("Error deleting object with id {}", (Object)keyValue);
            }
        }
    }

    public DataStore<byte[], byte[]> getDatas() {
        return this.datas;
    }

    public void setDatas(DataStore<byte[], byte[]> datas) {
        this.datas = datas;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }
}

