/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.store.krati;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import krati.core.StoreConfig;
import krati.core.StoreFactory;
import krati.core.segment.MemorySegmentFactory;
import krati.core.segment.SegmentFactory;
import krati.store.DataStore;
import krati.store.DynamicDataStore;
import org.apache.servicemix.store.Store;
import org.apache.servicemix.store.StoreListener;
import org.apache.servicemix.store.base.BaseStoreFactory;
import org.apache.servicemix.store.krati.KratiStore;
import org.apache.servicemix.store.mongo.MongoStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KratiStoreFactory
extends BaseStoreFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MongoStore.class);
    private static final String DEFAULT_STORE_DIRECTORY = "/tmp/krati/";
    private static final Integer INIT_CAPACITY = 10000;
    private Map<String, KratiStore> stores = new HashMap<String, KratiStore>();
    private long timeout = -1L;
    private String storeDirectory = "/tmp/krati/";
    private int initCapacity = INIT_CAPACITY;
    public static final String STORE_PREFIX = "org.apache.servicemix.stores";

    public synchronized Store open(String name) throws IOException {
        KratiStore store = this.stores.get(name);
        if (store == null) {
            DynamicDataStore dataStore = null;
            try {
                String storeName = "org.apache.servicemix.stores." + name;
                StringBuilder sb = new StringBuilder(this.storeDirectory);
                sb.append("/");
                File storeFolder = new File(sb.toString());
                storeFolder.mkdir();
                File file = new File(storeFolder, name);
                StoreConfig config = new StoreConfig(file, this.initCapacity);
                config.setSegmentFactory((SegmentFactory)new MemorySegmentFactory());
                config.setSegmentFileSizeMB(8);
                dataStore = StoreFactory.createDynamicDataStore((StoreConfig)config);
                store = this.timeout <= 0L ? new KratiStore((DataStore<byte[], byte[]>)dataStore) : new KratiStore((DataStore<byte[], byte[]>)dataStore, this.timeout);
                this.stores.put(name, store);
                for (StoreListener listener : this.storeListeners) {
                    store.addListener(listener);
                }
            }
            catch (Exception e) {
                LOG.error("Error during store initialization, {}", (Object)e, (Object)e);
            }
        }
        return store;
    }

    public synchronized void close(Store store) throws IOException {
        KratiStore kratiStore = (KratiStore)store;
        if (kratiStore.getDatas() != null && kratiStore.getDatas().isOpen()) {
            kratiStore.getDatas().close();
        }
        this.stores.remove(store);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public String getStoreDirectory() {
        return this.storeDirectory;
    }

    public void setStoreDirectory(String storeDirectory) {
        this.storeDirectory = storeDirectory;
    }

    public int getInitCapacity() {
        return this.initCapacity;
    }

    public void setInitCapacity(int initCapacity) {
        this.initCapacity = initCapacity;
    }
}

