/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.store.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.servicemix.store.base.BaseStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoStore
extends BaseStore {
    private static final Logger LOG = LoggerFactory.getLogger(MongoStore.class);
    private static final String ID = "_id";
    private static final String DATA = "data";
    private static final String TIMESTAMP = "_timestamp";
    private DB db;
    DBCollection collection;
    private Long timeout;

    public MongoStore(DB db, String collectionName) {
        this.db = db;
        this.collection = db.getCollection(collectionName);
    }

    public MongoStore(DB db, String collectionName, Long timeout) {
        this.db = db;
        this.collection = db.getCollection(collectionName);
        this.timeout = timeout;
    }

    public boolean hasFeature(String feature) {
        return "Persistent".equals(feature) || "Clustered".equals(feature);
    }

    public void store(String id, Object data) throws IOException {
        BasicDBObject object = new BasicDBObject();
        ObjectOutputStream out = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            out = new ObjectOutputStream(buffer);
            out.writeObject(data);
            object.put(ID, (Object)id);
            object.put(DATA, (Object)buffer.toByteArray());
            object.put(TIMESTAMP, (Object)System.currentTimeMillis());
        }
        catch (Exception e) {
            throw (IOException)new IOException("Error storing object").initCause(e);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        WriteResult result = this.collection.insert(new DBObject[]{object});
        if (result.getError() != null) {
            throw new IOException(result.getError());
        }
        this.fireAddedEvent(id, data);
    }

    public String store(Object data) throws IOException {
        BasicDBObject object = new BasicDBObject();
        object.put(DATA, data);
        WriteResult result = this.collection.insert(new DBObject[]{object});
        if (result.getError() != null) {
            throw new IOException(result.getError());
        }
        return String.valueOf(result.getField(ID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(String id) throws IOException {
        this.evict();
        Object obj = null;
        try {
            BasicDBObject object = new BasicDBObject();
            object.put(ID, (Object)id);
            DBObject item = this.collection.findOne((DBObject)object);
            WriteResult result = this.collection.remove((DBObject)object);
            if (item == null) {
                throw new IOException("Could not find item with id " + id);
            }
            byte[] data = (byte[])item.get(DATA);
            if (data != null) {
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
                try {
                    obj = ois.readObject();
                }
                finally {
                    ois.close();
                }
            }
            this.fireRemovedEvent(id, data);
        }
        catch (Exception e) {
            throw (IOException)new IOException("Error loading object").initCause(e);
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek(String id) throws IOException {
        Object obj;
        block5: {
            this.evict();
            obj = null;
            try {
                BasicDBObject object = new BasicDBObject();
                object.put(ID, (Object)id);
                DBObject item = this.collection.findOne((DBObject)object);
                byte[] data = (byte[])item.get(DATA);
                if (data == null) break block5;
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
                try {
                    obj = ois.readObject();
                }
                finally {
                    ois.close();
                }
            }
            catch (Exception e) {
                throw (IOException)new IOException("Error loading object").initCause(e);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evict() {
        if (this.timeout != null) {
            BasicDBObject object = new BasicDBObject();
            object.put(TIMESTAMP, (Object)new BasicDBObject("&lt", (Object)(System.currentTimeMillis() - this.timeout)));
            DBCursor items = this.collection.find((DBObject)object);
            WriteResult result = this.collection.remove((DBObject)object);
            for (DBObject item : items) {
                String id = null;
                Object data = null;
                if (item == null) continue;
                byte[] idBytes = (byte[])item.get(ID);
                byte[] dataBytes = (byte[])item.get(DATA);
                if (data == null) continue;
                try {
                    ObjectInputStream ois = null;
                    ois = new ObjectInputStream(new ByteArrayInputStream(idBytes));
                    try {
                        id = (String)ois.readObject();
                    }
                    finally {
                        ois.close();
                    }
                    ois = new ObjectInputStream(new ByteArrayInputStream(dataBytes));
                    try {
                        data = ois.readObject();
                        ois.close();
                    }
                    finally {
                        ois.close();
                    }
                    if (id == null) continue;
                    this.fireEvictedEvent(id, data);
                }
                catch (IOException e) {
                    LOG.error("Error evicting object from store", (Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    LOG.error("Error evicting object from store", (Throwable)e);
                }
            }
        }
    }
}

