/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.validation;

import java.io.IOException;
import javax.jbi.JBIException;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.common.util.MessageUtil;
import org.apache.servicemix.jbi.exception.FaultException;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.servicemix.validation.ValidationEndpointType;
import org.apache.servicemix.validation.handler.CountingErrorHandlerFactory;
import org.apache.servicemix.validation.handler.MessageAwareErrorHandler;
import org.apache.servicemix.validation.handler.MessageAwareErrorHandlerFactory;
import org.springframework.core.io.Resource;
import org.xml.sax.SAXException;

public class ValidationEndpoint
extends ProviderEndpoint
implements ValidationEndpointType {
    public static final String FAULT_FLOW = "FAULT_FLOW";
    public static final String FAULT_JBI = "FAULT_JBI";
    public static final String TAG_RESULT_START = "<result>";
    public static final String TAG_RESULT_END = "</result>";
    public static final String TAG_WARNING_START = "<warning>";
    public static final String TAG_WARNING_END = "</warning>";
    public static final String TAG_ERROR_START = "<error>";
    public static final String TAG_ERROR_END = "</error>";
    public static final String TAG_FATAL_START = "<fatalError>";
    public static final String TAG_FATAL_END = "</fatalError>";
    private String handlingErrorMethod = "FAULT_JBI";
    private Schema schema;
    private String schemaLanguage = "http://www.w3.org/2001/XMLSchema";
    private Source schemaSource;
    private Resource schemaResource;
    private Resource noNamespaceSchemaResource;
    private MessageAwareErrorHandlerFactory errorHandlerFactory = new CountingErrorHandlerFactory();
    private SourceTransformer sourceTransformer = new SourceTransformer();

    public void start() throws Exception {
        super.start();
        try {
            if (this.schema == null) {
                SchemaFactory factory = SchemaFactory.newInstance(this.schemaLanguage);
                if (this.schemaSource == null) {
                    if (this.schemaResource == null) {
                        if (this.noNamespaceSchemaResource == null) {
                            throw new JBIException("You must specify schema, schemaSource, schemaResource or noNamespaceSchemaResource property.");
                        }
                        this.schema = factory.newSchema();
                    } else {
                        this.schemaSource = this.schemaResource.getURL() == null ? new StreamSource(this.schemaResource.getInputStream()) : new StreamSource(this.schemaResource.getInputStream(), this.schemaResource.getURL().toExternalForm());
                        this.schema = factory.newSchema(this.schemaSource);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new JBIException("Failed to load schema: " + e, (Throwable)e);
        }
        catch (SAXException e) {
            throw new JBIException("Failed to load schema: " + e, (Throwable)e);
        }
    }

    public void stop() throws Exception {
        super.stop();
    }

    protected void processInOnly(MessageExchange exchange, NormalizedMessage in) throws Exception {
        NormalizedMessage out = exchange.createMessage();
        Fault fault = exchange.createFault();
        this.startValidation(exchange, in, out, fault);
        if (fault.getContent() != null) {
            throw new RuntimeException(this.sourceTransformer.contentToString((NormalizedMessage)fault));
        }
    }

    protected void processInOut(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws Exception {
        Fault fault = exchange.createFault();
        this.startValidation(exchange, in, out, fault);
        if (fault.getContent() != null) {
            exchange.setFault(fault);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startValidation(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out, Fault fault) throws Exception {
        Validator validator = this.schema.newValidator();
        if (this.noNamespaceSchemaResource != null) {
            logger.info("Enabling validation for noNamespace-XML documents.");
            validator.setFeature("http://xml.org/sax/features/validation", true);
            validator.setFeature("http://apache.org/xml/features/validation/schema", true);
            validator.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", this.noNamespaceSchemaResource.getURL().toExternalForm());
        }
        MessageAwareErrorHandler errorHandler = this.errorHandlerFactory.createMessageAwareErrorHandler();
        validator.setErrorHandler(errorHandler);
        DOMResult result = new DOMResult();
        fault.setContent(null);
        try {
            DOMSource src = this.sourceTransformer.toDOMSource(in.getContent());
            this.doValidation(validator, src, result);
            if (errorHandler.hasErrors()) {
                if (errorHandler.capturesMessages()) {
                    if (errorHandler.supportsMessageFormat(DOMSource.class)) {
                        fault.setContent((Source)((DOMSource)errorHandler.getMessagesAs(DOMSource.class)));
                    } else if (errorHandler.supportsMessageFormat(StringSource.class)) {
                        fault.setContent((Source)this.sourceTransformer.toDOMSource((Source)((StringSource)errorHandler.getMessagesAs(StringSource.class))));
                    } else {
                        if (!errorHandler.supportsMessageFormat(String.class)) throw new MessagingException("MessageAwareErrorHandler implementation " + errorHandler.getClass().getName() + " does not support a compatible error message format.");
                        fault.setContent((Source)this.sourceTransformer.toDOMSource((Source)new StringSource((String)errorHandler.getMessagesAs(String.class))));
                    }
                } else {
                    StringBuffer resultString = new StringBuffer();
                    resultString.append(TAG_RESULT_START);
                    resultString.append('\n');
                    resultString.append(TAG_WARNING_START);
                    resultString.append(errorHandler.getWarningCount());
                    resultString.append(TAG_WARNING_END);
                    resultString.append('\n');
                    resultString.append(TAG_ERROR_START);
                    resultString.append(errorHandler.getErrorCount());
                    resultString.append(TAG_ERROR_END);
                    resultString.append('\n');
                    resultString.append(TAG_FATAL_START);
                    resultString.append(errorHandler.getFatalErrorCount());
                    resultString.append(TAG_FATAL_END);
                    resultString.append('\n');
                    resultString.append(TAG_RESULT_END);
                    resultString.append('\n');
                    fault.setContent((Source)new StringSource(resultString.toString()));
                }
                if (!this.handlingErrorMethod.equalsIgnoreCase(FAULT_FLOW)) {
                    throw new FaultException("Failed to validate against schema: " + this.schema, exchange, fault);
                }
                MessageUtil.transfer((NormalizedMessage)fault, (NormalizedMessage)out);
                return;
            } else {
                out.setContent((Source)new DOMSource(result.getNode(), result.getSystemId()));
            }
            return;
        }
        catch (SAXException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (IOException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new MessagingException((Throwable)e);
        }
        catch (TransformerException e) {
            throw new MessagingException((Throwable)e);
        }
    }

    protected void doValidation(Validator validator, DOMSource src, DOMResult result) throws SAXException, IOException {
        validator.validate(src, result);
    }

    protected void fail(MessageExchange messageExchange, Exception e) throws MessagingException {
        super.fail(messageExchange, e);
    }

    protected void send(MessageExchange messageExchange) throws MessagingException {
        super.send(messageExchange);
    }

    protected void sendSync(MessageExchange messageExchange) throws MessagingException {
        super.sendSync(messageExchange);
    }

    protected void done(MessageExchange messageExchange) throws MessagingException {
        super.done(messageExchange);
    }

    public String getHandlingErrorMethod() {
        return this.handlingErrorMethod;
    }

    public void setHandlingErrorMethod(String handlingErrorMethod) {
        this.handlingErrorMethod = handlingErrorMethod;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public String getSchemaLanguage() {
        return this.schemaLanguage;
    }

    public void setSchemaLanguage(String schemaLanguage) {
        this.schemaLanguage = schemaLanguage;
    }

    public Source getSchemaSource() {
        return this.schemaSource;
    }

    public void setSchemaSource(Source schemaSource) {
        this.schemaSource = schemaSource;
    }

    public Resource getSchemaResource() {
        return this.schemaResource;
    }

    public void setSchemaResource(Resource schemaResource) {
        this.schemaResource = schemaResource;
    }

    public Resource getNoNamespaceSchemaResource() {
        return this.noNamespaceSchemaResource;
    }

    public void setNoNamespaceSchemaResource(Resource schemaResource) {
        this.noNamespaceSchemaResource = schemaResource;
    }

    public MessageAwareErrorHandlerFactory getErrorHandlerFactory() {
        return this.errorHandlerFactory;
    }

    public void setErrorHandlerFactory(MessageAwareErrorHandlerFactory errorHandlerFactory) {
        this.errorHandlerFactory = errorHandlerFactory;
    }
}

