/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.repository.cluster.lock.holder;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shardingsphere.infra.util.props.TypedProperties;
import org.apache.shardingsphere.infra.util.spi.type.typed.TypedSPIRegistry;
import org.apache.shardingsphere.mode.repository.cluster.lock.DistributedLock;
import org.apache.shardingsphere.mode.repository.cluster.lock.creator.DistributedLockCreator;

public final class DistributedLockHolder {
    private final DistributedLockCreator<Object, TypedProperties<?>> creator;
    private final Object client;
    private final TypedProperties<?> props;
    private final Map<String, DistributedLock> locks;

    public DistributedLockHolder(String type, Object client, TypedProperties<?> props) {
        this.creator = (DistributedLockCreator)TypedSPIRegistry.getRegisteredService(DistributedLockCreator.class, (String)type);
        this.client = client;
        this.props = props;
        this.locks = new ConcurrentHashMap<String, DistributedLock>();
    }

    public DistributedLock getDistributedLock(String lockKey) {
        return this.locks.computeIfAbsent(lockKey, key -> this.creator.create((String)key, this.client, this.props));
    }
}

