/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.refresher.type.index;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefresher;
import org.apache.shardingsphere.infra.instance.mode.ModeContextManager;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereIndex;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.pojo.AlterSchemaMetaDataPOJO;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.AlterIndexStatementHandler;

public final class AlterIndexStatementSchemaRefresher
implements MetaDataRefresher<AlterIndexStatement> {
    @Override
    public void refresh(ModeContextManager modeContextManager, ShardingSphereDatabase database, Collection<String> logicDataSourceNames, String schemaName, AlterIndexStatement sqlStatement, ConfigurationProperties props) {
        Optional renameIndex = AlterIndexStatementHandler.getRenameIndexSegment((AlterIndexStatement)sqlStatement);
        if (!sqlStatement.getIndex().isPresent() || !renameIndex.isPresent()) {
            return;
        }
        String actualSchemaName = ((IndexSegment)sqlStatement.getIndex().get()).getOwner().map(optional -> optional.getIdentifier().getValue().toLowerCase()).orElse(schemaName);
        String indexName = ((IndexSegment)sqlStatement.getIndex().get()).getIndexName().getIdentifier().getValue();
        Optional<String> logicTableName = this.findLogicTableName(database.getSchema(actualSchemaName), indexName);
        if (logicTableName.isPresent()) {
            ShardingSphereTable table = database.getSchema(actualSchemaName).getTable(logicTableName.get());
            Preconditions.checkNotNull((Object)table, (String)"Can not get the table '%s' meta data!", (Object)logicTableName.get());
            ShardingSphereTable newTable = this.newShardingSphereTable(table);
            newTable.getIndexes().remove(indexName);
            String renameIndexName = ((IndexSegment)renameIndex.get()).getIndexName().getIdentifier().getValue();
            newTable.getIndexes().put(renameIndexName, new ShardingSphereIndex(renameIndexName));
            AlterSchemaMetaDataPOJO alterSchemaMetaDataPOJO = new AlterSchemaMetaDataPOJO(database.getName(), actualSchemaName);
            alterSchemaMetaDataPOJO.getAlteredTables().add(newTable);
            modeContextManager.alterSchemaMetaData(alterSchemaMetaDataPOJO);
        }
    }

    private Optional<String> findLogicTableName(ShardingSphereSchema schema, String indexName) {
        return schema.getAllTableNames().stream().filter(each -> schema.getTable(each).getIndexes().containsKey(indexName)).findFirst();
    }

    private ShardingSphereTable newShardingSphereTable(ShardingSphereTable table) {
        ShardingSphereTable result = new ShardingSphereTable(table.getName(), new LinkedHashMap(table.getColumns()), new LinkedHashMap(table.getIndexes()), new LinkedHashMap(table.getConstrains()));
        result.getColumnNames().addAll(table.getColumnNames());
        result.getVisibleColumns().addAll(table.getVisibleColumns());
        result.getPrimaryKeyColumns().addAll(table.getPrimaryKeyColumns());
        return result;
    }

    public String getType() {
        return AlterIndexStatement.class.getName();
    }
}

