/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.context.refresher.type.index;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.context.refresher.MetaDataRefresher;
import org.apache.shardingsphere.infra.instance.mode.ModeContextManager;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereIndex;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.pojo.AlterSchemaMetaDataPOJO;
import org.apache.shardingsphere.infra.metadata.database.schema.util.IndexMetaDataUtil;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateIndexStatement;

public final class CreateIndexStatementSchemaRefresher
implements MetaDataRefresher<CreateIndexStatement> {
    @Override
    public void refresh(ModeContextManager modeContextManager, ShardingSphereDatabase database, Collection<String> logicDataSourceNames, String schemaName, CreateIndexStatement sqlStatement, ConfigurationProperties props) {
        String indexName;
        String string = indexName = null != sqlStatement.getIndex() ? sqlStatement.getIndex().getIndexName().getIdentifier().getValue() : IndexMetaDataUtil.getGeneratedLogicIndexName((Collection)sqlStatement.getColumns());
        if (Strings.isNullOrEmpty((String)indexName)) {
            return;
        }
        String tableName = sqlStatement.getTable().getTableName().getIdentifier().getValue();
        ShardingSphereTable table = this.newShardingSphereTable(database.getSchema(schemaName).getTable(tableName));
        table.getIndexes().put(indexName, new ShardingSphereIndex(indexName));
        AlterSchemaMetaDataPOJO alterSchemaMetaDataPOJO = new AlterSchemaMetaDataPOJO(database.getName(), schemaName);
        alterSchemaMetaDataPOJO.getAlteredTables().add(table);
        modeContextManager.alterSchemaMetaData(alterSchemaMetaDataPOJO);
    }

    private ShardingSphereTable newShardingSphereTable(ShardingSphereTable table) {
        ShardingSphereTable result = new ShardingSphereTable(table.getName(), new LinkedHashMap(table.getColumns()), new LinkedHashMap(table.getIndexes()), new LinkedHashMap(table.getConstrains()));
        result.getColumnNames().addAll(table.getColumnNames());
        result.getVisibleColumns().addAll(table.getVisibleColumns());
        result.getPrimaryKeyColumns().addAll(table.getPrimaryKeyColumns());
        return result;
    }

    public String getType() {
        return CreateIndexStatement.class.getName();
    }
}

