/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.util.Buffer;

public class ChannelPipedInputStream
extends InputStream {
    private final Window localWindow;
    private final Buffer buffer = new Buffer();
    private final byte[] b = new byte[1];
    private boolean closed;
    private boolean eofSent;
    private final Lock lock = new ReentrantLock();
    private final Condition dataAvailable = this.lock.newCondition();
    private int timeout = 0;
    private boolean writerClosed;

    public ChannelPipedInputStream(Window localWindow) {
        this.localWindow = localWindow;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        int avail;
        block3: {
            this.lock.lock();
            try {
                avail = this.buffer.available();
                if (avail != 0 || !this.writerClosed) break block3;
                int n = -1;
                Object var4_4 = null;
                this.lock.unlock();
                return n;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.lock.unlock();
                throw throwable;
            }
        }
        int n = avail;
        Object var4_5 = null;
        this.lock.unlock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        byte[] byArray = this.b;
        synchronized (this.b) {
            int l = this.read(this.b, 0, 1);
            if (l == -1) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return -1;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.b[0] & 0xFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(byte[] b, int off, int len) throws IOException {
        int avail;
        long startTime = System.currentTimeMillis();
        this.lock.lock();
        try {
            block12: {
                while (true) {
                    if (this.closed && this.writerClosed && this.eofSent || this.closed && !this.writerClosed) {
                        throw new IOException("Pipe closed");
                    }
                    if (this.buffer.available() > 0) {
                        if (len > this.buffer.available()) {
                            break;
                        }
                        break block12;
                    }
                    if (this.writerClosed) {
                        this.eofSent = true;
                        int n = -1;
                        Object var10_8 = null;
                        this.lock.unlock();
                        return n;
                    }
                    try {
                        if (this.timeout > 0) {
                            long remaining = (long)this.timeout - (System.currentTimeMillis() - startTime);
                            if (remaining <= 0L) {
                                throw new SocketException("timeout");
                            }
                            this.dataAvailable.await(remaining, TimeUnit.MILLISECONDS);
                            continue;
                        }
                        this.dataAvailable.await();
                    }
                    catch (InterruptedException e) {
                        throw (IOException)new InterruptedIOException().initCause(e);
                    }
                }
                len = this.buffer.available();
            }
            this.buffer.getRawBytes(b, off, len);
            if (this.buffer.rpos() > this.localWindow.getPacketSize() || this.buffer.available() == 0) {
                this.buffer.compact();
            }
            avail = this.localWindow.getMaxSize() - this.buffer.available();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.lock.unlock();
            throw throwable;
        }
        Object var10_9 = null;
        this.lock.unlock();
        this.localWindow.check(avail);
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eof() {
        this.lock.lock();
        try {
            this.writerClosed = true;
            this.dataAvailable.signalAll();
            Object var2_1 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.lock.lock();
        try {
            this.closed = true;
            this.dataAvailable.signalAll();
            Object var2_1 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(byte[] bytes, int off, int len) throws IOException {
        this.lock.lock();
        try {
            if (this.writerClosed || this.closed) {
                throw new IOException("Pipe closed");
            }
            this.buffer.putRawBytes(bytes, off, len);
            this.dataAvailable.signalAll();
            Object var5_4 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.lock.unlock();
            throw throwable;
        }
        this.localWindow.consume(len);
    }
}

