/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.reply;

import org.apache.sshd.sftp.reply.BaseReply;
import org.apache.sshd.sftp.subsystem.SftpConstants;

public class SshFxpDataReply
extends BaseReply {
    private final byte[] data;
    private final int offset;
    private final int length;
    private final boolean eof;

    public SshFxpDataReply(int id, byte[] data) {
        this(id, data, 0, data.length, false);
    }

    public SshFxpDataReply(int id, byte[] data, int offset, int length, boolean eof) {
        super(id);
        this.data = data;
        this.offset = offset;
        this.length = length;
        this.eof = eof;
    }

    public SftpConstants.Type getMessage() {
        return SftpConstants.Type.SSH_FXP_DATA;
    }

    public String toString() {
        return this.getName() + "[data=<data(len=" + this.length + ")>, eof=" + this.eof + "]";
    }

    public byte[] getData() {
        return this.data;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isEof() {
        return this.eof;
    }
}

