/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.subsystem;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.sshd.common.file.SshFile;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.sftp.Handle;
import org.apache.sshd.sftp.Reply;
import org.apache.sshd.sftp.Request;
import org.apache.sshd.sftp.SftpSession;
import org.apache.sshd.sftp.reply.FileAttributes;
import org.apache.sshd.sftp.reply.SshFxpAttrsReply;
import org.apache.sshd.sftp.reply.SshFxpDataReply;
import org.apache.sshd.sftp.reply.SshFxpHandleReply;
import org.apache.sshd.sftp.reply.SshFxpNameReply;
import org.apache.sshd.sftp.reply.SshFxpStatusReply;
import org.apache.sshd.sftp.reply.SshFxpVersionReply;
import org.apache.sshd.sftp.request.BaseRequest;
import org.apache.sshd.sftp.request.SshFxpCloseRequest;
import org.apache.sshd.sftp.request.SshFxpFsetstatRequest;
import org.apache.sshd.sftp.request.SshFxpFstatRequest;
import org.apache.sshd.sftp.request.SshFxpInitRequest;
import org.apache.sshd.sftp.request.SshFxpLstatRequest;
import org.apache.sshd.sftp.request.SshFxpMkdirRequest;
import org.apache.sshd.sftp.request.SshFxpOpenRequest;
import org.apache.sshd.sftp.request.SshFxpOpendirRequest;
import org.apache.sshd.sftp.request.SshFxpReadRequest;
import org.apache.sshd.sftp.request.SshFxpReaddirRequest;
import org.apache.sshd.sftp.request.SshFxpRealpathRequest;
import org.apache.sshd.sftp.request.SshFxpRemoveRequest;
import org.apache.sshd.sftp.request.SshFxpRenameRequest;
import org.apache.sshd.sftp.request.SshFxpRmdirRequest;
import org.apache.sshd.sftp.request.SshFxpSetstatRequest;
import org.apache.sshd.sftp.request.SshFxpStatRequest;
import org.apache.sshd.sftp.request.SshFxpWriteRequest;
import org.apache.sshd.sftp.request.UnsupportedRequest;
import org.apache.sshd.sftp.subsystem.SftpConstants;

public class Serializer {
    private final SftpSession session;

    public Serializer(SftpSession session) {
        this.session = session;
    }

    protected Request readRequest(Buffer buffer) {
        BaseRequest request;
        int length = buffer.getInt();
        byte type = buffer.getByte();
        int id = buffer.getInt();
        switch (type) {
            case 1: {
                if (length != 5) {
                    throw new IllegalArgumentException();
                }
                request = new SshFxpInitRequest(id);
                break;
            }
            case 3: {
                String path = buffer.getString();
                int acc = this.session.getVersion() > 4 ? buffer.getInt() : 0;
                int flags = buffer.getInt();
                request = new SshFxpOpenRequest(id, path, acc, flags);
                break;
            }
            case 4: {
                String handleId = buffer.getString();
                Handle handle = this.session.getHandle(handleId);
                request = new SshFxpCloseRequest(id, handleId, handle);
                break;
            }
            case 5: {
                String handleId = buffer.getString();
                long offset = buffer.getLong();
                int len = buffer.getInt();
                Handle handle = this.session.getHandle(handleId);
                request = new SshFxpReadRequest(id, handleId, offset, len, handle);
                break;
            }
            case 6: {
                String handleId = buffer.getString();
                long offset = buffer.getLong();
                byte[] data = buffer.getBytes();
                Handle handle = this.session.getHandle(handleId);
                request = new SshFxpWriteRequest(id, handleId, offset, data, handle);
                break;
            }
            case 7: {
                String path = buffer.getString();
                int flags = 0;
                if (this.session.getVersion() > 5) {
                    flags = buffer.getInt();
                }
                request = new SshFxpLstatRequest(id, path, flags);
                break;
            }
            case 8: {
                String handle = buffer.getString();
                int flags = 0;
                if (this.session.getVersion() > 5) {
                    flags = buffer.getInt();
                }
                Handle p = this.session.getHandle(handle);
                request = new SshFxpFstatRequest(id, handle, p);
                break;
            }
            case 9: {
                request = new SshFxpSetstatRequest(id);
                break;
            }
            case 10: {
                request = new SshFxpFsetstatRequest(id);
                break;
            }
            case 11: {
                String path = buffer.getString();
                request = new SshFxpOpendirRequest(id, path);
                break;
            }
            case 12: {
                String handle = buffer.getString();
                Handle p = this.session.getHandle(handle);
                request = new SshFxpReaddirRequest(id, handle, p);
                break;
            }
            case 13: {
                String path = buffer.getString();
                request = new SshFxpRemoveRequest(id, path);
                break;
            }
            case 14: {
                String path = buffer.getString();
                request = new SshFxpMkdirRequest(id, path);
                break;
            }
            case 15: {
                String path = buffer.getString();
                request = new SshFxpRmdirRequest(id, path);
                break;
            }
            case 16: {
                String path = buffer.getString();
                byte options = 1;
                ArrayList<String> compose = new ArrayList<String>();
                if (this.session.getVersion() >= 6 && buffer.available() > 0) {
                    options = buffer.getByte();
                }
                while (this.session.getVersion() >= 6 && buffer.available() > 0) {
                    compose.add(buffer.getString());
                }
                request = new SshFxpRealpathRequest(id, path, options, compose);
                break;
            }
            case 17: {
                String path = buffer.getString();
                int flags = 0;
                if (this.session.getVersion() > 5) {
                    flags = buffer.getInt();
                }
                request = new SshFxpStatRequest(id, path, flags);
                break;
            }
            case 18: {
                String oldPath = buffer.getString();
                String newPath = buffer.getString();
                request = new SshFxpRenameRequest(id, oldPath, newPath);
                break;
            }
            case 19: {
                request = new UnsupportedRequest(id, SftpConstants.Type.SSH_FXP_READLINK.toByte());
                break;
            }
            case 21: {
                request = new UnsupportedRequest(id, SftpConstants.Type.SSH_FXP_LINK.toByte());
                break;
            }
            case 22: {
                request = new UnsupportedRequest(id, SftpConstants.Type.SSH_FXP_BLOCK.toByte());
                break;
            }
            case 23: {
                request = new UnsupportedRequest(id, SftpConstants.Type.SSH_FXP_UNBLOCK.toByte());
                break;
            }
            default: {
                request = new UnsupportedRequest(id, type);
            }
        }
        return request;
    }

    public Buffer writeReply(Reply reply) throws IOException {
        if (reply == null) {
            throw new IllegalStateException("Can not serialize a null reply");
        }
        if (reply instanceof SshFxpAttrsReply) {
            return this.writeAttrsReply((SshFxpAttrsReply)reply);
        }
        if (reply instanceof SshFxpDataReply) {
            return this.writeDataReply((SshFxpDataReply)reply);
        }
        if (reply instanceof SshFxpHandleReply) {
            return this.writeHandleReply((SshFxpHandleReply)reply);
        }
        if (reply instanceof SshFxpNameReply) {
            return this.writeNameReply((SshFxpNameReply)reply);
        }
        if (reply instanceof SshFxpStatusReply) {
            return this.writeStatus((SshFxpStatusReply)reply);
        }
        if (reply instanceof SshFxpVersionReply) {
            return this.writeVersionReply((SshFxpVersionReply)reply);
        }
        throw new IllegalStateException("Unsupported reply: " + reply.toString());
    }

    private Buffer writeAttrsReply(SshFxpAttrsReply reply) throws IOException {
        int id = reply.getId();
        FileAttributes attrs = reply.getAttributes();
        Buffer buffer = new Buffer();
        buffer.putByte((byte)105);
        buffer.putInt((long)id);
        this.writeAttrs(buffer, attrs);
        return buffer;
    }

    private Buffer writeVersionReply(SshFxpVersionReply reply) {
        int version = reply.getVersion();
        Buffer buffer = new Buffer();
        buffer.putByte((byte)2);
        buffer.putInt((long)version);
        return buffer;
    }

    private Buffer writeNameReply(SshFxpNameReply reply) {
        int id = reply.getId();
        Collection<SshFxpNameReply.ReplyFile> files = reply.getFiles();
        Buffer buffer = new Buffer();
        buffer.putByte((byte)104);
        buffer.putInt((long)id);
        buffer.putInt((long)files.size());
        for (SshFxpNameReply.ReplyFile f : files) {
            buffer.putString(f.getFileName());
            if (this.session.getVersion() <= 3) {
                buffer.putString(f.getLongName());
            }
            this.writeAttrs(buffer, f.getAttrs());
        }
        if (this.session.getVersion() >= 6 && reply.isEol()) {
            buffer.putBoolean(true);
        }
        return buffer;
    }

    private Buffer writeHandleReply(SshFxpHandleReply reply) throws IOException {
        int id = reply.getId();
        String handle = reply.getHandle().getId();
        Buffer buffer = new Buffer();
        buffer.putByte((byte)102);
        buffer.putInt((long)id);
        buffer.putString(handle);
        return buffer;
    }

    private Buffer writeDataReply(SshFxpDataReply reply) {
        long id = reply.getId();
        byte[] data = reply.getData();
        int offset = reply.getOffset();
        int length = reply.getLength();
        boolean eof = reply.isEof();
        Buffer buffer = new Buffer(length + 5);
        buffer.putByte((byte)103);
        buffer.putInt(id);
        buffer.putBytes(data, offset, length);
        if (this.session.getVersion() >= 6 && eof) {
            buffer.putBoolean(eof);
        }
        return buffer;
    }

    private Buffer writeStatus(SshFxpStatusReply reply) throws IOException {
        int id = reply.getId();
        int substatus = reply.getSubstatus();
        String msg = reply.getMsg();
        String lang = reply.getLang();
        Buffer buffer = new Buffer();
        buffer.putByte((byte)101);
        buffer.putInt((long)id);
        buffer.putInt((long)this.mapToVersion(substatus));
        buffer.putString(msg);
        buffer.putString(lang);
        return buffer;
    }

    protected static int mapV4ToV3(int code) {
        switch (code) {
            case 9: {
                return 4;
            }
            case 10: {
                return 2;
            }
            case 11: {
                return 4;
            }
            case 12: {
                return 3;
            }
            case 13: {
                return 4;
            }
        }
        return code;
    }

    protected static int mapV5ToV4(int code) {
        switch (code) {
            case 14: {
                return 4;
            }
            case 15: {
                return 4;
            }
            case 16: {
                return 4;
            }
            case 17: {
                return 4;
            }
        }
        return code;
    }

    protected static int mapV6ToV5(int code) {
        switch (code) {
            case 18: {
                return 4;
            }
            case 19: {
                return 2;
            }
            case 20: {
                return 2;
            }
            case 21: {
                return 4;
            }
            case 22: {
                return 3;
            }
            case 23: {
                return 4;
            }
            case 24: {
                return 2;
            }
            case 25: {
                return 4;
            }
            case 26: {
                return 4;
            }
            case 27: {
                return 4;
            }
            case 28: {
                return 4;
            }
            case 29: {
                return 3;
            }
            case 30: {
                return 3;
            }
            case 31: {
                return 4;
            }
        }
        return code;
    }

    protected static int mapToVersion(int code, int version) {
        int mappedCode = code;
        if (version < 6) {
            mappedCode = Serializer.mapV6ToV5(mappedCode);
        }
        if (version < 5) {
            mappedCode = Serializer.mapV5ToV4(mappedCode);
        }
        if (version < 4) {
            mappedCode = Serializer.mapV4ToV3(mappedCode);
        }
        return mappedCode;
    }

    protected int mapToVersion(int code) {
        return Serializer.mapToVersion(code, this.session.getVersion());
    }

    protected void writeAttrs(Buffer buffer, FileAttributes attrs) {
        int version = this.session.getVersion();
        int flags = attrs.getFlags();
        buffer.putInt((long)flags);
        if (this.session.getVersion() >= 4) {
            buffer.putByte(attrs.getType());
        }
        if ((flags & 1) != 0) {
            buffer.putLong(attrs.getSize());
        }
        if (version >= 6 && (flags & 0x400) != 0) {
            buffer.putLong(attrs.getAllocationSize());
        }
        if ((flags & 0x80) != 0) {
            buffer.putString(attrs.getOwner());
            buffer.putString(attrs.getGroup());
        }
        if ((flags & 4) != 0) {
            int perms = attrs.getPermissions();
            if (this.session.getVersion() < 4) {
                if (attrs.getType() == 1) {
                    perms |= 0x8000;
                } else if (attrs.getType() == 2) {
                    perms |= 0x4000;
                }
            }
            buffer.putInt((long)perms);
        }
        if (version <= 3 && (flags & 8) != 0) {
            buffer.putInt(attrs.getAccessTime());
            buffer.putInt(attrs.getAccessTime());
        }
    }

    protected void writeAttrs(Buffer buffer, SshFile file, int flags) {
        if (this.session.getVersion() >= 4) {
            long size = file.getSize();
            String username = this.session.getSession().getUsername();
            long lastModif = file.getLastModified();
            int p = 0;
            if (file.isReadable()) {
                p |= 0x100;
            }
            if (file.isWritable()) {
                p |= 0x80;
            }
            if (file.isExecutable()) {
                p |= 0x40;
            }
            if (file.isFile()) {
                buffer.putInt(4L);
                buffer.putByte((byte)1);
                buffer.putInt((long)p);
            } else if (file.isDirectory()) {
                buffer.putInt(4L);
                buffer.putByte((byte)2);
                buffer.putInt((long)p);
            } else {
                buffer.putInt(0L);
                buffer.putByte((byte)5);
            }
        } else {
            int p = 0;
            if (file.isFile()) {
                p |= 0x8000;
            }
            if (file.isDirectory()) {
                p |= 0x4000;
            }
            if (file.isReadable()) {
                p |= 0x100;
            }
            if (file.isWritable()) {
                p |= 0x80;
            }
            if (file.isExecutable()) {
                p |= 0x40;
            }
            if (file.isFile()) {
                buffer.putInt(13L);
                buffer.putLong(file.getSize());
                buffer.putInt((long)p);
                buffer.putInt(file.getLastModified() / 1000L);
                buffer.putInt(file.getLastModified() / 1000L);
            } else if (file.isDirectory()) {
                buffer.putInt(12L);
                buffer.putInt((long)p);
                buffer.putInt(file.getLastModified() / 1000L);
                buffer.putInt(file.getLastModified() / 1000L);
            } else {
                buffer.putInt(0L);
            }
        }
    }
}

