/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.subsystem;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.Session;
import org.apache.sshd.common.file.FileSystemAware;
import org.apache.sshd.common.file.FileSystemView;
import org.apache.sshd.common.file.SshFile;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.SelectorUtils;
import org.apache.sshd.server.ChannelSessionAware;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.SessionAware;
import org.apache.sshd.server.channel.ChannelDataReceiver;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.sftp.Handle;
import org.apache.sshd.sftp.Reply;
import org.apache.sshd.sftp.Request;
import org.apache.sshd.sftp.SftpSession;
import org.apache.sshd.sftp.Sftplet;
import org.apache.sshd.sftp.reply.FileAttributes;
import org.apache.sshd.sftp.reply.SshFxpAttrsReply;
import org.apache.sshd.sftp.reply.SshFxpDataReply;
import org.apache.sshd.sftp.reply.SshFxpHandleReply;
import org.apache.sshd.sftp.reply.SshFxpNameReply;
import org.apache.sshd.sftp.reply.SshFxpStatusReply;
import org.apache.sshd.sftp.reply.SshFxpVersionReply;
import org.apache.sshd.sftp.request.SshFxpCloseRequest;
import org.apache.sshd.sftp.request.SshFxpFsetstatRequest;
import org.apache.sshd.sftp.request.SshFxpFstatRequest;
import org.apache.sshd.sftp.request.SshFxpInitRequest;
import org.apache.sshd.sftp.request.SshFxpLstatRequest;
import org.apache.sshd.sftp.request.SshFxpMkdirRequest;
import org.apache.sshd.sftp.request.SshFxpOpenRequest;
import org.apache.sshd.sftp.request.SshFxpOpendirRequest;
import org.apache.sshd.sftp.request.SshFxpReadRequest;
import org.apache.sshd.sftp.request.SshFxpReaddirRequest;
import org.apache.sshd.sftp.request.SshFxpRealpathRequest;
import org.apache.sshd.sftp.request.SshFxpRemoveRequest;
import org.apache.sshd.sftp.request.SshFxpRenameRequest;
import org.apache.sshd.sftp.request.SshFxpRmdirRequest;
import org.apache.sshd.sftp.request.SshFxpSetstatRequest;
import org.apache.sshd.sftp.request.SshFxpStatRequest;
import org.apache.sshd.sftp.request.SshFxpWriteRequest;
import org.apache.sshd.sftp.subsystem.DefaultSftpletContainer;
import org.apache.sshd.sftp.subsystem.DirectoryHandle;
import org.apache.sshd.sftp.subsystem.FileHandle;
import org.apache.sshd.sftp.subsystem.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SftpSubsystem
implements Command,
SessionAware,
FileSystemAware,
SftpSession,
ChannelDataReceiver,
ChannelSessionAware {
    protected static final Logger LOG = LoggerFactory.getLogger(SftpSubsystem.class);
    public static final int LOWER_SFTP_IMPL = 3;
    public static final int HIGHER_SFTP_IMPL = 6;
    public static final String ALL_SFTP_IMPL = "3,4,5,6";
    public static final int MAX_PACKET_LENGTH = 16384;
    public static final String MAX_OPEN_HANDLES_PER_SESSION = "max-open-handles-per-session";
    private ExitCallback callback;
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private Environment env;
    private ServerSession session;
    private ChannelSession channel;
    private boolean closed = false;
    private FileSystemView root;
    private int version;
    private Map<String, Handle> handles = new HashMap<String, Handle>();
    private Sftplet sftpLet = new DefaultSftpletContainer();
    private Serializer serializer = new Serializer(this);
    private final ExecutorService executor;
    private Buffer buffer = new Buffer();
    private static final String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    public SftpSubsystem() {
        this.executor = Executors.newSingleThreadExecutor();
    }

    public void setSftpLet(Sftplet sftpLet) {
        this.sftpLet = sftpLet;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public Handle getHandle(String id) {
        return this.handles.get(id);
    }

    @Override
    public Handle createFileHandle(SshFile file, int flags) {
        String id = UUID.randomUUID().toString();
        FileHandle handle = new FileHandle(id, file, flags);
        this.handles.put(id, handle);
        return handle;
    }

    @Override
    public Handle createDirectoryHandle(SshFile file) {
        String id = UUID.randomUUID().toString();
        DirectoryHandle handle = new DirectoryHandle(id, file);
        this.handles.put(id, handle);
        return handle;
    }

    public void setChannelSession(ChannelSession channel) {
        this.channel = channel;
        channel.setDataReceiver((ChannelDataReceiver)this);
    }

    public void setSession(ServerSession session) {
        this.sftpLet.onConnect(this);
        this.session = session;
    }

    public void setFileSystemView(FileSystemView view) {
        this.root = view;
    }

    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    public void start(Environment env) throws IOException {
        this.env = env;
    }

    public int data(ChannelSession channel, byte[] buf, int start, int len) throws IOException {
        Buffer incoming = new Buffer(buf, start, len);
        if (this.buffer.available() > 0) {
            this.buffer.putBuffer((Readable)incoming);
            incoming = this.buffer;
        }
        int rpos = incoming.rpos();
        while (this.receive(incoming)) {
        }
        int read = incoming.rpos() - rpos;
        this.buffer.compact();
        if (this.buffer != incoming && incoming.available() > 0) {
            this.buffer.putBuffer((Readable)incoming);
        }
        return read;
    }

    protected boolean receive(Buffer incoming) throws IOException {
        int rpos = incoming.rpos();
        int wpos = incoming.wpos();
        if (wpos - rpos > 4) {
            int length = incoming.getInt();
            if (length < 5) {
                throw new IOException("Illegal sftp packet length: " + length);
            }
            if (wpos - rpos >= length + 4) {
                incoming.rpos(rpos);
                incoming.wpos(rpos + 4 + length);
                this.process(incoming);
                incoming.rpos(rpos + 4 + length);
                incoming.wpos(wpos);
                return true;
            }
        }
        incoming.rpos(rpos);
        return false;
    }

    public void close() throws IOException {
        this.executor.shutdownNow();
        if (this.handles != null) {
            for (Map.Entry<String, Handle> entry : this.handles.entrySet()) {
                Handle handle = entry.getValue();
                try {
                    handle.close();
                }
                catch (IOException ioe) {
                    LOG.error("Could not close open handle: " + entry.getKey(), (Throwable)ioe);
                }
            }
        }
        this.callback.onExit(0);
        this.sftpLet.onDisconnect(this);
    }

    public void process(Buffer buffer) throws IOException {
        final Request request = this.serializer.readRequest(buffer);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received sftp request: " + request);
        }
        this.executor.execute(new Runnable(){

            public void run() {
                try {
                    Reply reply = SftpSubsystem.this.sftpLet.beforeCommand(SftpSubsystem.this, request);
                    if (reply == null) {
                        reply = SftpSubsystem.this.doProcess(request);
                    }
                    if ((reply = SftpSubsystem.this.sftpLet.afterCommand(SftpSubsystem.this, request, reply)) != null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Sending sftp reply: " + reply);
                        }
                        Buffer buffer = SftpSubsystem.this.serializer.writeReply(reply);
                        SftpSubsystem.this.send(buffer);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
    }

    protected Reply doProcess(Request request) throws IOException {
        try {
            if (request instanceof SshFxpInitRequest) {
                return this.doProcessInit((SshFxpInitRequest)request);
            }
            if (request instanceof SshFxpOpenRequest) {
                return this.doProcessOpen((SshFxpOpenRequest)request);
            }
            if (request instanceof SshFxpCloseRequest) {
                return this.doProcessClose((SshFxpCloseRequest)request);
            }
            if (request instanceof SshFxpReadRequest) {
                return this.doProcessRead((SshFxpReadRequest)request);
            }
            if (request instanceof SshFxpWriteRequest) {
                return this.doProcessWrite((SshFxpWriteRequest)request);
            }
            if (request instanceof SshFxpLstatRequest || request instanceof SshFxpStatRequest) {
                return this.doProcessStat(request);
            }
            if (request instanceof SshFxpFstatRequest) {
                return this.doProcessFstat((SshFxpFstatRequest)request);
            }
            if (request instanceof SshFxpOpendirRequest) {
                return this.doProcessOpendir((SshFxpOpendirRequest)request);
            }
            if (request instanceof SshFxpReaddirRequest) {
                return this.doProcessReaddir((SshFxpReaddirRequest)request);
            }
            if (request instanceof SshFxpRemoveRequest) {
                return this.doProcessRemove((SshFxpRemoveRequest)request);
            }
            if (request instanceof SshFxpMkdirRequest) {
                return this.doProcessMkdir((SshFxpMkdirRequest)request);
            }
            if (request instanceof SshFxpRmdirRequest) {
                return this.doProcessRmdir((SshFxpRmdirRequest)request);
            }
            if (request instanceof SshFxpRealpathRequest) {
                return this.doProcessRealpath((SshFxpRealpathRequest)request);
            }
            if (request instanceof SshFxpRenameRequest) {
                return this.doProcessRename((SshFxpRenameRequest)request);
            }
            if (request instanceof SshFxpSetstatRequest || request instanceof SshFxpFsetstatRequest) {
                return this.doProcessSetstat(request);
            }
            LOG.error("Received: {}", (Object)request);
            int id = request.getId();
            return new SshFxpStatusReply(id, 8, "Command " + request + " is unsupported or not implemented");
        }
        catch (IOException e) {
            int id = request.getId();
            return new SshFxpStatusReply(id, 4, e.getMessage());
        }
    }

    private Reply doProcessSetstat(Request request) throws IOException {
        int id = request.getId();
        return new SshFxpStatusReply(id, 0, "");
    }

    private Reply doProcessRename(SshFxpRenameRequest request) throws IOException {
        int id = request.getId();
        String oldPath = request.getOldPath();
        String newPath = request.getNewPath();
        SshFile o = this.resolveFile(oldPath);
        SshFile n = this.resolveFile(newPath);
        if (!o.doesExist()) {
            return new SshFxpStatusReply(id, 2, o.getAbsolutePath());
        }
        if (n.doesExist()) {
            return new SshFxpStatusReply(id, 11, n.getAbsolutePath());
        }
        if (!o.move(n)) {
            return new SshFxpStatusReply(id, 4, "Failed to rename file");
        }
        return new SshFxpStatusReply(id, 0, "");
    }

    private Reply doProcessRealpath(SshFxpRealpathRequest request) throws IOException {
        boolean exists;
        int id = request.getId();
        String path = request.getPath();
        if (path.trim().length() == 0) {
            path = ".";
        }
        SshFile p = this.resolveFile(path);
        for (String s : request.getCompose()) {
            p = this.root.getFile(p, s);
        }
        String normalizedPath = SelectorUtils.normalizePath((String)p.getAbsolutePath(), (String)"/");
        if (normalizedPath.length() == 0) {
            normalizedPath = "/";
        }
        if ((p = this.resolveFile(normalizedPath)).getName().length() == 0) {
            p = this.resolveFile(".");
        }
        boolean bl = exists = request.getOptions() != 1 && p.doesExist();
        if (!exists && request.getOptions() == 3) {
            return new SshFxpStatusReply(id, 2, p.getAbsolutePath());
        }
        if (exists && (request.getOptions() == 2 || request.getOptions() == 3)) {
            SshFxpNameReply reply = new SshFxpNameReply(id);
            int flags = 5;
            reply.addFile(p, normalizedPath, this.getLongName(p), new FileAttributes(p, flags));
            return reply;
        }
        SshFxpNameReply reply = new SshFxpNameReply(id);
        reply.addFile(p, normalizedPath, this.getLongName(p), new FileAttributes());
        return reply;
    }

    private Reply doProcessRmdir(SshFxpRmdirRequest request) throws IOException {
        int id = request.getId();
        String path = request.getPath();
        SshFile p = this.resolveFile(path);
        if (p.isDirectory()) {
            if (p.doesExist()) {
                if (p.listSshFiles().size() == 0) {
                    if (p.delete()) {
                        return new SshFxpStatusReply(id, 0, "");
                    }
                    return new SshFxpStatusReply(id, 4, "Unable to delete directory " + path);
                }
                return new SshFxpStatusReply(id, 18, path);
            }
            return new SshFxpStatusReply(id, 10, path);
        }
        return new SshFxpStatusReply(id, 19, p.getAbsolutePath());
    }

    private Reply doProcessMkdir(SshFxpMkdirRequest request) throws IOException {
        int id = request.getId();
        String path = request.getPath();
        SshFile p = this.resolveFile(path);
        if (p.doesExist()) {
            if (p.isDirectory()) {
                return new SshFxpStatusReply(id, 11, p.getAbsolutePath());
            }
            return new SshFxpStatusReply(id, 19, p.getAbsolutePath());
        }
        if (!p.isWritable()) {
            return new SshFxpStatusReply(id, 3, p.getAbsolutePath());
        }
        if (!p.mkdir()) {
            return new SshFxpStatusReply(id, 4, "Error creating dir " + path);
        }
        return new SshFxpStatusReply(id, 0, "");
    }

    private Reply doProcessRemove(SshFxpRemoveRequest request) throws IOException {
        int id = request.getId();
        String path = request.getPath();
        SshFile p = this.resolveFile(path);
        if (!p.doesExist()) {
            return new SshFxpStatusReply(id, 2, p.getAbsolutePath());
        }
        if (p.isDirectory()) {
            return new SshFxpStatusReply(id, 24, p.getAbsolutePath());
        }
        if (!p.delete()) {
            return new SshFxpStatusReply(id, 4, "Failed to delete file");
        }
        return new SshFxpStatusReply(id, 0, "");
    }

    private Reply doProcessReaddir(SshFxpReaddirRequest request) throws IOException {
        int id = request.getId();
        String handle = request.getHandleId();
        Handle p = this.getHandle(handle);
        if (!(p instanceof DirectoryHandle)) {
            return new SshFxpStatusReply(id, 9, handle);
        }
        if (((DirectoryHandle)p).isDone()) {
            return new SshFxpStatusReply(id, 1, "", "");
        }
        if (!p.getFile().doesExist()) {
            return new SshFxpStatusReply(id, 2, p.getFile().getAbsolutePath());
        }
        if (!p.getFile().isDirectory()) {
            return new SshFxpStatusReply(id, 19, p.getFile().getAbsolutePath());
        }
        if (!p.getFile().isReadable()) {
            return new SshFxpStatusReply(id, 3, p.getFile().getAbsolutePath());
        }
        DirectoryHandle dh = (DirectoryHandle)p;
        if (dh.hasNext()) {
            SshFxpNameReply reply = this.sendName(id, dh);
            if (!dh.hasNext()) {
                dh.setDone(true);
                dh.clearFileList();
            }
            return reply;
        }
        dh.setDone(true);
        dh.clearFileList();
        return new SshFxpStatusReply(id, 1, "", "");
    }

    private Reply doProcessOpendir(SshFxpOpendirRequest request) throws IOException {
        int id = request.getId();
        String path = request.getPath();
        SshFile p = this.resolveFile(path);
        if (!p.doesExist()) {
            return new SshFxpStatusReply(id, 2, path);
        }
        if (!p.isDirectory()) {
            return new SshFxpStatusReply(id, 19, path);
        }
        if (!p.isReadable()) {
            return new SshFxpStatusReply(id, 3, path);
        }
        Handle handle = this.createDirectoryHandle(p);
        return new SshFxpHandleReply(id, handle);
    }

    private Reply doProcessFstat(SshFxpFstatRequest request) throws IOException {
        int id = request.getId();
        String handle = request.getHandleId();
        Handle p = this.getHandle(handle);
        if (p == null) {
            return new SshFxpStatusReply(id, 9, handle);
        }
        int flags = 5;
        return new SshFxpAttrsReply(id, new FileAttributes(p.getFile(), flags));
    }

    private Reply doProcessStat(Request sftpRequest) throws IOException {
        String path;
        int id = sftpRequest.getId();
        if (sftpRequest instanceof SshFxpLstatRequest) {
            SshFxpLstatRequest sshFxpLstatRequest = (SshFxpLstatRequest)sftpRequest;
            path = sshFxpLstatRequest.getPath();
        } else {
            SshFxpStatRequest sshFxpStatRequest = (SshFxpStatRequest)sftpRequest;
            path = sshFxpStatRequest.getPath();
        }
        SshFile p = this.resolveFile(path);
        if (!p.doesExist()) {
            return new SshFxpStatusReply(id, 2, p.getAbsolutePath());
        }
        int flags = 5;
        return new SshFxpAttrsReply(id, new FileAttributes(p, flags));
    }

    private Reply doProcessWrite(SshFxpWriteRequest request) throws IOException {
        int id = request.getId();
        String handle = request.getHandleId();
        long offset = request.getOffset();
        byte[] data = request.getData();
        Handle p = this.getHandle(handle);
        if (!(p instanceof FileHandle)) {
            return new SshFxpStatusReply(id, 9, handle);
        }
        FileHandle fh = (FileHandle)p;
        fh.write(data, offset);
        SshFile sshFile = fh.getFile();
        sshFile.setLastModified(new Date().getTime());
        return new SshFxpStatusReply(id, 0, "");
    }

    private Reply doProcessRead(SshFxpReadRequest request) throws IOException {
        int id = request.getId();
        String handle = request.getHandleId();
        long offset = request.getOffset();
        int len = request.getLength();
        Handle p = this.getHandle(handle);
        if (!(p instanceof FileHandle)) {
            return new SshFxpStatusReply(id, 9, handle);
        }
        FileHandle fh = (FileHandle)p;
        byte[] b = new byte[len];
        if ((len = fh.read(b, offset)) >= 0) {
            return new SshFxpDataReply(id, b, 0, len, len < b.length);
        }
        return new SshFxpStatusReply(id, 1, "");
    }

    private Reply doProcessClose(SshFxpCloseRequest sftpRequest) throws IOException {
        int id = sftpRequest.getId();
        SshFxpCloseRequest sshFxpCloseRequest = sftpRequest;
        String handle = sshFxpCloseRequest.getHandleId();
        Handle h = this.getHandle(handle);
        if (h == null) {
            return new SshFxpStatusReply(id, 9, handle, "");
        }
        this.handles.remove(handle);
        h.close();
        return new SshFxpStatusReply(id, 0, "", "");
    }

    private Reply doProcessOpen(SshFxpOpenRequest request) throws IOException {
        int accValue;
        String maxHandlesString;
        int id = request.getId();
        if (this.session.getFactoryManager().getProperties() != null && (maxHandlesString = (String)this.session.getFactoryManager().getProperties().get(MAX_OPEN_HANDLES_PER_SESSION)) != null) {
            int maxHandleCount = Integer.parseInt(maxHandlesString);
            if (this.handles.size() > maxHandleCount) {
                return new SshFxpStatusReply(id, 4, "Too many open handles");
            }
        }
        if ((accValue = request.getAcc()) == 0) {
            String path = request.getPath();
            int flags = request.getFlags();
            SshFile file = this.resolveFile(path);
            if (file.doesExist()) {
                if ((flags & 8) != 0 && (flags & 0x20) != 0) {
                    return new SshFxpStatusReply(id, 11, path);
                }
            } else if ((flags & 8) != 0) {
                if (!file.isWritable()) {
                    return new SshFxpStatusReply(id, 3, "Can not create " + path);
                }
                file.create();
            }
            if ((flags & 0x10) != 0) {
                file.truncate();
            }
            return new SshFxpHandleReply(id, this.createFileHandle(file, flags));
        }
        String path = request.getPath();
        int acc = accValue;
        int flags = request.getFlags();
        SshFile file = this.resolveFile(path);
        switch (flags & 7) {
            case 0: {
                if (file.doesExist()) {
                    return new SshFxpStatusReply(id, 11, path);
                }
                if (!file.isWritable()) {
                    return new SshFxpStatusReply(id, 3, "Can not create " + path);
                }
                file.create();
                break;
            }
            case 1: {
                if (file.doesExist()) {
                    return new SshFxpStatusReply(id, 11, path);
                }
                if (!file.isWritable()) {
                    return new SshFxpStatusReply(id, 3, "Can not create " + path);
                }
                file.truncate();
                break;
            }
            case 2: {
                if (file.doesExist()) break;
                if (!file.getParentFile().doesExist()) {
                    return new SshFxpStatusReply(id, 10, path);
                }
                return new SshFxpStatusReply(id, 2, path);
            }
            case 3: {
                if (file.doesExist()) break;
                file.create();
                break;
            }
            case 4: {
                if (!file.doesExist()) {
                    if (!file.getParentFile().doesExist()) {
                        return new SshFxpStatusReply(id, 10, path);
                    }
                    return new SshFxpStatusReply(id, 2, path);
                }
                file.truncate();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported open mode: " + flags);
            }
        }
        return new SshFxpHandleReply(id, this.createFileHandle(file, flags));
    }

    private Reply doProcessInit(SshFxpInitRequest request) throws IOException {
        int id;
        this.version = id = request.getId();
        if (this.version >= 3) {
            this.version = Math.min(this.version, 6);
            return new SshFxpVersionReply(this.version);
        }
        return new SshFxpStatusReply(id, 8, "SFTP server only support versions 3,4,5,6");
    }

    protected SshFxpNameReply sendName(int id, Iterator<SshFile> files) throws IOException {
        SshFxpNameReply reply = new SshFxpNameReply(id);
        for (int nb = 0; files.hasNext() && nb < 8192; nb += 10) {
            SshFile f = files.next();
            String filename = f.getName();
            nb = this.version <= 3 ? (nb += 55 + filename.length() * 2) : (nb += filename.length());
            int flags = 13;
            reply.addFile(f, filename, this.getLongName(f), new FileAttributes(f, flags));
        }
        reply.setEol(!files.hasNext());
        return reply;
    }

    protected void send(Buffer buffer) throws IOException {
        DataOutputStream dos = new DataOutputStream(this.out);
        dos.writeInt(buffer.available());
        dos.write(buffer.array(), buffer.rpos(), buffer.available());
        dos.flush();
    }

    public void destroy() {
        this.closed = true;
    }

    private SshFile resolveFile(String path) {
        return this.root.getFile(path);
    }

    private String getLongName(SshFile f) {
        String username = f.getOwner();
        if (username.length() > 8) {
            username = username.substring(0, 8);
        } else {
            for (int i = username.length(); i < 8; ++i) {
                username = username + " ";
            }
        }
        long length = f.getSize();
        String lengthString = String.format("%1$8s", length);
        StringBuilder sb = new StringBuilder();
        sb.append(f.isDirectory() ? "d" : "-");
        sb.append(f.isReadable() ? "r" : "-");
        sb.append(f.isWritable() ? "w" : "-");
        sb.append(f.isExecutable() ? "x" : "-");
        sb.append(f.isReadable() ? "r" : "-");
        sb.append(f.isWritable() ? "w" : "-");
        sb.append(f.isExecutable() ? "x" : "-");
        sb.append(f.isReadable() ? "r" : "-");
        sb.append(f.isWritable() ? "w" : "-");
        sb.append(f.isExecutable() ? "x" : "-");
        sb.append(" ");
        sb.append("  1");
        sb.append(" ");
        sb.append(username);
        sb.append(" ");
        sb.append(username);
        sb.append(" ");
        sb.append(lengthString);
        sb.append(" ");
        sb.append(SftpSubsystem.getUnixDate(f.getLastModified()));
        sb.append(" ");
        sb.append(f.getName());
        return sb.toString();
    }

    private static final String getUnixDate(long millis) {
        if (millis < 0L) {
            return "------------";
        }
        StringBuffer sb = new StringBuffer(16);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(millis);
        sb.append(MONTHS[cal.get(2)]);
        sb.append(' ');
        int day = cal.get(5);
        if (day < 10) {
            sb.append(' ');
        }
        sb.append(day);
        sb.append(' ');
        long sixMonth = 15811200000L;
        long nowTime = System.currentTimeMillis();
        if (Math.abs(nowTime - millis) > sixMonth) {
            int year = cal.get(1);
            sb.append(' ');
            sb.append(year);
        } else {
            int hh = cal.get(11);
            if (hh < 10) {
                sb.append('0');
            }
            sb.append(hh);
            sb.append(':');
            int mm = cal.get(12);
            if (mm < 10) {
                sb.append('0');
            }
            sb.append(mm);
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements NamedFactory<Command> {
        public Command create() {
            return new SftpSubsystem();
        }

        public String getName() {
            return "sftp";
        }
    }
}

