/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.algeron.configuration;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class Reflection {
    public static <T> T newInstance(Class<T> implClass, Class<?>[] argumentTypes, Object[] arguments) {
        T obj;
        if (implClass == null) {
            throw new IllegalArgumentException("ImplClass must be specified");
        }
        if (argumentTypes == null) {
            throw new IllegalArgumentException("ArgumentTypes must be specified. Use empty array if no arguments");
        }
        if (arguments == null) {
            throw new IllegalArgumentException("Arguments must be specified. Use empty array if no arguments");
        }
        try {
            final Constructor<T> constructor = Reflection.getConstructor(implClass, argumentTypes);
            if (!constructor.isAccessible()) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        constructor.setAccessible(true);
                        return null;
                    }
                });
            }
            obj = constructor.newInstance(arguments);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create new instance of " + implClass, e);
        }
        return obj;
    }

    static <T> Constructor<T> getConstructor(final Class<T> clazz, final Class<?> ... argumentTypes) throws NoSuchMethodException {
        try {
            return (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor<T>>(){

                @Override
                public Constructor<T> run() throws NoSuchMethodException {
                    return clazz.getDeclaredConstructor(argumentTypes);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable t = pae.getCause();
            if (t instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)t;
            }
            try {
                throw (RuntimeException)t;
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Obtained unchecked Exception; this code should never be reached", t);
            }
        }
    }
}

