/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.algeron.pact.consumer.publisher.git;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.arquillian.algeron.configuration.HomeResolver;
import org.arquillian.algeron.configuration.RunnerExpressionParser;
import org.arquillian.algeron.consumer.spi.publisher.ContractsPublisher;
import org.arquillian.algeron.git.GitOperations;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullResult;

public class GitContractsPublisher
implements ContractsPublisher {
    static final String URL = "url";
    static final String USERNAME = "username";
    static final String PASSWORD = "password";
    static final String PASSPHRASE = "passphrase";
    static final String REMOTE = "remote";
    static final String KEY = "key";
    static final String REPOSITORY = "repository";
    static final String CONTRACT_GIT_DIRECTORY = "contractGitDirectory";
    static final String TAG = "tag";
    static final String BRANCH = "branch";
    static final String COMMENT = "comment";
    static final String EMAIL = "email";
    static final String CONTRACTS_FOLDER = "contractsFolder";
    private static final Logger logger = Logger.getLogger(GitContractsPublisher.class.getName());
    private Map<String, Object> configuration;
    GitOperations gitOperations = new GitOperations();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish() throws IOException {
        try (Git git = null;){
            git = this.getGitRepositoryWithLatestRemoteChanges(git);
            logger.log(Level.INFO, String.format("Git repository with contract files at %s.", git.getRepository().getDirectory().getParentFile().getAbsolutePath()));
            Path outputLocation = this.moveToCorrectLocation(git);
            String contractFolder = (String)this.configuration.get(CONTRACTS_FOLDER);
            Path contractsSource = Paths.get(RunnerExpressionParser.parseExpressions((String)contractFolder), new String[0]);
            List<Path> contractFiles = this.copyContractFiles(contractsSource, outputLocation);
            this.executeCommitAndPush(git);
            logger.log(Level.INFO, String.format("Contract files %s pushed to %s repository.", contractFiles.stream().map(path -> path.getFileName().toString()).collect(Collectors.joining(System.lineSeparator(), "[", "]")), this.configuration.get(URL)));
        }
    }

    protected Git getGitRepositoryWithLatestRemoteChanges(Git git) throws IOException {
        if (this.isSet(REPOSITORY, String.class, this.configuration)) {
            Path repository = Paths.get(this.getResolvedValue((String)this.configuration.get(REPOSITORY)), new String[0]);
            if (this.gitOperations.isValidGitRepository(repository)) {
                git = this.useLocalGitRepository(repository);
            } else {
                logger.log(Level.INFO, String.format("%s directory is not a git directory or does not exists and it is going to be deleted and cloned", repository));
                Files.deleteIfExists(repository);
                Files.createDirectories(repository, new FileAttribute[0]);
                git = this.executeClone(repository);
            }
        } else {
            Path testGitRepository = Files.createTempDirectory("TestGitRepository", new FileAttribute[0]);
            logger.info(String.format("Repository is going to be cloned at %s", testGitRepository));
            git = this.executeClone(testGitRepository);
        }
        return git;
    }

    protected Git useLocalGitRepository(Path repository) throws IOException {
        Git git = this.gitOperations.openGitRepository(repository);
        if (this.gitOperations.hasAtLeastOneReference(git.getRepository())) {
            PullResult pullResult = this.executePull(git);
            if (!pullResult.isSuccessful()) {
                throw new IllegalArgumentException("There are merge conflicts into an existing git repo. Provider should not deal with merge conflicts. Correct them or delete the repo and execute again the test.");
            }
        } else {
            throw new IllegalArgumentException(String.format("Git repository %s was not cloned correctly.", git.getRepository().getDirectory().getAbsolutePath()));
        }
        return git;
    }

    private void executeCommitAndPush(Git git) {
        this.executeCommit(git);
        this.executeTag(git);
        this.executePush(git);
    }

    private void executeTag(Git git) {
        if (this.isSet(TAG, String.class, this.configuration)) {
            this.gitOperations.createTag(git, this.getResolvedValue((String)this.configuration.get(TAG)));
        }
    }

    private void executePush(Git git) {
        if (this.isSet(USERNAME, String.class, this.configuration) && this.isSet(PASSWORD, String.class, this.configuration)) {
            this.gitOperations.pushToRepository(git, this.getResolvedValue((String)this.configuration.get(REMOTE)), this.getResolvedValue((String)this.configuration.get(USERNAME)), this.getResolvedValue((String)this.configuration.get(PASSWORD)));
        } else if (this.isSet(PASSPHRASE, String.class, this.configuration)) {
            this.gitOperations.pushToRepository(git, this.getResolvedValue((String)this.configuration.get(REMOTE)), this.getResolvedValue((String)this.configuration.get(PASSPHRASE)), this.getPrivateKey());
        } else {
            this.gitOperations.pushToRepository(git, this.getResolvedValue((String)this.configuration.get(REMOTE)));
        }
    }

    private void executeCommit(Git git) {
        if (this.isSet(USERNAME, String.class, this.configuration) && this.isSet(EMAIL, String.class, this.configuration)) {
            this.gitOperations.addAndCommit(git, this.getResolvedValue((String)this.configuration.get(COMMENT)), this.getResolvedValue((String)this.configuration.get(USERNAME)), this.getResolvedValue((String)this.configuration.get(EMAIL)));
        } else {
            this.gitOperations.addAndCommit(git, this.getResolvedValue((String)this.configuration.get(COMMENT)));
        }
    }

    private List<Path> copyContractFiles(Path contractsLocation, Path outputPath) throws IOException {
        ArrayList<Path> contractFiles = new ArrayList<Path>();
        try (Stream<Path> stream = Files.walk(contractsLocation, new FileVisitOption[0]);){
            stream.filter(path -> !Files.isDirectory(path, new LinkOption[0])).peek(path -> contractFiles.add((Path)path)).forEach(path -> {
                try {
                    Path contractFile = outputPath.resolve(path.getFileName());
                    Files.copy(path, contractFile, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            });
        }
        return contractFiles;
    }

    private Git executeClone(Path repository) {
        Git git = this.isSet(USERNAME, String.class, this.configuration) && this.isSet(PASSWORD, String.class, this.configuration) ? this.gitOperations.cloneRepository(this.getResolvedValue((String)this.configuration.get(URL)), repository, this.getResolvedValue((String)this.configuration.get(USERNAME)), this.getResolvedValue((String)this.configuration.get(PASSWORD))) : (this.isSet(PASSPHRASE, String.class, this.configuration) ? this.gitOperations.cloneRepository(this.getResolvedValue((String)this.configuration.get(URL)), repository, this.getResolvedValue((String)this.configuration.get(PASSPHRASE)), this.getPrivateKey()) : this.gitOperations.cloneRepository(this.getResolvedValue((String)this.configuration.get(URL)), repository));
        return git;
    }

    private PullResult executePull(Git git) {
        PullResult pullResult = this.isSet(USERNAME, String.class, this.configuration) && this.isSet(PASSWORD, String.class, this.configuration) ? this.gitOperations.pullFromRepository(git, this.getResolvedValue((String)this.configuration.get(REMOTE)), this.getResolvedValue((String)this.configuration.get(BRANCH)), this.getResolvedValue((String)this.configuration.get(USERNAME)), this.getResolvedValue((String)this.configuration.get(PASSWORD))) : (this.isSet(PASSPHRASE, String.class, this.configuration) ? this.gitOperations.pullFromRepository(git, this.getResolvedValue((String)this.configuration.get(REMOTE)), this.getResolvedValue((String)this.configuration.get(BRANCH)), this.getResolvedValue((String)this.configuration.get(PASSPHRASE)), this.getPrivateKey()) : this.gitOperations.pullFromRepository(git, this.getResolvedValue((String)this.configuration.get(REMOTE)), this.getResolvedValue((String)this.configuration.get(BRANCH))));
        return pullResult;
    }

    private Path moveToCorrectLocation(Git git) {
        File directory = git.getRepository().getDirectory().getParentFile();
        String branch = this.getResolvedValue((String)this.configuration.get(BRANCH));
        if (this.gitOperations.isLocalBranch(git, branch)) {
            this.gitOperations.checkoutBranch(git, branch);
        } else {
            String remoteBranch = this.getResolvedValue((String)this.configuration.get(REMOTE));
            if (this.gitOperations.isRemoteBranch(git, branch, remoteBranch)) {
                this.gitOperations.checkoutBranch(git, branch, remoteBranch);
            } else {
                this.gitOperations.createBranchAndCheckout(git, branch);
            }
        }
        if (this.isSet(CONTRACT_GIT_DIRECTORY, String.class, this.configuration)) {
            return Paths.get(directory.getAbsolutePath(), this.getResolvedValue((String)this.configuration.get(CONTRACT_GIT_DIRECTORY)));
        }
        return Paths.get(directory.getAbsolutePath(), new String[0]);
    }

    private Path getPrivateKey() {
        if (this.isSet(KEY, String.class, this.configuration)) {
            return Paths.get(this.getResolvedValue(HomeResolver.resolveHomeDirectory((String)((String)this.configuration.get(KEY)))), new String[0]);
        }
        return null;
    }

    public String getName() {
        return "git";
    }

    public void configure(Map<String, Object> configuration) {
        this.configuration = configuration;
        if (!this.configuration.containsKey(URL)) {
            throw new IllegalArgumentException(String.format("To use Git Publisher you need to set %s of the repository", URL));
        }
        if (!(this.configuration.get(URL) instanceof String)) {
            throw new IllegalArgumentException(String.format("Git Publisher requires %s configuration property to be an String instead of %s", URL, this.configuration.get(URL)));
        }
        if (!this.configuration.containsKey(COMMENT)) {
            throw new IllegalArgumentException(String.format("To use Git Publisher you need to set %s of the repository", COMMENT));
        }
        if (!(this.configuration.get(COMMENT) instanceof String)) {
            throw new IllegalArgumentException(String.format("Git Publisher requires %s configuration property to be an String instead of %s", COMMENT, this.configuration.get(COMMENT)));
        }
        if (!this.configuration.containsKey(CONTRACTS_FOLDER)) {
            throw new IllegalArgumentException(String.format("Git Publisher requires %s configuration property", CONTRACTS_FOLDER));
        }
        if (!(this.configuration.get(CONTRACTS_FOLDER) instanceof String)) {
            throw new IllegalArgumentException(String.format("Git Publisher requires %s configuration property to be an String", CONTRACTS_FOLDER));
        }
        this.setDefaults();
    }

    private void setDefaults() {
        if (this.isNotSet(REMOTE, this.configuration)) {
            this.configuration.put(REMOTE, "origin");
        }
        if (this.isNotSet(KEY, this.configuration)) {
            this.configuration.put(KEY, System.getProperty("user.home") + "/.ssh/id_rsa");
        }
        if (this.isNotSet(BRANCH, this.configuration)) {
            this.configuration.put(BRANCH, "master");
        }
    }

    private boolean isNotSet(String field, Map<String, Object> configuration) {
        return !configuration.containsKey(field);
    }

    private boolean isSet(String field, Class<?> expectedType, Map<String, Object> configuration) {
        return configuration.containsKey(field) && expectedType.isAssignableFrom(configuration.get(field).getClass());
    }

    private String getResolvedValue(String field) {
        return RunnerExpressionParser.parseExpressions((String)field);
    }
}

