/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.algeron.pact.provider.loader.git;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.arquillian.algeron.configuration.HomeResolver;
import org.arquillian.algeron.configuration.RunnerExpressionParser;
import org.arquillian.algeron.git.GitOperations;
import org.arquillian.algeron.pact.provider.loader.git.ContractsGit;
import org.arquillian.algeron.provider.spi.retriever.ContractsRetriever;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullResult;

public class ContractsGitLoader
implements ContractsRetriever {
    private static final Logger logger = Logger.getLogger(ContractsGitLoader.class.getName());
    private ContractsGit contractsGit;
    GitOperations gitOperations;

    public ContractsGitLoader() {
    }

    public ContractsGitLoader(ContractsGit contractsGit) {
        this.contractsGit = contractsGit;
        this.gitOperations = new GitOperations();
    }

    public List<URI> retrieve() throws IOException {
        Path contractsFolderFromGitRepo = this.getContractsFolderFromGitRepo();
        return Arrays.stream(contractsFolderFromGitRepo.toFile().listFiles()).map(file -> "file://" + file.getAbsolutePath()).map(URI::create).collect(Collectors.toList());
    }

    public String getName() {
        return "git";
    }

    public void configure(Map<String, Object> configuration) {
        this.contractsGit = new ExternallyConfiguredContractsGit(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Path getContractsFolderFromGitRepo() throws IOException {
        Path location = null;
        try (Git git = null;){
            if (this.isSet(this.contractsGit.repository())) {
                Path repository = Paths.get(this.getResolvedValue(this.contractsGit.repository()), new String[0]);
                if (this.gitOperations.isValidGitRepository(repository)) {
                    git = this.gitOperations.openGitRepository(repository);
                    if (!this.gitOperations.hasAtLeastOneReference(git.getRepository())) throw new IllegalArgumentException(String.format("Git repository %s was not cloned correctly.", git.getRepository().getDirectory().getAbsolutePath()));
                    PullResult pullResult = this.executePull(git);
                    if (!pullResult.isSuccessful()) throw new IllegalArgumentException("There are merge conflicts into an existing git repo. Provider should not deal with merge conflicts. Correct them or delete the repo and execute again the test.");
                    location = this.moveToCorrectLocation(git);
                    return location;
                } else {
                    logger.log(Level.INFO, String.format("%s directory is not a git directory or does not exists and it is going to be deleted and cloned", repository));
                    Files.deleteIfExists(repository);
                    Files.createDirectories(repository, new FileAttribute[0]);
                    git = this.executeClone(repository);
                    location = this.moveToCorrectLocation(git);
                }
                return location;
            } else {
                Path testGitRepository = Files.createTempDirectory("TestGitRepository", new FileAttribute[0]);
                logger.log(Level.INFO, String.format("Repository is going to be cloned at %s", testGitRepository));
                git = this.executeClone(testGitRepository);
                location = this.moveToCorrectLocation(git);
            }
            return location;
        }
    }

    private Path moveToCorrectLocation(Git git) {
        File directory = git.getRepository().getDirectory().getParentFile();
        if (this.isSet(this.contractsGit.tag())) {
            this.gitOperations.checkoutTag(git, this.getResolvedValue(this.contractsGit.tag()));
        } else {
            String branch = this.getResolvedValue(this.contractsGit.branch());
            if (this.gitOperations.isLocalBranch(git, branch)) {
                this.gitOperations.checkoutBranch(git, branch);
            } else {
                this.gitOperations.checkoutBranch(git, branch, this.getResolvedValue(this.contractsGit.remote()));
            }
        }
        if (this.isSet(this.contractsGit.contractsDirectory())) {
            return Paths.get(directory.getAbsolutePath(), this.getResolvedValue(this.contractsGit.contractsDirectory()));
        }
        return Paths.get(directory.getAbsolutePath(), new String[0]);
    }

    private Git executeClone(Path repository) {
        Git git = this.isSet(this.contractsGit.username()) && this.isSet(this.contractsGit.password()) ? this.gitOperations.cloneRepository(this.getResolvedValue(this.contractsGit.value()), repository, this.getResolvedValue(this.contractsGit.username()), this.getResolvedValue(this.contractsGit.password())) : (this.isSet(this.contractsGit.passphrase()) ? this.gitOperations.cloneRepository(this.getResolvedValue(this.contractsGit.value()), repository, this.getResolvedValue(this.contractsGit.passphrase()), this.getPrivateKey()) : this.gitOperations.cloneRepository(this.getResolvedValue(this.contractsGit.value()), repository));
        return git;
    }

    private PullResult executePull(Git git) {
        PullResult pullResult = this.isSet(this.contractsGit.username()) && this.isSet(this.contractsGit.password()) ? this.gitOperations.pullFromRepository(git, this.getResolvedValue(this.contractsGit.remote()), this.getResolvedValue(this.contractsGit.branch()), this.getResolvedValue(this.contractsGit.username()), this.getResolvedValue(this.contractsGit.password())) : (this.isSet(this.contractsGit.passphrase()) ? this.gitOperations.pullFromRepository(git, this.getResolvedValue(this.contractsGit.remote()), this.getResolvedValue(this.contractsGit.branch()), this.getResolvedValue(this.contractsGit.passphrase()), this.getPrivateKey()) : this.gitOperations.pullFromRepository(git, this.getResolvedValue(this.contractsGit.remote()), this.getResolvedValue(this.contractsGit.branch())));
        return pullResult;
    }

    private Path getPrivateKey() {
        if (this.isSet(this.contractsGit.key())) {
            return Paths.get(this.getResolvedValue(HomeResolver.resolveHomeDirectory((String)this.contractsGit.key())), new String[0]);
        }
        return null;
    }

    private boolean isSet(String field) {
        return !"".equals(field);
    }

    private String getResolvedValue(String field) {
        return RunnerExpressionParser.parseExpressions((String)field);
    }

    static class ExternallyConfiguredContractsGit
    implements ContractsGit {
        private static final String URL = "url";
        private static final String USERNAME = "username";
        private static final String PASSWORD = "password";
        private static final String PASSPHRASE = "passphrase";
        private static final String REMOTE = "remote";
        private static final String KEY = "key";
        private static final String REPOSITORY = "repository";
        private static final String CONTRACT_GIT_DIRECTORY = "contractGitDirectory";
        private static final String TAG = "tag";
        private static final String BRANCH = "branch";
        private String url = "";
        private String username = "";
        private String password = "";
        private String passphrase = "";
        private String key = "";
        private String repository = "";
        private String contractsDirectory = "";
        private String tag = "";
        private String branch = "";
        private String remote = "";

        public ExternallyConfiguredContractsGit(Map<String, Object> configuration) {
            if (configuration.containsKey(URL)) {
                this.url = (String)configuration.get(URL);
            }
            if (configuration.containsKey(USERNAME)) {
                this.username = (String)configuration.get(USERNAME);
            }
            if (configuration.containsKey(PASSWORD)) {
                this.password = (String)configuration.get(PASSWORD);
            }
            if (configuration.containsKey(PASSPHRASE)) {
                this.passphrase = (String)configuration.get(PASSPHRASE);
            }
            if (configuration.containsKey(KEY)) {
                this.key = (String)configuration.get(KEY);
            }
            if (configuration.containsKey(REPOSITORY)) {
                this.repository = (String)configuration.get(REPOSITORY);
            }
            if (configuration.containsKey(CONTRACT_GIT_DIRECTORY)) {
                this.contractsDirectory = (String)configuration.get(CONTRACT_GIT_DIRECTORY);
            }
            if (configuration.containsKey(TAG)) {
                this.tag = (String)configuration.get(TAG);
            }
            if (configuration.containsKey(BRANCH)) {
                this.branch = (String)configuration.get(BRANCH);
            }
            if (configuration.containsKey(REMOTE)) {
                this.remote = (String)configuration.get(REMOTE);
            }
        }

        @Override
        public String value() {
            return this.url;
        }

        @Override
        public String username() {
            return this.username;
        }

        @Override
        public String password() {
            return this.password;
        }

        @Override
        public String passphrase() {
            return this.passphrase;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public String repository() {
            return this.repository;
        }

        @Override
        public String contractsDirectory() {
            return this.contractsDirectory;
        }

        @Override
        public String tag() {
            return this.tag;
        }

        @Override
        public String branch() {
            return this.branch;
        }

        @Override
        public String remote() {
            return this.remote;
        }

        @Override
        public boolean equals(Object obj) {
            return false;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public String toString() {
            return null;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return ContractsGit.class;
        }
    }
}

