/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.algeron.pact.provider.loader.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.arquillian.algeron.configuration.RunnerExpressionParser;
import org.arquillian.algeron.pact.provider.loader.maven.ContractsMavenDependency;
import org.arquillian.algeron.provider.spi.retriever.ContractsRetriever;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.resolver.api.maven.ConfigurableMavenResolverSystem;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenVersionRangeResult;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;

public class ContractsMavenDependencyLoader
implements ContractsRetriever {
    private static final int NAME = 0;
    private static final int URL = 1;
    private static final int LAYOUT = 2;
    private ContractsMavenDependency contractsMavenDependency;

    public ContractsMavenDependencyLoader() {
    }

    public ContractsMavenDependencyLoader(ContractsMavenDependency contractsMavenDependency) {
        this.contractsMavenDependency = contractsMavenDependency;
    }

    public List<URI> retrieve() throws IOException {
        File contractsFolder = this.createTemporaryFolder("MavenContracts");
        this.extractContracts(contractsFolder);
        return Arrays.stream(contractsFolder.listFiles()).map(file -> "file://" + file.getAbsolutePath()).map(URI::create).collect(Collectors.toList());
    }

    public void configure(Map<String, Object> configuration) {
        this.contractsMavenDependency = new ExternallyConfiguredContractsMavenDependency(configuration);
    }

    public String getName() {
        return "maven";
    }

    private void extractContracts(File temporaryDirectory) throws IOException {
        List<JavaArchive> resolvedContracts = this.resolveContracts();
        this.unpack(temporaryDirectory, resolvedContracts);
    }

    protected void unpack(File destination, List<JavaArchive> contracts) throws IOException {
        for (JavaArchive contract : contracts) {
            this.unpack(destination, contract);
        }
    }

    private void unpack(File destination, JavaArchive file) throws IOException {
        Node rootDir = file.get("/");
        Set contractFiles = rootDir.getChildren();
        for (Node contractFile : contractFiles) {
            String filename = contractFile.getPath().get().substring(1);
            Asset asset = contractFile.getAsset();
            InputStream in = asset.openStream();
            Throwable throwable = null;
            try {
                Files.copy(in, new File(destination, filename).toPath(), new CopyOption[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                in.close();
            }
        }
    }

    protected List<JavaArchive> resolveContracts() {
        String[] coordinates;
        ArrayList<JavaArchive> contracts = new ArrayList<JavaArchive>();
        ConfigurableMavenResolverSystem configurableMavenResolverSystem = Maven.configureResolver();
        if (!"".equals(this.contractsMavenDependency.customSettings())) {
            configurableMavenResolverSystem.fromClassloaderResource(RunnerExpressionParser.parseExpressions((String)this.contractsMavenDependency.customSettings()));
        }
        if (this.contractsMavenDependency.offline()) {
            configurableMavenResolverSystem.workOffline();
        }
        if (!"".equals(this.contractsMavenDependency.remoteRepository())) {
            String[] remoteRepository = this.getRemoteRepository(RunnerExpressionParser.parseExpressions((String)this.contractsMavenDependency.remoteRepository()));
            configurableMavenResolverSystem.withRemoteRepo(remoteRepository[0], remoteRepository[1], remoteRepository[2]);
        }
        for (String coordinate : coordinates = this.contractsMavenDependency.value()) {
            contracts.add(this.resolve(RunnerExpressionParser.parseExpressions((String)coordinate), configurableMavenResolverSystem));
        }
        return contracts;
    }

    private JavaArchive resolve(String coordinate, ConfigurableMavenResolverSystem maven) {
        MavenCoordinate highestVersion = (MavenCoordinate)((MavenVersionRangeResult)maven.resolveVersionRange(coordinate)).getHighestVersion();
        return (JavaArchive)((MavenFormatStage)((MavenStrategyStage)maven.resolve(highestVersion.toCanonicalForm())).withoutTransitivity()).asSingle(JavaArchive.class);
    }

    private String[] getRemoteRepository(String remoteRepoDefinition) {
        String[] elements = remoteRepoDefinition.split(":");
        if (elements.length != 3) {
            throw new IllegalArgumentException(String.format("Remote Repository must follow the syntax name:url:layout instead of %s", remoteRepoDefinition));
        }
        return elements;
    }

    private File createTemporaryFolder(String provider) throws IOException {
        File createdFolder = File.createTempFile("contracts", provider);
        createdFolder.delete();
        createdFolder.mkdir();
        return createdFolder;
    }

    static class ExternallyConfiguredContractsMavenDependency
    implements ContractsMavenDependency {
        private static final String COORDINATES = "coordinates";
        private static final String OFFLINE = "offline";
        private static final String CUSTOM_SETTINGS = "customSettings";
        private static final String REMOTE_REPOSITORY = "remoteRepository";
        private List<String> coordinates = new ArrayList<String>();
        private boolean offline = false;
        private String customSettings = "";
        private String remoteRepository = "";

        public ExternallyConfiguredContractsMavenDependency(Map<String, Object> configuration) {
            if (configuration.containsKey(COORDINATES)) {
                Object coordinates = configuration.get(COORDINATES);
                if (coordinates instanceof String) {
                    this.coordinates.add((String)coordinates);
                } else if (coordinates instanceof Collection) {
                    this.coordinates.addAll((Collection)coordinates);
                }
            }
            if (configuration.containsKey(OFFLINE)) {
                this.offline = Boolean.parseBoolean((String)configuration.get(OFFLINE));
            }
            if (configuration.containsKey(CUSTOM_SETTINGS)) {
                this.customSettings = (String)configuration.get(CUSTOM_SETTINGS);
            }
            if (configuration.containsKey(REMOTE_REPOSITORY)) {
                this.remoteRepository = (String)configuration.get(REMOTE_REPOSITORY);
            }
        }

        @Override
        public String[] value() {
            return this.coordinates.toArray(new String[this.coordinates.size()]);
        }

        @Override
        public boolean offline() {
            return this.offline;
        }

        @Override
        public String customSettings() {
            return this.customSettings;
        }

        @Override
        public String remoteRepository() {
            return this.remoteRepository;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return ContractsMavenDependency.class;
        }
    }
}

