/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.arquillian.droidium.container.utils.StringUtils;

public class Command {
    private final List<String> command = new ArrayList<String>();

    public Command() {
    }

    public Command(List<String> command) throws IllegalArgumentException {
        this();
        if (command == null) {
            throw new IllegalArgumentException("command can't be a null list!");
        }
        for (String token : command) {
            this.add(token);
        }
    }

    public Command(String ... tokens) {
        this(Arrays.asList(tokens));
    }

    public Command add(String token) {
        if (token != null && !token.trim().equals("")) {
            this.command.add(token.trim());
        }
        return this;
    }

    public Command addTokenized(String stringToBeParsed) {
        return this.add(StringUtils.tokenize(stringToBeParsed));
    }

    public Command add(List<String> tokens) {
        for (String token : tokens) {
            this.add(token);
        }
        return this;
    }

    public Command remove(String token) {
        if (token == null || token.trim().equals("")) {
            return this;
        }
        while (this.command.remove(token)) {
        }
        return this;
    }

    public Command clear() {
        this.command.clear();
        return this;
    }

    public int size() {
        return this.command.size();
    }

    public List<String> getAsList() {
        return this.command;
    }

    public String[] getAsArray() {
        return this.command.toArray(new String[this.command.size()]);
    }

    public String get(int i) {
        try {
            return this.command.get(i);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    public String getLast() {
        if (this.command.isEmpty()) {
            return null;
        }
        return this.command.get(this.command.size() - 1);
    }

    public String getFirst() {
        if (this.command.isEmpty()) {
            return null;
        }
        return this.command.get(0);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.command) {
            sb.append(s);
            sb.append(" ");
        }
        return sb.toString().trim();
    }
}

