/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.impl;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.container.activity.DefaultActivityManager;
import org.arquillian.droidium.container.activity.DefaultActivityManagerProvider;
import org.arquillian.droidium.container.api.ActivityManager;
import org.arquillian.droidium.container.api.ActivityManagerProvider;
import org.arquillian.droidium.container.api.AndroidDevice;
import org.arquillian.droidium.container.api.AndroidDeviceOutputReciever;
import org.arquillian.droidium.container.api.AndroidExecutionException;
import org.arquillian.droidium.container.configuration.Validate;

public class AndroidDeviceImpl
implements AndroidDevice {
    private static final Logger log = Logger.getLogger(AndroidDeviceImpl.class.getName());
    private IDevice delegate;
    private ActivityManagerProvider activityManagerProvider;
    private int droneHostPort = 14444;
    private int droneGuestPort = 8080;

    AndroidDeviceImpl(IDevice delegate) {
        Validate.notNull(delegate, "delegate to set for Android device can not be a null object");
        this.delegate = delegate;
    }

    public void setActivityManagerProvider(ActivityManagerProvider activityManagerProvider) {
        Validate.notNull(activityManagerProvider, "Activity manager provider to set for Android device can not be a null object!");
        this.activityManagerProvider = activityManagerProvider;
        if (activityManagerProvider instanceof DefaultActivityManagerProvider) {
            activityManagerProvider.setActivityManager((ActivityManager)new DefaultActivityManager(this));
        }
    }

    public ActivityManagerProvider getActivityManagerProvider() {
        return this.activityManagerProvider;
    }

    public String getSerialNumber() {
        return this.delegate.getSerialNumber();
    }

    public String getAvdName() {
        if (this.isEmulator()) {
            String avdName = this.delegate.getAvdName();
            if (avdName == null || avdName.equals("<build>")) {
                return null;
            }
            return avdName;
        }
        return null;
    }

    public Map<String, String> getProperties() {
        return this.delegate.getProperties();
    }

    public String getProperty(String name) throws IOException, AndroidExecutionException {
        try {
            return this.delegate.getPropertyCacheOrSync(name);
        }
        catch (TimeoutException e) {
            throw new AndroidExecutionException("Unable to get property '" + name + "' value in given timeout", (Throwable)e);
        }
        catch (AdbCommandRejectedException e) {
            throw new AndroidExecutionException("Unable to get property '" + name + "' value, command was rejected", (Throwable)e);
        }
        catch (ShellCommandUnresponsiveException e) {
            throw new AndroidExecutionException("Unable to get property '" + name + "' value, shell is not responsive", (Throwable)e);
        }
    }

    public boolean isOnline() {
        return this.delegate.isOnline();
    }

    public boolean isEmulator() {
        return this.delegate.isEmulator();
    }

    public boolean isOffline() {
        return this.delegate.isOffline();
    }

    public String getConsolePort() {
        return this.isEmulator() ? this.getSerialNumber().split("-")[1] : null;
    }

    public void executeShellCommand(String command) throws AndroidExecutionException {
        final String commandString = command;
        this.executeShellCommand(command, new AndroidDeviceOutputReciever(){

            public void processNewLines(String[] lines) {
                if (log.isLoggable(Level.INFO)) {
                    for (String line : lines) {
                        log.log(Level.FINE, "Shell command {0}: {1}", new Object[]{commandString, line});
                    }
                }
            }

            public boolean isCancelled() {
                return false;
            }
        });
    }

    public void executeShellCommand(String command, AndroidDeviceOutputReciever reciever) throws AndroidExecutionException {
        try {
            this.delegate.executeShellCommand(command, (IShellOutputReceiver)new AndroidRecieverDelegate(reciever));
        }
        catch (TimeoutException e) {
            throw new AndroidExecutionException("Unable to execute command '" + command + "' within given timeout", (Throwable)e);
        }
        catch (AdbCommandRejectedException e) {
            throw new AndroidExecutionException("Unable to execute command '" + command + "', command was rejected", (Throwable)e);
        }
        catch (ShellCommandUnresponsiveException e) {
            throw new AndroidExecutionException("Unable to execute command '" + command + "', shell is not responsive", (Throwable)e);
        }
        catch (IOException e) {
            throw new AndroidExecutionException("Unable to execute command '" + command + "'", (Throwable)e);
        }
    }

    public void createPortForwarding(int localPort, int remotePort) throws AndroidExecutionException {
        try {
            this.delegate.createForward(localPort, remotePort);
        }
        catch (TimeoutException e) {
            throw new AndroidExecutionException("Unable to forward port (" + localPort + " to " + remotePort + ") within given timeout", (Throwable)e);
        }
        catch (AdbCommandRejectedException e) {
            throw new AndroidExecutionException("Unable to forward port (" + localPort + " to " + remotePort + "), command was rejected", (Throwable)e);
        }
        catch (IOException e) {
            throw new AndroidExecutionException("Unable to forward port (" + localPort + " to " + remotePort + ").", (Throwable)e);
        }
    }

    public void removePortForwarding(int localPort, int remotePort) throws AndroidExecutionException {
        try {
            this.delegate.removeForward(localPort, remotePort);
        }
        catch (TimeoutException e) {
            throw new AndroidExecutionException("Unable to remove port forwarding (" + localPort + " to " + remotePort + ") within given timeout", (Throwable)e);
        }
        catch (AdbCommandRejectedException e) {
            throw new AndroidExecutionException("Unable to remove port forwarding (" + localPort + " to " + remotePort + "), command was rejected", (Throwable)e);
        }
        catch (IOException e) {
            throw new AndroidExecutionException("Unable to remove port forwarding (" + localPort + " to " + remotePort + ").", (Throwable)e);
        }
    }

    public void installPackage(File packageFilePath, boolean reinstall, String ... extraArgs) throws AndroidExecutionException {
        Validate.isReadable(packageFilePath.getAbsoluteFile(), "File " + packageFilePath.getAbsoluteFile() + " must represent a readable APK file");
        try {
            String retval = this.delegate.installPackage(packageFilePath.getAbsolutePath(), reinstall, extraArgs);
            if (retval != null) {
                throw new AndroidExecutionException("Unable to install APK from " + packageFilePath.getAbsolutePath() + ". Command failed with status code: " + retval);
            }
        }
        catch (InstallException e) {
            throw new AndroidExecutionException("Unable to install APK from " + packageFilePath.getAbsolutePath(), (Throwable)e);
        }
    }

    public boolean isPackageInstalled(String packageName) throws AndroidExecutionException {
        try {
            String command = "pm list packages -f";
            PackageInstalledMonkey monkey = new PackageInstalledMonkey(packageName);
            this.executeShellCommand(command, monkey);
            return monkey.isInstalled();
        }
        catch (Exception e) {
            throw new AndroidExecutionException("Unable to decide if package " + packageName + " is installed or nor", (Throwable)e);
        }
    }

    public void uninstallPackage(String packageName) throws AndroidExecutionException {
        try {
            this.delegate.uninstallPackage(packageName);
        }
        catch (InstallException e) {
            throw new AndroidExecutionException("Unable to uninstall APK named " + packageName, (Throwable)e);
        }
    }

    public int getDroneHostPort() {
        return this.droneHostPort;
    }

    public int getDroneGuestPort() {
        return this.droneGuestPort;
    }

    public void setDroneHostPort(int droneHostPort) {
        this.droneHostPort = droneHostPort;
    }

    public void setDroneGuestPort(int droneGuestPort) {
        this.droneGuestPort = droneGuestPort;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%-40s %s\n", "avdName", this.getAvdName()));
        sb.append(String.format("%-40s %s\n", "consolePort", this.getConsolePort()));
        sb.append(String.format("%-40s %s\n", "serialNumber", this.getSerialNumber()));
        sb.append(String.format("%-40s %s\n", "isEmulator", this.isEmulator()));
        sb.append(String.format("%-40s %s\n", "isOffline", this.isOffline()));
        sb.append(String.format("%-40s %s\n", "isOnline", this.isOnline()));
        sb.append(String.format("%-40s %s\n", "droneHostPort", this.getDroneHostPort()));
        sb.append(String.format("%-40s %s", "droneGuestPort", this.getDroneGuestPort()));
        return sb.toString();
    }

    private static final class AndroidRecieverDelegate
    extends MultiLineReceiver {
        private AndroidDeviceOutputReciever delegate;

        public AndroidRecieverDelegate(AndroidDeviceOutputReciever delegate) {
            this.delegate = delegate;
        }

        public void processNewLines(String[] lines) {
            this.delegate.processNewLines(lines);
        }

        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }
    }

    private static class PackageInstalledMonkey
    implements AndroidDeviceOutputReciever {
        private String packageName;
        private boolean installed = false;

        public PackageInstalledMonkey(String packageName) {
            this.packageName = packageName;
        }

        public void processNewLines(String[] lines) {
            for (String line : lines) {
                if (!line.contains(this.packageName)) continue;
                this.installed = true;
                break;
            }
        }

        public boolean isCancelled() {
            return false;
        }

        public boolean isInstalled() {
            return this.installed;
        }
    }
}

