/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.impl;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.container.api.AndroidExecutionException;
import org.arquillian.droidium.container.configuration.AndroidContainerConfiguration;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.configuration.Command;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.droidium.container.execution.ProcessExecutor;
import org.arquillian.droidium.container.execution.ProcessInteractionBuilder;
import org.arquillian.droidium.container.spi.event.AndroidSDCardCreate;
import org.arquillian.droidium.container.spi.event.AndroidSDCardDelete;
import org.arquillian.droidium.container.spi.event.AndroidVirtualDeviceAvailable;
import org.arquillian.droidium.container.spi.event.AndroidVirtualDeviceCreate;
import org.arquillian.droidium.container.spi.event.AndroidVirtualDeviceDelete;
import org.arquillian.droidium.container.spi.event.AndroidVirtualDeviceDeleted;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class AndroidVirtualDeviceManager {
    private static final Logger logger = Logger.getLogger(AndroidVirtualDeviceManager.class.getName());
    @Inject
    private Instance<AndroidContainerConfiguration> configuration;
    @Inject
    private Instance<AndroidSDK> androidSDK;
    @Inject
    private Instance<ProcessExecutor> executor;
    @Inject
    private Event<AndroidVirtualDeviceAvailable> androidVirtualDeviceAvailable;
    @Inject
    private Event<AndroidVirtualDeviceDeleted> androidVirtualDeviceDeleted;
    @Inject
    private Event<AndroidSDCardDelete> androidSDCardDelete;
    @Inject
    private Event<AndroidSDCardCreate> androidSDCardCreate;

    public void deleteAndroidVirtualDevice(@Observes AndroidVirtualDeviceDelete event) {
        AndroidContainerConfiguration configuration = (AndroidContainerConfiguration)this.configuration.get();
        try {
            ProcessExecutor executor = (ProcessExecutor)this.executor.get();
            String avdName = configuration.getAvdName();
            Command command = new Command();
            command.add(((AndroidSDK)this.androidSDK.get()).getAndroidPath()).add("delete").add("avd").add("-n").add(avdName);
            executor.execute(command.getAsArray());
            logger.log(Level.INFO, "Android Virtual Device {0} deleted.", avdName);
        }
        catch (AndroidExecutionException ex) {
            logger.log(Level.WARNING, "Unable to delete Android Virtual Device " + configuration.getAvdName(), ex);
        }
        this.androidSDCardDelete.fire((Object)new AndroidSDCardDelete());
        this.androidVirtualDeviceDeleted.fire((Object)new AndroidVirtualDeviceDeleted(configuration.getAvdName()));
    }

    public void createAndroidVirtualDevice(@Observes AndroidVirtualDeviceCreate event) throws AndroidExecutionException {
        Validate.notNulls(new Object[]{this.configuration.get(), this.androidSDK.get()}, "container configuration injection or Android SDK injection is null");
        this.androidSDCardCreate.fire((Object)new AndroidSDCardCreate());
        AndroidContainerConfiguration configuration = (AndroidContainerConfiguration)this.configuration.get();
        AndroidSDK sdk = (AndroidSDK)this.androidSDK.get();
        ProcessExecutor executor = (ProcessExecutor)this.executor.get();
        try {
            Command command = new Command();
            command.add(sdk.getAndroidPath()).add("create").add("avd").add("-n").add(configuration.getAvdName()).add("-t").add("android-" + configuration.getApiLevel()).add("-b").add(configuration.getAbi()).add("-f");
            if (configuration.getSdCard() != null && new File(configuration.getSdCard()).exists()) {
                command.add("-c").add(configuration.getSdCard());
            } else {
                command.add("-c").add(configuration.getSdSize());
            }
            logger.log(Level.INFO, "Creating new avd using: {0}", command);
            ProcessInteractionBuilder interaction = new ProcessInteractionBuilder();
            interaction.replyTo("Do you wish to create a custom hardware profile \\[no\\]").with("no" + System.getProperty("line.separator"));
            executor.execute(interaction.build(), command.getAsArray());
            configuration.setAvdGenerated(true);
            this.androidVirtualDeviceAvailable.fire((Object)new AndroidVirtualDeviceAvailable(configuration.getAvdName()));
        }
        catch (AndroidExecutionException e) {
            throw new AndroidExecutionException((Throwable)e, "Unable to create a new AVD Device", new Object[0]);
        }
    }
}

