/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.sign;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arquillian.droidium.container.configuration.AndroidContainerConfiguration;
import org.arquillian.droidium.container.configuration.AndroidSDK;
import org.arquillian.droidium.container.configuration.Command;
import org.arquillian.droidium.container.configuration.Validate;
import org.arquillian.droidium.container.execution.ProcessExecutor;

public final class KeyStoreCreator {
    private static final Logger logger = Logger.getLogger(KeyStoreCreator.class.getName());
    private final AndroidSDK sdk;
    private final AndroidContainerConfiguration configuration;
    private final ProcessExecutor executor;

    public KeyStoreCreator(ProcessExecutor executor, AndroidSDK sdk, AndroidContainerConfiguration configuration) {
        Validate.notNull(configuration, "Process Executor for key store creator must not be a null object!");
        Validate.notNull(sdk, "Android sdk for key store creator can not be a null object!");
        Validate.notNull(configuration, "Droidium configuration for key store creator can not be a null object!");
        this.executor = executor;
        this.sdk = sdk;
        this.configuration = configuration;
    }

    public boolean keyStoreExists(File keyStore) {
        try {
            Validate.isReadable(keyStore, "You must provide a valid path to keystore for signing of APK files: '" + keyStore.getAbsolutePath() + ".");
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public void createKeyStore(File keyStoreToCreate) {
        Command createKeyStoreCommand = new Command();
        createKeyStoreCommand.add(this.sdk.getPathForJavaTool("keytool")).add("-genkey").add("-v").add("-keystore").add(keyStoreToCreate.getAbsolutePath()).add("-storepass").add(this.configuration.getStorepass()).add("-alias").add(this.configuration.getAlias()).add("-keypass").add(this.configuration.getKeypass()).add("-dname").add("CN=Android,O=Android,C=US").add("-storetype").add("JKS").add("-sigalg").add(this.configuration.getSigalg()).add("-keyalg").add(this.configuration.getKeyalg());
        logger.log(Level.INFO, createKeyStoreCommand.toString());
        this.executor.execute(createKeyStoreCommand.getAsArray());
    }
}

