/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.utils;

import java.util.UUID;
import org.arquillian.droidium.container.api.FileType;
import org.arquillian.droidium.container.api.IdentifierGenerator;
import org.arquillian.droidium.container.api.IdentifierGeneratorException;
import org.arquillian.droidium.container.configuration.Validate;

public class AndroidIdentifierGenerator
implements IdentifierGenerator<FileType> {
    private String sdCardSuffix = ".img";
    private static final String apkSuffix = ".apk";

    public String getIdentifier(FileType identifierType) {
        String uuid = UUID.randomUUID().toString();
        switch (identifierType) {
            case AVD: {
                return uuid;
            }
            case SD_CARD: {
                return uuid + this.sdCardSuffix;
            }
            case SD_CARD_LABEL: {
                return uuid;
            }
            case FILE: {
                return uuid;
            }
            case APK: {
                return uuid + apkSuffix;
            }
        }
        throw new IdentifierGeneratorException("Not possible to generate any identifier of type " + identifierType.name());
    }

    public AndroidIdentifierGenerator setSdCardSuffix(String suffix) {
        Validate.notNullOrEmpty(suffix, "suffix to set for SD card can not be a null object nor an empty string.");
        if (!suffix.startsWith(".")) {
            this.sdCardSuffix = "." + suffix;
        }
        return this;
    }
}

