/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.droidium.container.utils;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.arquillian.droidium.container.api.FileType;
import org.arquillian.droidium.container.api.IdentifierGenerator;
import org.arquillian.droidium.container.api.IdentifierType;
import org.arquillian.droidium.container.utils.AndroidIdentifierGenerator;
import org.jboss.arquillian.container.spi.client.deployment.Validate;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;

public class DroidiumFileUtils {
    private static final Logger logger = Logger.getLogger(DroidiumFileUtils.class.getName());
    private static File tmpDir = null;
    private static final IdentifierGenerator<FileType> aig = new AndroidIdentifierGenerator();

    public static void removeDir(File dir) {
        try {
            FileUtils.deleteDirectory((File)dir);
        }
        catch (IOException ex) {
            logger.log(Level.INFO, "Unable to delete directory {0}. Reason: {1}", new Object[]{dir.getAbsolutePath(), ex.getMessage()});
        }
    }

    public static void removeDir(String dir) {
        DroidiumFileUtils.removeDir(new File(dir));
    }

    public static File getTmpDir() {
        return tmpDir;
    }

    public static void createTmpDir(File parent) {
        try {
            tmpDir = parent;
            boolean created = tmpDir.mkdirs();
            if (!created) {
                throw new RuntimeException("Unable to create temporary directory " + tmpDir.getAbsolutePath());
            }
        }
        catch (SecurityException ex) {
            logger.severe("Security manager denies to create the working dir in " + parent.getAbsolutePath());
            throw new RuntimeException("Unable to create working directory in " + parent.getAbsolutePath());
        }
    }

    public static File createRandomEmptyFile(File parent) {
        File temp;
        try {
            while (!(temp = new File(parent, aig.getIdentifier((IdentifierType)FileType.FILE))).createNewFile()) {
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to create file in " + parent.getAbsolutePath());
        }
        return temp;
    }

    public static File copyFileToDirectory(File src, File dest) {
        try {
            FileUtils.copyFileToDirectory((File)src, (File)dest);
            return new File(dest, src.getName());
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to copy " + src.getAbsolutePath() + " to " + dest.getAbsolutePath());
        }
    }

    public static String getRandomAPKFileName() {
        return aig.getIdentifier((IdentifierType)FileType.APK);
    }

    public static File export(Archive<?> fromArchive, File toFile) {
        Validate.notNull(fromArchive, (String)"Archive to export from can not be a null object!");
        Validate.notNull((Object)toFile, (String)"File to export archive to can not be a null object!");
        if (toFile.exists() && toFile.isFile() && !toFile.delete()) {
            logger.fine("File to export the archive to exists and it can not be removed.");
        }
        ((ZipExporter)fromArchive.as(ZipExporter.class)).exportTo(toFile, true);
        return toFile;
    }

    public static File export(Archive<?> fromArchive) {
        Validate.notNull(fromArchive, (String)"Archive to export from can not be a null object!");
        if (DroidiumFileUtils.getTmpDir() == null) {
            throw new IllegalStateException("Please call DroidiumFileUtils.createTmpDir(File) before calling this method.");
        }
        File toFile = new File(DroidiumFileUtils.getTmpDir(), DroidiumFileUtils.getRandomAPKFileName());
        return DroidiumFileUtils.export(fromArchive, toFile);
    }
}

