/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.requirement;

import java.lang.annotation.Annotation;
import java.util.ServiceLoader;
import org.arquillian.cube.spi.requirement.Constraint;
import org.arquillian.cube.spi.requirement.Requires;
import org.arquillian.cube.spi.requirement.UnsatisfiedRequirementException;

class Constraints {
    private Constraints() {
        throw new UnsupportedOperationException("Utility Class");
    }

    static void checkConstraint(Requires requires, Annotation context) throws UnsatisfiedRequirementException {
        if (requires == null) {
            return;
        }
        for (Class constraintType : requires.value()) {
            try {
                Constraint constraint = constraintType.isInterface() ? Constraints.loadConstraint(context) : (Constraint)constraintType.newInstance();
                constraint.check((Object)context);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static Constraint loadConstraint(Annotation context) {
        Constraint constraint = null;
        ServiceLoader<Constraint> constraints = ServiceLoader.load(Constraint.class);
        for (Constraint aConstraint : constraints) {
            try {
                aConstraint.getClass().getDeclaredMethod("check", context.annotationType());
                constraint = aConstraint;
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        if (constraint == null) {
            throw new IllegalStateException("Couldn't found any implementation of " + Constraint.class.getName());
        }
        return constraint;
    }
}

