/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.q.api;

import java.util.concurrent.TimeUnit;
import org.arquillian.cube.q.api.Q;

public interface NetworkChaos {
    public Action on(String var1, int var2);

    public static final class TimeoutType
    extends Q.LongType {
        protected TimeoutType(long value) {
            super(value);
        }

        public static TimeoutType timeoutInMillis(long time) {
            return new TimeoutType(time);
        }

        public static TimeoutType timeout(long time, TimeUnit timeUnit) {
            return new TimeoutType(timeUnit.toMillis(time));
        }
    }

    public static final class LatencyType
    extends Q.LongType {
        protected LatencyType(long value) {
            super(value);
        }

        public static LatencyType latencyInMillis(long time) {
            return new LatencyType(time);
        }

        public static LatencyType latency(long time, TimeUnit timeUnit) {
            return new LatencyType(timeUnit.toMillis(time));
        }
    }

    public static final class JitterType
    extends Q.IntegerType {
        protected JitterType(int value) {
            super(value);
        }

        public static JitterType jitter(int jitter) {
            return new JitterType(jitter);
        }
    }

    public static final class RateType
    extends Q.LongType {
        protected RateType(long value) {
            super(value);
        }

        public static RateType rate(long rate) {
            return new RateType(rate);
        }
    }

    public static final class DelayType
    extends Q.LongType {
        protected DelayType(long value) {
            super(value);
        }

        public static DelayType delayInMillis(long delay) {
            return new DelayType(delay);
        }

        public static DelayType delay(long delay, TimeUnit timeUnit) {
            return new DelayType(timeUnit.toMillis(delay));
        }
    }

    public static final class SliceAverageSizeType
    extends Q.LongType {
        protected SliceAverageSizeType(long value) {
            super(value);
        }

        public static SliceAverageSizeType sliceAverageSize(long average) {
            return new SliceAverageSizeType(average);
        }
    }

    public static final class SliceSizeVariationType
    extends Q.LongType {
        protected SliceSizeVariationType(long value) {
            super(value);
        }

        public static SliceSizeVariationType sliceSizeVariation(long sizeVariation) {
            return new SliceSizeVariationType(sizeVariation);
        }
    }

    public static final class ToxicityType
    extends Q.FloatType {
        protected ToxicityType(float value) {
            super(value);
        }

        public static ToxicityType fullToxic() {
            return new ToxicityType(1.0f);
        }

        public static ToxicityType noToxic() {
            return new ToxicityType(0.0f);
        }

        public static ToxicityType toxicity(float toxicity) {
            return new ToxicityType(toxicity);
        }
    }

    public static enum ToxicDirectionStream {
        DOWNSTREAM,
        UPSTREAM;

    }

    public static interface Action
    extends Q {
        public Action down();

        public Action timeout(TimeoutType var1);

        public Action timeout(TimeoutType var1, ToxicityType var2, ToxicDirectionStream var3);

        public Action latency(LatencyType var1);

        public Action latency(LatencyType var1, JitterType var2, ToxicityType var3, ToxicDirectionStream var4);

        public Action bandwidth(RateType var1);

        public Action bandwidth(RateType var1, ToxicityType var2, ToxicDirectionStream var3);

        public Action slowClose(DelayType var1);

        public Action slowClose(DelayType var1, ToxicityType var2, ToxicDirectionStream var3);

        public Action slice(SliceAverageSizeType var1, DelayType var2);

        public Action slice(SliceAverageSizeType var1, DelayType var2, SliceSizeVariationType var3, ToxicityType var4, ToxicDirectionStream var5);
    }
}

